/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ExchangeMemory
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private String m_sourceStorageName;
    private String m_targetStorageName;

    public ExchangeMemory(GPConfiguration a_conf, String a_firstStorageName, String a_secondStorageName) throws InvalidConfigurationException {
        super(a_conf, 0, CommandGene.VoidClass);
        if (a_firstStorageName == null || a_firstStorageName.length() < 1) {
            throw new IllegalArgumentException("First memory name must not be empty!");
        }
        if (a_secondStorageName == null || a_secondStorageName.length() < 1) {
            throw new IllegalArgumentException("Second memory name must not be empty!");
        }
        if (a_firstStorageName.equals(a_secondStorageName)) {
            throw new IllegalArgumentException("First and second memory name must be different!");
        }
        this.m_sourceStorageName = a_firstStorageName;
        this.m_targetStorageName = a_secondStorageName;
    }

    public String toString() {
        return "exchange(" + this.m_sourceStorageName + ", " + this.m_targetStorageName + ")";
    }

    public String getName() {
        return "Exchange Memory";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            Object value1 = this.getGPConfiguration().readFromMemory(this.m_sourceStorageName);
            Object value2 = this.getGPConfiguration().readFromMemory(this.m_targetStorageName);
            this.getGPConfiguration().storeInMemory(this.m_sourceStorageName, value2);
            this.getGPConfiguration().storeInMemory(this.m_targetStorageName, value1);
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ExchangeMemory without preceeding StoreTerminal");
        }
    }

    public boolean isAffectGlobalState() {
        return true;
    }

    public boolean isValid(ProgramChromosome a_program) {
        return true;
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return null;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        ExchangeMemory other = (ExchangeMemory)a_other;
        return new CompareToBuilder().append((Object)this.m_sourceStorageName, (Object)other.m_sourceStorageName).append((Object)this.m_targetStorageName, (Object)other.m_targetStorageName).toComparison();
    }

    public boolean equals(Object a_other) {
        if (a_other == null) {
            return false;
        }
        try {
            ExchangeMemory other = (ExchangeMemory)a_other;
            return new EqualsBuilder().append((Object)this.m_sourceStorageName, (Object)other.m_sourceStorageName).append((Object)this.m_targetStorageName, (Object)other.m_targetStorageName).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            ExchangeMemory result = new ExchangeMemory(this.getGPConfiguration(), this.m_sourceStorageName, this.m_targetStorageName);
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

