/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import weka.classifiers.evaluation.Evaluation;
import weka.gui.beans.PluginManager;

public abstract class AbstractEvaluationMetric
implements Serializable {
    private static final long serialVersionUID = -924507718482386887L;
    protected Evaluation m_baseEvaluation;

    public static ArrayList<AbstractEvaluationMetric> getPluginMetrics() {
        ArrayList<AbstractEvaluationMetric> pluginMetricsList = null;
        Set<String> pluginMetrics = PluginManager.getPluginNamesOfType(AbstractEvaluationMetric.class.getName());
        if (pluginMetrics != null) {
            pluginMetricsList = new ArrayList<AbstractEvaluationMetric>();
            for (String metric : pluginMetrics) {
                try {
                    Object impl = PluginManager.getPluginInstance(AbstractEvaluationMetric.class.getName(), metric);
                    if (!(impl instanceof AbstractEvaluationMetric)) continue;
                    pluginMetricsList.add((AbstractEvaluationMetric)impl);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return pluginMetricsList;
    }

    public void setBaseEvaluation(Evaluation eval) {
        this.m_baseEvaluation = eval;
    }

    public abstract boolean appliesToNominalClass();

    public abstract boolean appliesToNumericClass();

    public abstract String getMetricName();

    public abstract String getMetricDescription();

    public abstract List<String> getStatisticNames();

    public abstract double getStatistic(String var1);

    public class UnknownStatisticException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -8787045492227999839L;

        public UnknownStatisticException(String message) {
            super(message);
        }
    }
}

