/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractStoringPageFile;
import de.lmu.ifi.dbs.elki.persistent.ExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

public class PersistentPageFile<P extends ExternalizablePage>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(PersistentPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private final RandomAccessFile file;
    protected PageHeader header;
    protected final Class<P> pageclass;
    private boolean existed;

    public PersistentPageFile(int n, String string, Class<P> clazz) {
        super(n);
        this.pageclass = clazz;
        File file = new File(string);
        this.existed = file.exists();
        try {
            this.file = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new AbortException("IO error in loading persistent page file.", iOException);
        }
    }

    @Override
    public P readPage(int n) {
        try {
            this.countRead();
            long l = (long)(this.header.getReservedPages() + n) * (long)this.pageSize;
            byte[] byArray = new byte[this.pageSize];
            this.file.seek(l);
            this.file.read(byArray);
            return this.byteArrayToPage(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred during reading of page " + n + "\n", iOException);
        }
    }

    @Override
    public void deletePage(int n) {
        try {
            super.deletePage(n);
            this.countWrite();
            byte[] byArray = this.pageToByteArray(null);
            long l = (long)(this.header.getReservedPages() + n) * (long)this.pageSize;
            this.file.seek(l);
            this.file.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void writePage(int n, P p) {
        try {
            this.countWrite();
            byte[] byArray = this.pageToByteArray(p);
            long l = (long)(this.header.getReservedPages() + n) * (long)this.pageSize;
            assert (l >= 0L) : this.header.getReservedPages() + " " + n + " " + this.pageSize + " " + l;
            this.file.seek(l);
            this.file.write(byArray);
            p.setDirty(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing to page file.", iOException);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
            if (!this.emptyPages.isEmpty() && this.header instanceof TreeIndexHeader) {
                ((TreeIndexHeader)this.header).writeEmptyPages(this.emptyPages, this.file);
            }
            ((TreeIndexHeader)this.header).setLargestPageID(this.nextPageID);
            this.header.writeHeader(this.file);
            this.file.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.setLength(this.header.size());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private P byteArrayToPage(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            int n = objectInputStream.readInt();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                ExternalizablePage externalizablePage;
                try {
                    externalizablePage = (ExternalizablePage)this.pageclass.newInstance();
                    externalizablePage.readExternal(objectInputStream);
                }
                catch (InstantiationException instantiationException) {
                    throw new AbortException("Error instanciating an index page", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AbortException("Error instanciating an index page", illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AbortException("Error instanciating an index page", classNotFoundException);
                }
                return (P)externalizablePage;
            }
            throw new IllegalArgumentException("Unknown type: " + n);
        }
        catch (IOException iOException) {
            throw new AbortException("IO Error in page file", iOException);
        }
    }

    private byte[] pageToByteArray(P p) {
        try {
            if (p == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeInt(0);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = new byte[this.pageSize];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                return byArray2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeInt(1);
            p.writeExternal(objectOutputStream);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + p + " is greater than specified" + " pagesize: " + byArray.length + " > " + this.pageSize);
            }
            if (byArray.length == this.pageSize) {
                return byArray;
            }
            byte[] byArray3 = new byte[this.pageSize];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            return byArray3;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred! ", iOException);
        }
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public PageHeader getHeader() {
        return this.header;
    }

    @Override
    public void setNextPageID(int n) {
        this.nextPageID = n;
        while (!this.emptyPages.isEmpty() && (Integer)this.emptyPages.peek() >= this.nextPageID) {
            this.emptyPages.pop();
        }
    }

    @Override
    public boolean initialize(PageHeader pageHeader) {
        block11: {
            try {
                if (this.existed) {
                    LOG.debug("Initializing from an existing page file.");
                    this.header = pageHeader;
                    pageHeader.readHeader(this.file);
                    if (pageHeader instanceof TreeIndexHeader) {
                        TreeIndexHeader treeIndexHeader = (TreeIndexHeader)pageHeader;
                        this.nextPageID = treeIndexHeader.getLargestPageID();
                        try {
                            this.emptyPages = treeIndexHeader.readEmptyPages(this.file);
                            break block11;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new RuntimeException("ClassNotFoundException occurred when reading empty pages.", classNotFoundException);
                        }
                    }
                    int n = 0;
                    while (this.file.getFilePointer() + (long)this.pageSize <= this.file.length()) {
                        long l = (long)(pageHeader.getReservedPages() + n) * (long)this.pageSize;
                        byte[] byArray = new byte[this.pageSize];
                        this.file.seek(l);
                        this.file.read(byArray);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        int n2 = objectInputStream.readInt();
                        if (n2 == 0) {
                            this.emptyPages.push(n);
                        } else if (n2 == 1) {
                            this.nextPageID = n + 1;
                        } else {
                            throw new IllegalArgumentException("Unknown type: " + n2);
                        }
                        ++n;
                    }
                    break block11;
                }
                LOG.debug("Initializing with a new page file.");
                this.header = pageHeader;
                pageHeader.writeHeader(this.file);
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException occurred.", iOException);
            }
        }
        return this.existed;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

