/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class TestHashcode {
    private static final String CVS_REVISION = "$Revision: 1.8 $";
    private boolean m_verbose;
    private double m_AverageMin = 0.0;
    private double m_AverageMax = 1.0;
    private double m_StdDevMin = 1.0;
    private double m_StdDevMax = 2.0;
    private double m_fractionUnique = 0.9;
    private double m_actualFractionUnique = 0.0;

    public void setVerbose(boolean a_verbose) {
        this.m_verbose = a_verbose;
    }

    public void setAverageMax(double a_averageMax) {
        this.m_AverageMax = a_averageMax;
    }

    public void setAverageMin(double a_averageMin) {
        this.m_AverageMin = a_averageMin;
    }

    public void setStdDevMax(double a_stdDevMax) {
        this.m_StdDevMax = a_stdDevMax;
    }

    public void setStdDevMin(double a_stdDevMin) {
        this.m_StdDevMin = a_stdDevMin;
    }

    public void setFractionUnique(double a_fractionUnique) {
        if (a_fractionUnique < 0.0 || a_fractionUnique > 1.0) {
            throw new IllegalArgumentException("fractionUnique must be between 0.0 and 1.0");
        }
        this.m_fractionUnique = a_fractionUnique;
    }

    public double getActualFractionUnique() {
        return this.m_actualFractionUnique;
    }

    public boolean testHashCodeUniqueness(List a_ObjectList) {
        boolean result = false;
        int numObjects = a_ObjectList.size();
        Hashtable<Integer, Integer> hashCodes = new Hashtable<Integer, Integer>();
        for (int index = 0; index < numObjects; ++index) {
            int hashcode = a_ObjectList.get(index).hashCode();
            Integer key = new Integer(hashcode);
            if (hashCodes.containsKey(key)) {
                int newvalue = (Integer)hashCodes.get(key) + 1;
                hashCodes.put(key, new Integer(newvalue));
                continue;
            }
            hashCodes.put(key, new Integer(1));
        }
        this.m_actualFractionUnique = (double)hashCodes.size() / (double)numObjects;
        result = !(this.m_actualFractionUnique < this.m_fractionUnique);
        return result;
    }

    public boolean testHashCodeEquality(List a_ObjectList) {
        long numObjects = a_ObjectList.size();
        if (numObjects < 2L) {
            return false;
        }
        int hashCode = a_ObjectList.get(0).hashCode();
        int index = 1;
        while ((long)index < numObjects) {
            if (hashCode != a_ObjectList.get(index).hashCode()) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean testDispersion(List a_ObjectList) {
        boolean result = false;
        int[] hashCodes = new int[a_ObjectList.size()];
        long numObjects = a_ObjectList.size();
        double average = 0.0;
        int index = 0;
        while ((long)index < numObjects) {
            hashCodes[index] = a_ObjectList.get(index).hashCode();
            ++index;
        }
        index = 0;
        while ((long)index < numObjects) {
            average += (double)hashCodes[index];
            ++index;
        }
        average /= (double)numObjects;
        double sumOfSquare = 0.0;
        double squareOfSum = 0.0;
        index = 0;
        while ((long)index < numObjects) {
            sumOfSquare += (double)hashCodes[index] * (double)hashCodes[index];
            squareOfSum += (double)hashCodes[index];
            ++index;
        }
        squareOfSum *= squareOfSum;
        double stdDev = sumOfSquare * (double)numObjects - squareOfSum;
        stdDev /= (double)(numObjects * (numObjects - 1L));
        stdDev = Math.sqrt(stdDev);
        if (this.m_verbose) {
            System.out.println("Average =" + average + " StdDev =" + stdDev);
            System.out.println("Average - StdDev =" + (average - stdDev));
            System.out.println("Average + StdDev =" + (average + stdDev));
        }
        result = this.m_AverageMin < average && average < this.m_AverageMax;
        result = this.m_StdDevMin < stdDev && stdDev < this.m_StdDevMax ? (result &= true) : false;
        return result;
    }

    public static void main(String[] args) {
        TestHashcode th = new TestHashcode();
        ArrayList<BigDecimal> tl = new ArrayList<BigDecimal>();
        for (int com = 600000; com < 600100; ++com) {
            tl.add(new BigDecimal(com));
        }
        th.testDispersion(tl);
        th.setFractionUnique(0.8);
        th.testHashCodeUniqueness(tl);
    }
}

