/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;

public class ParameterizationFunction {
    public static final double DELTA = 1.0E-10;
    private double[] alphaExtremum;
    private ExtremumType extremumType;
    private NumberVector vec;

    public ParameterizationFunction(NumberVector numberVector) {
        this.vec = numberVector;
        this.determineGlobalExtremum();
    }

    public double function(double[] dArray) {
        int n = this.vec.getDimensionality();
        if (dArray.length != n - 1) {
            throw new IllegalArgumentException("Parameter alpha must have a dimensionality of " + (n - 1) + ", read: " + dArray.length);
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = i == n - 1 ? 0.0 : dArray[i];
            d += this.vec.doubleValue(i) * this.sinusProduct(0, i, dArray) * Math.cos(d2);
        }
        return d;
    }

    public HyperBoundingBox determineAlphaMinMax(HyperBoundingBox hyperBoundingBox) {
        int n = this.vec.getDimensionality();
        if (hyperBoundingBox.getDimensionality() != n - 1) {
            throw new IllegalArgumentException("Interval needs to have dimensionality d=" + (n - 1) + ", read: " + hyperBoundingBox.getDimensionality());
        }
        if (this.extremumType.equals((Object)ExtremumType.CONSTANT)) {
            double[] dArray = SpatialUtil.centroid(hyperBoundingBox);
            return new HyperBoundingBox(dArray, dArray);
        }
        double[] dArray = new double[n - 1];
        double[] dArray2 = new double[n - 1];
        if (SpatialUtil.contains((SpatialComparable)hyperBoundingBox, this.alphaExtremum)) {
            if (this.extremumType.equals((Object)ExtremumType.MINIMUM)) {
                dArray = this.alphaExtremum;
                for (int i = n - 2; i >= 0; --i) {
                    dArray2[i] = this.determineAlphaMax(i, dArray2, hyperBoundingBox);
                }
            } else {
                dArray2 = this.alphaExtremum;
                for (int i = n - 2; i >= 0; --i) {
                    dArray[i] = this.determineAlphaMin(i, dArray, hyperBoundingBox);
                }
            }
        } else {
            for (int i = n - 2; i >= 0; --i) {
                dArray[i] = this.determineAlphaMin(i, dArray, hyperBoundingBox);
                dArray2[i] = this.determineAlphaMax(i, dArray2, hyperBoundingBox);
            }
        }
        return new HyperBoundingBox(dArray, dArray2);
    }

    private ExtremumType extremumType(int n, double[] dArray, HyperBoundingBox hyperBoundingBox) {
        if (n == dArray.length - 1) {
            return this.extremumType;
        }
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
        double[] dArray5 = SpatialUtil.centroid(hyperBoundingBox);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray5[i];
            dArray3[i] = dArray5[i];
            dArray4[i] = dArray5[i];
        }
        double d = hyperBoundingBox.getMax(n) - hyperBoundingBox.getMin(n);
        dArray2[n] = Math.random() * d + hyperBoundingBox.getMin(n);
        dArray3[n] = Math.random() * d + hyperBoundingBox.getMin(n);
        double d2 = this.function(dArray4);
        double d3 = this.function(dArray2);
        double d4 = this.function(dArray3);
        if (d3 < d2 && (d4 < d2 || Math.abs(d4 - d2) < 1.0E-10)) {
            return ExtremumType.MAXIMUM;
        }
        if (d4 < d2 && (d3 < d2 || Math.abs(d3 - d2) < 1.0E-10)) {
            return ExtremumType.MAXIMUM;
        }
        if (d3 > d2 && (d4 > d2 || Math.abs(d4 - d2) < 1.0E-10)) {
            return ExtremumType.MINIMUM;
        }
        if (d4 > d2 && (d3 > d2 || Math.abs(d3 - d2) < 1.0E-10)) {
            return ExtremumType.MINIMUM;
        }
        if (Math.abs(d3 - d2) < 1.0E-10 && Math.abs(d4 - d2) < 1.0E-10) {
            return ExtremumType.CONSTANT;
        }
        throw new IllegalArgumentException("Houston, we have a problem!\n" + this + "\n" + "f_l " + d3 + "\n" + "f_c " + d2 + "\n" + "f_r " + d4 + "\n" + "p " + this.vec.getColumnVector() + "\n" + "alpha   " + FormatUtil.format(dArray4) + "\n" + "alpha_l " + FormatUtil.format(dArray2) + "\n" + "alpha_r " + FormatUtil.format(dArray3) + "\n" + "n " + n);
    }

    private double determineAlphaMin(int n, double[] dArray, HyperBoundingBox hyperBoundingBox) {
        double d = this.extremum_alpha_n(n, dArray);
        double d2 = hyperBoundingBox.getMin(n);
        double d3 = hyperBoundingBox.getMax(n);
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, n, dArray2, n, dArray2.length - n);
        dArray2[n] = d;
        ExtremumType extremumType = this.extremumType(n, dArray2, hyperBoundingBox);
        if (extremumType.equals((Object)ExtremumType.MINIMUM) || extremumType.equals((Object)ExtremumType.CONSTANT)) {
            if (d2 <= d && d <= d3) {
                return d;
            }
            if (d < d2) {
                return d2;
            }
            if (d <= d3) {
                throw new IllegalStateException("Should never happen!");
            }
            return d3;
        }
        if (d2 <= d && d <= d3) {
            if (d - d2 <= d3 - d) {
                return d3;
            }
            return d2;
        }
        if (d < d2) {
            return d3;
        }
        if (d <= d3) {
            throw new IllegalStateException("Should never happen!");
        }
        return d2;
    }

    private double determineAlphaMax(int n, double[] dArray, HyperBoundingBox hyperBoundingBox) {
        double d = this.extremum_alpha_n(n, dArray);
        double d2 = hyperBoundingBox.getMin(n);
        double d3 = hyperBoundingBox.getMax(n);
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, n, dArray2, n, dArray2.length - n);
        dArray2[n] = d;
        ExtremumType extremumType = this.extremumType(n, dArray2, hyperBoundingBox);
        if (extremumType.equals((Object)ExtremumType.MINIMUM) || extremumType.equals((Object)ExtremumType.CONSTANT)) {
            if (d2 <= d && d <= d3) {
                if (d - d2 <= d3 - d) {
                    return d3;
                }
                return d2;
            }
            if (d < d2) {
                return d3;
            }
            if (d <= d3) {
                throw new IllegalStateException("Should never happen!");
            }
            return d2;
        }
        if (d2 <= d && d <= d3) {
            return d;
        }
        if (d < d2) {
            return d2;
        }
        if (d <= d3) {
            throw new IllegalStateException("Should never happen!");
        }
        return d3;
    }

    public double[] getGlobalAlphaExtremum() {
        return this.alphaExtremum;
    }

    public double getGlobalExtremum() {
        return this.function(this.alphaExtremum);
    }

    public ExtremumType getGlobalExtremumType() {
        return this.extremumType;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.vec.getDimensionality(); ++i) {
            if (i != 0) {
                stringBuilder.append(" + \n").append(FormatUtil.whitespace(n));
            }
            stringBuilder.append(this.vec.doubleValue(i));
            for (int j = 0; j < i; ++j) {
                stringBuilder.append(" * sin(a_").append(j + 1).append(')');
            }
            if (i == this.vec.getDimensionality() - 1) continue;
            stringBuilder.append(" * cos(a_").append(i + 1).append(')');
        }
        return stringBuilder.toString();
    }

    private double sinusProduct(int n, int n2, double[] dArray) {
        double d = 1.0;
        for (int i = n; i < n2; ++i) {
            d *= Math.sin(dArray[i]);
        }
        return d;
    }

    private void determineGlobalExtremum() {
        this.alphaExtremum = new double[this.vec.getDimensionality() - 1];
        for (int i = this.alphaExtremum.length - 1; i >= 0; --i) {
            this.alphaExtremum[i] = this.extremum_alpha_n(i, this.alphaExtremum);
            if (!Double.isNaN(this.alphaExtremum[i])) continue;
            throw new IllegalStateException("Houston, we have a problem!\n" + this + "\n" + this.vec.getColumnVector() + "\n" + FormatUtil.format(this.alphaExtremum));
        }
        this.determineGlobalExtremumType();
    }

    private void determineGlobalExtremumType() {
        double d = this.function(this.alphaExtremum);
        double[] dArray = new double[this.alphaExtremum.length];
        double[] dArray2 = new double[this.alphaExtremum.length];
        for (int i = 0; i < this.alphaExtremum.length; ++i) {
            dArray[i] = Math.random() * Math.PI;
            dArray2[i] = Math.random() * Math.PI;
        }
        double d2 = this.function(dArray);
        double d3 = this.function(dArray2);
        if (d2 < d && d3 < d) {
            this.extremumType = ExtremumType.MAXIMUM;
        } else if (d2 > d && d3 > d) {
            this.extremumType = ExtremumType.MINIMUM;
        } else if (Math.abs(d2 - d) < 1.0E-10 && Math.abs(d3 - d) < 1.0E-10) {
            this.extremumType = ExtremumType.CONSTANT;
        } else {
            throw new IllegalStateException("Houston, we have a problem:\n" + this + "\nextremum at " + FormatUtil.format(this.alphaExtremum) + "\nf  " + d + "\nf1 " + d2 + "\nf2 " + d3);
        }
    }

    private double extremum_alpha_n(int n, double[] dArray) {
        if (this.vec.doubleValue(n) == 0.0) {
            return 1.5707963267948966;
        }
        double d = 0.0;
        for (int i = n + 1; i < this.vec.getDimensionality(); ++i) {
            double d2 = i == this.vec.getDimensionality() - 1 ? 0.0 : dArray[i];
            d += this.vec.doubleValue(i) * this.sinusProduct(n + 1, i, dArray) * Math.cos(d2);
        }
        double d3 = Math.atan(d /= this.vec.doubleValue(n));
        if (d3 < 0.0) {
            d3 = Math.PI + d3;
        }
        return d3;
    }

    public Vector getColumnVector() {
        return this.vec.getColumnVector();
    }

    public int getDimensionality() {
        return this.vec.getDimensionality();
    }

    public static enum ExtremumType {
        MINIMUM,
        MAXIMUM,
        CONSTANT;

    }
}

