/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.PreDeCon;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="C. B\u00f6hm, K. Kailing, H.-P. Kriegel, P. Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04), Brighton, UK, 2004", url="http://dx.doi.org/10.1109/ICDM.2004.10087")
public class PreDeConNeighborPredicate<V extends NumberVector>
extends AbstractRangeQueryNeighborPredicate<V, PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(PreDeConNeighborPredicate.class);
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvVar = new MeanVariance();
    private PreDeCon.Settings settings;

    public PreDeConNeighborPredicate(PreDeCon.Settings settings) {
        super(settings.epsilon * settings.epsilon, SquaredEuclideanDistanceFunction.STATIC);
        this.settings = settings;
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        DistanceQuery distanceQuery = QueryUtil.getDistanceQuery(database, this.distFunc, new Object[0]);
        Relation relation = distanceQuery.getRelation();
        RangeQuery rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        this.mvSize.reset();
        this.mvVar.reset();
        DataStore<PreDeConModel> dataStore = this.preprocess(PreDeConModel.class, relation, rangeQuery);
        if (LOG.isVerbose()) {
            LOG.verbose("Average neighborhood size: " + this.mvSize.toString());
            LOG.verbose("Average variance size: " + this.mvVar.toString());
            int n = RelationUtil.dimensionality(relation);
            if (this.mvSize.getMean() < (double)(5 * n)) {
                LOG.verbose("The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose("The epsilon parameter may be chosen too large.");
            } else {
                LOG.verbose("As a first guess, you can try minPts < " + (int)this.mvSize.getMean() / n + " and delta > " + this.mvVar.getMean() + ", but you will need to experiment with these parameters and epsilon.");
            }
        }
        return new Instance(distanceQuery.getRelation().getDBIDs(), dataStore);
    }

    @Override
    protected PreDeConModel computeLocalModel(DBIDRef dBIDRef, DoubleDBIDList doubleDBIDList, Relation<V> relation) {
        int n;
        int n2 = doubleDBIDList.size();
        this.mvSize.put(n2);
        if (n2 < 0) {
            LOG.warning("Empty reference set - should at least include the query point!");
            return new PreDeConModel(Integer.MAX_VALUE, DBIDUtil.EMPTYDBIDS);
        }
        NumberVector numberVector = (NumberVector)relation.get(dBIDRef);
        int n3 = numberVector.getDimensionality();
        double[] dArray = new double[n3];
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        while (doubleDBIDListIter.valid()) {
            NumberVector numberVector2 = (NumberVector)relation.get(doubleDBIDListIter);
            n = 0;
            while (n < n3) {
                double d = numberVector.doubleValue(n) - numberVector2.doubleValue(n);
                int n4 = n++;
                dArray[n4] = dArray[n4] + d * d;
            }
            doubleDBIDListIter.advance();
        }
        for (int i = 0; i < n3; ++i) {
            int n5 = i;
            dArray[n5] = dArray[n5] / (double)n2;
            this.mvVar.put(dArray[i]);
        }
        double[] dArray2 = new double[n3];
        int n6 = 0;
        for (n = 0; n < n3; ++n) {
            if (dArray[n] <= this.settings.delta) {
                dArray2[n] = this.settings.kappa;
                ++n6;
                continue;
            }
            dArray2[n] = 1.0;
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(n2);
        DoubleDBIDListIter doubleDBIDListIter2 = doubleDBIDList.iter();
        while (doubleDBIDListIter2.valid()) {
            NumberVector numberVector3 = (NumberVector)relation.get(doubleDBIDListIter2);
            double d = 0.0;
            for (int i = 0; i < n3; ++i) {
                double d2 = numberVector.doubleValue(i) - numberVector3.doubleValue(i);
                d += dArray2[i] * d2 * d2;
            }
            if (d <= this.epsilon) {
                hashSetModifiableDBIDs.add(doubleDBIDListIter2);
            }
            doubleDBIDListIter2.advance();
        }
        return new PreDeConModel(n6, hashSetModifiableDBIDs);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{new SimpleTypeInformation<PreDeConModel>(PreDeConModel.class)};
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected PreDeCon.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(PreDeCon.Settings.class);
        }

        @Override
        protected PreDeConNeighborPredicate<V> makeInstance() {
            return new PreDeConNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConModel, PreDeConModel> {
        public Instance(DBIDs dBIDs, DataStore<PreDeConModel> dataStore) {
            super(dBIDs, dataStore);
        }

        @Override
        public PreDeConModel getNeighbors(DBIDRef dBIDRef) {
            PreDeConModel preDeConModel = (PreDeConModel)this.storage.get(dBIDRef);
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(preDeConModel.ids.size());
            DBIDIter dBIDIter = preDeConModel.ids.iter();
            while (dBIDIter.valid()) {
                if (((PreDeConModel)this.storage.get((DBIDRef)dBIDIter)).ids.contains(dBIDRef)) {
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            return new PreDeConModel(preDeConModel.pdim, hashSetModifiableDBIDs);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConModel preDeConModel) {
            return preDeConModel.ids.iter();
        }
    }

    public static class PreDeConModel {
        int pdim;
        SetDBIDs ids;

        public PreDeConModel(int n, SetDBIDs setDBIDs) {
            this.pdim = n;
            this.ids = setDBIDs;
        }
    }
}

