/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.HilbertSpatialSorter;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparatorMinHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

@Title(value="Fast Outlier Detection in High Dimensional Spaces")
@Description(value="Algorithm to compute outliers using Hilbert space filling curves")
@Reference(authors="F. Angiulli, C. Pizzuti", title="Fast Outlier Detection in High Dimensional Spaces", booktitle="Proc. European Conference on Principles of Knowledge Discovery and Data Mining (PKDD'02)", url="http://dx.doi.org/10.1145/375663.375668")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.HilOut"})
public class HilOut<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(HilOut.class);
    private int k;
    private int n;
    private int h;
    private double t;
    private Enum<ScoreType> tn;
    private DistanceQuery<O> distq;
    private int capital_n;
    private int n_star;
    private int capital_n_star;
    private int d;
    private double omega_star;

    protected HilOut(LPNormDistanceFunction lPNormDistanceFunction, int n, int n2, int n3, Enum<ScoreType> enum_) {
        super(lPNormDistanceFunction);
        this.n = n2;
        this.k = n - 1;
        this.h = n3;
        this.tn = enum_;
        this.t = lPNormDistanceFunction.getP();
        this.n_star = 0;
        this.omega_star = 0.0;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        ObjectHeap.UnsortedIter unsortedIter;
        Object object;
        int n;
        this.distq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        this.d = RelationUtil.dimensionality(relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        double d = 0.0;
        Object object2 = RelationUtil.computeMinMax(relation);
        double[] dArray = object2[0];
        Object object3 = object2[1];
        for (n = 0; n < this.d; ++n) {
            d = Math.max(d, object3[n] - dArray[n]);
        }
        n = 0;
        while (n < this.d) {
            double d2 = (d - (object3[n] - dArray[n])) * 0.5;
            int n2 = n;
            dArray[n2] = dArray[n2] - d2;
            int n3 = n++;
            object3[n3] = object3[n3] + d2;
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Rescaling dataset by " + 1.0 / d + " to fit the unit cube.");
        }
        this.capital_n_star = this.capital_n = relation.size();
        object2 = new HilbertFeatures(relation, dArray, d);
        object3 = LOG.isVerbose() ? new FiniteProgress("HilOut iterations", this.d + 1, LOG) : null;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("True outliers found", this.n, LOG) : null;
        for (int i = 0; i <= this.d && this.n_star < this.n; ++i) {
            HilFeature hilFeature;
            ((HilbertFeatures)object2).out.clear();
            ((HilbertFeatures)object2).wlb.clear();
            ((HilbertFeatures)object2).initialize(0.5 * (double)i / (double)(this.d + 1));
            this.scan((HilbertFeatures)object2, (int)((double)(this.k * this.capital_n) / (double)this.capital_n_star));
            this.trueOutliers((HilbertFeatures)object2);
            if (finiteProgress != null) {
                finiteProgress.setProcessed(this.n_star, LOG);
            }
            ((HilbertFeatures)object2).top.clear();
            object = DBIDUtil.newHashSet(((HilbertFeatures)object2).out.size());
            unsortedIter = ((HilbertFeatures)object2).out.unsortedIter();
            while (unsortedIter.valid()) {
                hilFeature = (HilFeature)unsortedIter.get();
                object.add(hilFeature.id);
                ((HilbertFeatures)object2).top.add(hilFeature);
                unsortedIter.advance();
            }
            unsortedIter = ((HilbertFeatures)object2).wlb.unsortedIter();
            while (unsortedIter.valid()) {
                hilFeature = (HilFeature)unsortedIter.get();
                if (!object.contains(hilFeature.id)) {
                    ((HilbertFeatures)object2).top.add(hilFeature);
                }
                unsortedIter.advance();
            }
            LOG.incrementProcessed((AbstractProgress)object3);
        }
        if (this.n_star < this.n) {
            ((HilbertFeatures)object2).out.clear();
            ((HilbertFeatures)object2).wlb.clear();
            this.scan((HilbertFeatures)object2, this.capital_n);
        }
        if (object3 != null) {
            ((AbstractProgress)object3).setProcessed(this.d, LOG);
            ((FiniteProgress)object3).ensureCompleted(LOG);
        }
        if (finiteProgress != null) {
            finiteProgress.setProcessed(this.n, LOG);
            finiteProgress.ensureCompleted(LOG);
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        if (this.tn == ScoreType.TopN) {
            doubleMinMax.put(0.0);
            object = relation.iterDBIDs();
            while (object.valid()) {
                writableDoubleDataStore.putDouble((DBIDRef)object, 0.0);
                object.advance();
            }
            object = ((HilbertFeatures)object2).out.unsortedIter();
            while (object.valid()) {
                unsortedIter = (HilFeature)object.get();
                doubleMinMax.put(((HilFeature)((Object)unsortedIter)).ubound);
                writableDoubleDataStore.putDouble(((HilFeature)((Object)unsortedIter)).id, ((HilFeature)((Object)unsortedIter)).ubound);
                object.advance();
            }
        } else {
            for (HilFeature hilFeature : object2.pf) {
                doubleMinMax.put(hilFeature.ubound);
                writableDoubleDataStore.putDouble(hilFeature.id, hilFeature.ubound);
            }
        }
        object = new MaterializedDoubleRelation("HilOut weight", "hilout-weight", writableDoubleDataStore, relation.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
        return outlierResult;
    }

    private void scan(HilbertFeatures hilbertFeatures, int n) {
        int n2 = Math.min(2 * n, this.capital_n - 1);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Scanning with k0=" + n + " (" + n2 + ")" + " N*=" + this.capital_n_star);
        }
        for (int i = 0; i < hilbertFeatures.pf.length; ++i) {
            if (hilbertFeatures.pf[i].ubound < this.omega_star) continue;
            if (hilbertFeatures.pf[i].lbound < hilbertFeatures.pf[i].ubound) {
                double d = hilbertFeatures.fastUpperBound(i);
                if (d < this.omega_star) {
                    hilbertFeatures.pf[i].ubound = d;
                } else {
                    int n3 = hilbertFeatures.top.contains(hilbertFeatures.pf[i]) ? this.capital_n - 1 : n2;
                    this.innerScan(hilbertFeatures, i, n3);
                }
            }
            if (hilbertFeatures.pf[i].ubound > 0.0) {
                hilbertFeatures.updateOUT(i);
            }
            if (hilbertFeatures.pf[i].lbound > 0.0) {
                hilbertFeatures.updateWLB(i);
            }
            if (hilbertFeatures.wlb.size() < this.n) continue;
            this.omega_star = Math.max(this.omega_star, ((HilFeature)((HilbertFeatures)hilbertFeatures).wlb.peek()).lbound);
        }
    }

    private void innerScan(HilbertFeatures hilbertFeatures, int n, int n2) {
        NumberVector numberVector = (NumberVector)hilbertFeatures.relation.get(hilbertFeatures.pf[n].id);
        int n3 = n;
        int n4 = n;
        int n5 = this.h;
        int n6 = this.h;
        int n7 = this.h;
        for (int i = 0; i < n2; ++i) {
            double d;
            int n8;
            int n9;
            if (n3 == 0) {
                n7 = Math.min(n7, hilbertFeatures.pf[n4].level);
                n9 = ++n4;
            } else if (n4 >= this.capital_n - 1) {
                n6 = Math.min(n6, hilbertFeatures.pf[--n3].level);
                n9 = n3;
            } else if (hilbertFeatures.pf[n3 - 1].level >= hilbertFeatures.pf[n4].level) {
                n6 = Math.min(n6, hilbertFeatures.pf[--n3].level);
                n9 = n3;
            } else {
                n7 = Math.min(n7, hilbertFeatures.pf[n4].level);
                n9 = ++n4;
            }
            if (hilbertFeatures.pf[n].nn_keys.contains(hilbertFeatures.pf[n9].id)) continue;
            hilbertFeatures.pf[n].insert(hilbertFeatures.pf[n9].id, this.distq.distance((DBID)((Object)numberVector), hilbertFeatures.pf[n9].id), this.k);
            if (hilbertFeatures.pf[n].nn.size() == this.k && (hilbertFeatures.pf[n].sum_nn < this.omega_star || (n8 = Math.max(n6, n7)) < n5 && (d = hilbertFeatures.minDistLevel(hilbertFeatures.pf[n].id, n5 = n8)) >= hilbertFeatures.pf[n].nn.peek().doubleValue())) break;
        }
        double d = hilbertFeatures.boxRadius(n, n3 - 1, n4 + 1);
        double d2 = 0.0;
        double d3 = 0.0;
        ObjectHeap.UnsortedIter<DoubleDBIDPair> unsortedIter = hilbertFeatures.pf[n].nn.unsortedIter();
        while (unsortedIter.valid()) {
            DoubleDBIDPair doubleDBIDPair = unsortedIter.get();
            d3 += doubleDBIDPair.doubleValue();
            if (doubleDBIDPair.doubleValue() <= d) {
                d2 += doubleDBIDPair.doubleValue();
            }
            unsortedIter.advance();
        }
        if (d2 > hilbertFeatures.pf[n].lbound) {
            hilbertFeatures.pf[n].lbound = d2;
        }
        if (d3 < hilbertFeatures.pf[n].ubound) {
            hilbertFeatures.pf[n].ubound = d3;
        }
    }

    private void trueOutliers(HilbertFeatures hilbertFeatures) {
        this.n_star = 0;
        ObjectHeap.UnsortedIter unsortedIter = hilbertFeatures.out.unsortedIter();
        while (unsortedIter.valid()) {
            HilFeature hilFeature = (HilFeature)unsortedIter.get();
            if (hilFeature.ubound >= this.omega_star && hilFeature.ubound - hilFeature.lbound < 1.0E-10) {
                ++this.n_star;
            }
            unsortedIter.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new LPNormDistanceFunction(this.t).getInputTypeRestriction());
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("HilOut.k", "Compute up to k next neighbors");
        public static final OptionID N_ID = new OptionID("HilOut.n", "Compute n outliers");
        public static final OptionID H_ID = new OptionID("HilOut.h", "Max. Hilbert-Level");
        public static final OptionID T_ID = new OptionID("HilOut.t", "t of Lt Metric");
        public static final OptionID TN_ID = new OptionID("HilOut.tn", "output of Top n or all elements");
        protected int k = 5;
        protected int n = 10;
        protected int h = 32;
        protected LPNormDistanceFunction distfunc;
        protected Enum<ScoreType> tn;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<ScoreType> enumParameter;
            ObjectParameter objectParameter;
            IntParameter intParameter;
            IntParameter intParameter2;
            super.makeOptions(parameterization);
            IntParameter intParameter3 = new IntParameter(K_ID, 5);
            if (parameterization.grab(intParameter3)) {
                this.k = (Integer)intParameter3.getValue();
            }
            if (parameterization.grab(intParameter2 = new IntParameter(N_ID, 10))) {
                this.n = (Integer)intParameter2.getValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(H_ID, 32))) {
                this.h = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(objectParameter = AbstractDistanceBasedAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, LPNormDistanceFunction.class))) {
                this.distfunc = (LPNormDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<ScoreType>(TN_ID, ScoreType.class, ScoreType.TopN))) {
                this.tn = (Enum)enumParameter.getValue();
            }
        }

        @Override
        protected HilOut<O> makeInstance() {
            return new HilOut(this.distfunc, this.k, this.n, this.h, this.tn);
        }
    }

    static final class HilFeature
    implements Comparable<HilFeature> {
        public DBID id;
        public long[] hilbert = null;
        public int level = 0;
        public double ubound = Double.POSITIVE_INFINITY;
        public double lbound = 0.0;
        public ObjectHeap<DoubleDBIDPair> nn;
        public HashSetModifiableDBIDs nn_keys = DBIDUtil.newHashSet();
        public double sum_nn = 0.0;

        public HilFeature(DBID dBID, ObjectHeap<DoubleDBIDPair> objectHeap) {
            this.id = dBID;
            this.nn = objectHeap;
        }

        @Override
        public int compareTo(HilFeature hilFeature) {
            return BitsUtil.compare(this.hilbert, hilFeature.hilbert);
        }

        protected void insert(DBID dBID, double d, int n) {
            if (this.nn.size() < n) {
                DoubleDBIDPair doubleDBIDPair = DBIDUtil.newPair(d, (DBIDRef)dBID);
                this.nn.add(doubleDBIDPair);
                this.nn_keys.add(dBID);
                this.sum_nn += d;
            } else {
                DoubleDBIDPair doubleDBIDPair = this.nn.peek();
                if (d < doubleDBIDPair.doubleValue()) {
                    doubleDBIDPair = this.nn.poll();
                    this.sum_nn -= doubleDBIDPair.doubleValue();
                    this.nn_keys.remove(doubleDBIDPair);
                    DoubleDBIDPair doubleDBIDPair2 = DBIDUtil.newPair(d, (DBIDRef)dBID);
                    this.nn.add(doubleDBIDPair2);
                    this.nn_keys.add(dBID);
                    this.sum_nn += d;
                }
            }
        }
    }

    class HilbertFeatures {
        Relation<O> relation;
        HilFeature[] pf;
        double[] min;
        double diameter;
        double shift;
        private Set<HilFeature> top;
        private ObjectHeap<HilFeature> out;
        private ObjectHeap<HilFeature> wlb;

        public HilbertFeatures(Relation<O> relation, double[] dArray, double d) {
            this.relation = relation;
            this.min = dArray;
            this.diameter = d;
            this.pf = new HilFeature[relation.size()];
            int n = 0;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                this.pf[n++] = new HilFeature(DBIDUtil.deref(dBIDIter), new ComparableMaxHeap<DoubleDBIDPair>(HilOut.this.k));
                dBIDIter.advance();
            }
            this.out = new ComparatorMinHeap<HilFeature>(HilOut.this.n, new Comparator<HilFeature>(){

                @Override
                public int compare(HilFeature hilFeature, HilFeature hilFeature2) {
                    return Double.compare(hilFeature.ubound, hilFeature2.ubound);
                }
            });
            this.wlb = new ComparatorMinHeap<HilFeature>(HilOut.this.n, new Comparator<HilFeature>(){

                @Override
                public int compare(HilFeature hilFeature, HilFeature hilFeature2) {
                    return Double.compare(hilFeature.lbound, hilFeature2.lbound);
                }
            });
            this.top = new HashSet<HilFeature>(2 * HilOut.this.n);
        }

        private void initialize(double d) {
            int n;
            int n2;
            Object object;
            this.shift = d;
            if (HilOut.this.h >= 32) {
                for (int i = 0; i < this.pf.length; ++i) {
                    object = (NumberVector)this.relation.get(this.pf[i].id);
                    long[] lArray = new long[HilOut.this.d];
                    for (int j = 0; j < HilOut.this.d; ++j) {
                        lArray[j] = (long)(this.getDimForObject((NumberVector)object, j) * 0.5 * 9.223372036854776E18);
                    }
                    this.pf[i].hilbert = HilbertSpatialSorter.coordinatesToHilbert(lArray, HilOut.this.h, 1);
                }
            } else if (HilOut.this.h >= 16) {
                for (n2 = 0; n2 < this.pf.length; ++n2) {
                    NumberVector numberVector = (NumberVector)this.relation.get(this.pf[n2].id);
                    object = new int[HilOut.this.d];
                    for (int i = 0; i < HilOut.this.d; ++i) {
                        object[i] = (int)(this.getDimForObject(numberVector, i) * 0.5 * 2.147483647E9);
                    }
                    this.pf[n2].hilbert = HilbertSpatialSorter.coordinatesToHilbert((int[])object, HilOut.this.h, 1);
                }
            } else if (HilOut.this.h >= 8) {
                for (n2 = 0; n2 < this.pf.length; ++n2) {
                    NumberVector numberVector = (NumberVector)this.relation.get(this.pf[n2].id);
                    object = new short[HilOut.this.d];
                    for (int i = 0; i < HilOut.this.d; ++i) {
                        object[i] = (short)(this.getDimForObject(numberVector, i) * 0.5 * 65535.0);
                    }
                    this.pf[n2].hilbert = HilbertSpatialSorter.coordinatesToHilbert((short[])object, HilOut.this.h, 16);
                }
            } else {
                for (n2 = 0; n2 < this.pf.length; ++n2) {
                    NumberVector numberVector = (NumberVector)this.relation.get(this.pf[n2].id);
                    object = new byte[HilOut.this.d];
                    for (int i = 0; i < HilOut.this.d; ++i) {
                        object[i] = (byte)(this.getDimForObject(numberVector, i) * 0.5 * 1.6777215E7);
                    }
                    this.pf[n2].hilbert = HilbertSpatialSorter.coordinatesToHilbert((byte[])object, HilOut.this.h, 24);
                }
            }
            Arrays.sort(this.pf);
            for (n = 0; n < this.pf.length - 1; ++n) {
                this.pf[n].level = this.minRegLevel(n, n + 1);
            }
            HilOut.this.capital_n_star = 0;
            for (n = 0; n < this.pf.length; ++n) {
                if (!(this.pf[n].ubound >= HilOut.this.omega_star)) continue;
                HilOut.this.capital_n_star++;
            }
        }

        private void updateOUT(int n) {
            if (this.out.size() < HilOut.this.n) {
                this.out.add(this.pf[n]);
            } else {
                HilFeature hilFeature = this.out.peek();
                if (this.pf[n].ubound > hilFeature.ubound) {
                    this.out.replaceTopElement(this.pf[n]);
                }
            }
        }

        private void updateWLB(int n) {
            if (this.wlb.size() < HilOut.this.n) {
                this.wlb.add(this.pf[n]);
            } else {
                HilFeature hilFeature = this.wlb.peek();
                if (this.pf[n].lbound > hilFeature.lbound) {
                    this.wlb.replaceTopElement(this.pf[n]);
                }
            }
        }

        private double fastUpperBound(int n) {
            int n2 = n;
            int n3 = n;
            while (n3 - n2 < HilOut.this.k) {
                int n4;
                int n5 = n2 - 1 >= 0 ? this.pf[n2 - 1].level : -2;
                int n6 = n4 = n3 < HilOut.this.capital_n - 1 ? this.pf[n3].level : -2;
                if (n4 >= n5) {
                    ++n3;
                    continue;
                }
                --n2;
            }
            return (double)HilOut.this.k * this.maxDistLevel(this.pf[n].id, this.minRegLevel(n2, n3));
        }

        private double minDistLevel(DBID dBID, int n) {
            NumberVector numberVector = (NumberVector)this.relation.get(dBID);
            double d = 1.0 / (double)(1 << n - 1);
            double d2 = Double.POSITIVE_INFINITY;
            for (int i = 0; i < HilOut.this.d; ++i) {
                double d3 = this.getDimForObject(numberVector, i) % d;
                d2 = Math.min(d2, Math.min(d3, d - d3));
            }
            return d2 * this.diameter;
        }

        private double maxDistLevel(DBID dBID, int n) {
            double d;
            NumberVector numberVector = (NumberVector)this.relation.get(dBID);
            double d2 = 1.0 / (double)(1 << n - 1);
            if (HilOut.this.t == 1.0) {
                d = 0.0;
                for (int i = 0; i < HilOut.this.d; ++i) {
                    double d3 = this.getDimForObject(numberVector, i) % d2;
                    d += Math.max(d3, d2 - d3);
                }
            } else if (HilOut.this.t == 2.0) {
                d = 0.0;
                for (int i = 0; i < HilOut.this.d; ++i) {
                    double d4 = this.getDimForObject(numberVector, i) % d2;
                    double d5 = Math.max(d4, d2 - d4);
                    d += d5 * d5;
                }
                d = Math.sqrt(d);
            } else if (!Double.isInfinite(HilOut.this.t)) {
                d = 0.0;
                for (int i = 0; i < HilOut.this.d; ++i) {
                    double d6 = this.getDimForObject(numberVector, i) % d2;
                    d += Math.pow(Math.max(d6, d2 - d6), HilOut.this.t);
                }
                d = Math.pow(d, 1.0 / HilOut.this.t);
            } else {
                d = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < HilOut.this.d; ++i) {
                    double d7 = this.getDimForObject(numberVector, i) % d2;
                    d = Math.max(d, Math.max(d7, d2 - d7));
                }
            }
            return d * this.diameter;
        }

        private int numberSharedLevels(long[] lArray, long[] lArray2) {
            int n = 0;
            int n2 = lArray.length - 1;
            while (n < lArray.length) {
                long l = lArray[n2] ^ lArray2[n2];
                if (l != 0L) {
                    int n3 = lArray.length * 64 - HilOut.this.d * HilOut.this.h;
                    return (BitsUtil.numberOfLeadingZeros(l) + n * 64 - n3) / HilOut.this.d;
                }
                ++n;
                --n2;
            }
            return HilOut.this.h - 1;
        }

        private int minRegLevel(int n, int n2) {
            return this.numberSharedLevels(this.pf[n].hilbert, this.pf[n2].hilbert);
        }

        private int maxRegLevel(int n, int n2) {
            return this.numberSharedLevels(this.pf[n].hilbert, this.pf[n2].hilbert) + 1;
        }

        private double boxRadius(int n, int n2, int n3) {
            int n4;
            if (n2 < 0) {
                if (n3 >= this.pf.length) {
                    return Double.POSITIVE_INFINITY;
                }
                n4 = this.maxRegLevel(n, n3);
            } else {
                n4 = n3 >= this.pf.length ? this.maxRegLevel(n, n2) : Math.max(this.maxRegLevel(n, n2), this.maxRegLevel(n, n3));
            }
            return this.minDistLevel(this.pf[n].id, n4);
        }

        private double getDimForObject(NumberVector numberVector, int n) {
            return (numberVector.doubleValue(n) - this.min[n]) / this.diameter + this.shift;
        }
    }

    public static enum ScoreType {
        All,
        TopN;

    }
}

