/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleReader;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;

public class BundleDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(BundleDatabaseConnection.class);
    private File infile;

    public BundleDatabaseConnection(List<ObjectFilter> list, File file) {
        super(list);
        this.infile = file;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.infile);
            FileChannel fileChannel = fileInputStream.getChannel();
            MultipleObjectsBundle multipleObjectsBundle = this.invokeStreamFilters(new BundleReader(fileChannel)).asMultipleObjectsBundle();
            fileChannel.close();
            fileInputStream.close();
            return multipleObjectsBundle;
        }
        catch (IOException iOException) {
            throw new AbortException("IO error loading bundle", iOException);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        private static final OptionID BUNDLE_ID = new OptionID("bundle.input", "Bundle file to load the data from.");
        private File infile;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configFilters(parameterization);
            FileParameter fileParameter = new FileParameter(BUNDLE_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.infile = (File)fileParameter.getValue();
            }
        }

        @Override
        protected BundleDatabaseConnection makeInstance() {
            return new BundleDatabaseConnection(this.filters, this.infile);
        }
    }
}

