/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.ClassLabelFilter"})
public class ClassLabelFilter
implements ObjectFilter {
    private final int classLabelIndex;
    private final ClassLabel.Factory<?> classLabelFactory;

    public ClassLabelFilter(int n, ClassLabel.Factory<?> factory) {
        this.classLabelIndex = n;
        this.classLabelFactory = factory;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            if (bl || !LabelList.class.equals(simpleTypeInformation.getRestrictionClass())) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, multipleObjectsBundle.getColumn(i));
                continue;
            }
            bl = true;
            ArrayList arrayList = new ArrayList(multipleObjectsBundle.dataLength());
            ArrayList<LabelList> arrayList2 = new ArrayList<LabelList>(multipleObjectsBundle.dataLength());
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Object obj : multipleObjectsBundle.getColumn(i)) {
                if (obj != null) {
                    LabelList labelList = (LabelList)obj;
                    int n = this.classLabelIndex >= 0 ? this.classLabelIndex : labelList.size() - this.classLabelIndex;
                    try {
                        Object obj2 = this.classLabelFactory.makeFromString(labelList.get(n));
                        arrayList.add(obj2);
                    }
                    catch (Exception exception) {
                        throw new AbortException("Cannot initialize class labels: " + exception.getMessage(), exception);
                    }
                    arrayList3.clear();
                    for (int j = 0; j < labelList.size(); ++j) {
                        if (j == n) continue;
                        arrayList3.add(labelList.get(j));
                    }
                    arrayList2.add(LabelList.make(arrayList3));
                    if (arrayList3.size() <= 0) continue;
                    bl2 = true;
                    continue;
                }
                arrayList.add(null);
                arrayList2.add(null);
            }
            multipleObjectsBundle2.appendColumn(this.classLabelFactory.getTypeInformation(), arrayList);
            if (!bl2) continue;
            multipleObjectsBundle2.appendColumn(simpleTypeInformation, arrayList2);
        }
        return multipleObjectsBundle2;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID CLASS_LABEL_INDEX_ID = new OptionID("dbc.classLabelIndex", "The index of the label to be used as class label. The first label is 0, negative indexes are relative to the end.");
        public static final OptionID CLASS_LABEL_CLASS_ID = new OptionID("dbc.classLabelClass", "Class label class to use.");
        protected int classLabelIndex;
        private ClassLabel.Factory<?> classLabelFactory;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(CLASS_LABEL_INDEX_ID);
            ObjectParameter objectParameter = new ObjectParameter(CLASS_LABEL_CLASS_ID, (Class<?>)ClassLabel.Factory.class, SimpleClassLabel.Factory.class);
            parameterization.grab(intParameter);
            parameterization.grab(objectParameter);
            if (intParameter.isDefined() && objectParameter.isDefined()) {
                this.classLabelIndex = intParameter.intValue();
                this.classLabelFactory = (ClassLabel.Factory)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ClassLabelFilter makeInstance() {
            return new ClassLabelFilter(this.classLabelIndex, this.classLabelFactory);
        }
    }
}

