/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. Puzicha, J.M. Buhmann, Y. Rubner, C. Tomasi", title="Empirical evaluation of dissimilarity measures for color and texture", booktitle="Proc. 7th IEEE International Conference on Computer Vision", url="http://dx.doi.org/10.1109/ICCV.1999.790412")
public class JeffreyDivergenceDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final JeffreyDivergenceDistanceFunction STATIC = new JeffreyDivergenceDistanceFunction();

    @Deprecated
    public JeffreyDivergenceDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = JeffreyDivergenceDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4 = numberVector.doubleValue(i);
            if (d4 == (d3 = numberVector2.doubleValue(i)) || !((d2 = 0.5 * (d4 + d3)) > 0.0) && !(d2 < 0.0)) continue;
            if (d4 > 0.0) {
                d += d4 * Math.log(d4 / d2);
            }
            if (!(d3 > 0.0)) continue;
            d += d3 * Math.log(d3 / d2);
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = JeffreyDivergenceDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = spatialComparable.getMin(i);
            double d3 = spatialComparable.getMax(i);
            double d4 = spatialComparable2.getMin(i);
            double d5 = spatialComparable2.getMax(i);
            double d6 = 0.5 * (d3 + d5);
            if (!(d6 > 0.0) && !(d6 < 0.0)) continue;
            if (d2 > 0.0) {
                d += d2 * Math.log(d2 / d6);
            }
            if (!(d4 > 0.0)) continue;
            d += d4 * Math.log(d4 / d6);
        }
        return d;
    }

    public String toString() {
        return "JeffreyDivergenceDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected JeffreyDivergenceDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

