/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class RdKNNTreeFactory<O extends NumberVector>
extends AbstractRStarTreeFactory<O, RdKNNNode, RdKNNEntry, RdKNNTree<O>, RdkNNSettings<O>> {
    public static final OptionID K_ID = new OptionID("rdknn.k", "positive integer specifying the maximal number k of reverse k nearest neighbors to be supported.");
    public static final Class<?> DEFAULT_DISTANCE_FUNCTION = EuclideanDistanceFunction.class;
    public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("rdknn.distancefunction", "Distance function to determine the distance between database objects.");

    public RdKNNTreeFactory(PageFileFactory<?> pageFileFactory, RdkNNSettings<O> rdkNNSettings) {
        super(pageFileFactory, rdkNNSettings);
    }

    @Override
    public RdKNNTree<O> instantiate(Relation<O> relation) {
        PageFile<RdKNNNode> pageFile = this.makePageFile(this.getNodeClass());
        RdKNNTree<O> rdKNNTree = new RdKNNTree<O>(relation, pageFile, (RdkNNSettings)this.settings);
        return rdKNNTree;
    }

    protected Class<RdKNNNode> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(RdKNNNode.class);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractRStarTreeFactory.Parameterizer<O, RdkNNSettings<O>> {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                ((RdkNNSettings)this.settings).k_max = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(DISTANCE_FUNCTION_ID, (Class<?>)SpatialPrimitiveDistanceFunction.class, DEFAULT_DISTANCE_FUNCTION))) {
                ((RdkNNSettings)this.settings).distanceFunction = (SpatialPrimitiveDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected RdKNNTreeFactory<O> makeInstance() {
            return new RdKNNTreeFactory(this.pageFileFactory, (RdkNNSettings)this.settings);
        }

        @Override
        protected RdkNNSettings<O> createSettings() {
            return new RdkNNSettings();
        }
    }
}

