/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterFlagGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;

@Title(value="Limit-based Eigenpair Filter")
@Description(value="Filters all eigenpairs, which are lower than a given value.")
public class LimitEigenPairFilter
implements EigenPairFilter {
    private static final Logging LOG = Logging.getLogger(LimitEigenPairFilter.class);
    public static final double DEFAULT_DELTA = 0.01;
    private double delta;
    private boolean absolute;

    public LimitEigenPairFilter(double d, boolean bl) {
        this.delta = d;
        this.absolute = bl;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        double d;
        EigenPair eigenPair;
        int n;
        double d2;
        StringBuilder stringBuilder = new StringBuilder();
        if (LOG.isDebugging()) {
            stringBuilder.append("delta = ").append(this.delta);
        }
        if (this.absolute) {
            d2 = this.delta;
        } else {
            double d3 = Double.NEGATIVE_INFINITY;
            for (n = 0; n < sortedEigenPairs.size(); ++n) {
                eigenPair = sortedEigenPairs.getEigenPair(n);
                d = Math.abs(eigenPair.getEigenvalue());
                if (!(d3 < d)) continue;
                d3 = d;
            }
            d2 = d3 * this.delta;
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nlimit = ").append(d2);
        }
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        for (n = 0; n < sortedEigenPairs.size(); ++n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            d = Math.abs(eigenPair.getEigenvalue());
            if (d >= d2) {
                arrayList.add(eigenPair);
                continue;
            }
            arrayList2.add(eigenPair);
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nstrong EigenPairs = ").append(arrayList);
            stringBuilder.append("\nweak EigenPairs = ").append(arrayList2);
            LOG.debugFine(stringBuilder.toString());
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_ABSOLUTE = new OptionID("pca.filter.absolute", "Flag to mark delta as an absolute value.");
        public static final OptionID EIGENPAIR_FILTER_DELTA = new OptionID("pca.filter.delta", "The threshold for strong Eigenvalues. If not otherwise specified, delta is a relative value w.r.t. the (absolute) highest Eigenvalues and has to be a double between 0 and 1. To mark delta as an absolute value, use the option -" + EIGENPAIR_FILTER_ABSOLUTE.getName() + ".");
        private double delta;
        private boolean absolute;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(EIGENPAIR_FILTER_ABSOLUTE);
            if (parameterization.grab(flag)) {
                this.absolute = flag.isTrue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(EIGENPAIR_FILTER_DELTA, 0.01);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.delta = doubleParameter.doubleValue();
                if (this.absolute && doubleParameter.tookDefaultValue()) {
                    parameterization.reportError(new WrongParameterValueException("Illegal parameter setting: Flag " + flag.getName() + " is set, " + "but no value for " + doubleParameter.getName() + " is specified."));
                }
            }
            ArrayList<ParameterConstraint<? super Double>> arrayList = new ArrayList<ParameterConstraint<? super Double>>();
            arrayList.add(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            arrayList.add(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            ParameterFlagGlobalConstraint<Double> parameterFlagGlobalConstraint = new ParameterFlagGlobalConstraint<Double>(doubleParameter, arrayList, flag, false);
            parameterization.checkConstraint(parameterFlagGlobalConstraint);
        }

        @Override
        protected LimitEigenPairFilter makeInstance() {
            return new LimitEigenPairFilter(this.delta, this.absolute);
        }
    }
}

