/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.LRUCache;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.PersistentPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LRUCachePageFileFactory<P extends Page>
implements PageFileFactory<P> {
    private PageFileFactory<P> pageFileFactory;
    private int cacheSize;

    public LRUCachePageFileFactory(PageFileFactory<P> pageFileFactory, int n) {
        this.cacheSize = n;
        this.pageFileFactory = pageFileFactory;
    }

    @Override
    public PageFile<P> newPageFile(Class<P> clazz) {
        PageFile<P> pageFile = this.pageFileFactory.newPageFile(clazz);
        return new LRUCache<P>(this.cacheSize, pageFile);
    }

    @Override
    public int getPageSize() {
        return this.pageFileFactory.getPageSize();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID CACHE_SIZE_ID = new OptionID("pagefile.cachesize", "The size of the cache in bytes.");
        public static final OptionID PAGEFILE_ID = new OptionID("pagefile.pagefile", "The backing pagefile for the cache.");
        PageFileFactory<Page> pageFileFactory;
        protected int cacheSize;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(PAGEFILE_ID, (Class<?>)PageFileFactory.class, PersistentPageFileFactory.class);
            if (parameterization.grab(objectParameter)) {
                this.pageFileFactory = (PageFileFactory)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(CACHE_SIZE_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.cacheSize = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected LRUCachePageFileFactory<Page> makeInstance() {
            return new LRUCachePageFileFactory<Page>(this.pageFileFactory, this.cacheSize);
        }
    }
}

