/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.Histogram;

public abstract class AbstractStaticHistogram
implements Histogram {
    protected int offset = 0;
    protected int size;
    protected double base;
    protected double max;
    protected double binsize;

    public AbstractStaticHistogram(int n, double d, double d2) {
        this.base = d;
        this.max = d2;
        this.binsize = (d2 - d) / (double)n;
        this.size = n;
    }

    protected int getBinNr(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new UnsupportedOperationException("Encountered non-finite value in Histogram: " + d);
        }
        if (d == this.max) {
            return this.size - 1;
        }
        return (int)Math.floor((d - this.base) / this.binsize) + this.offset;
    }

    protected static int growSize(int n, int n2) {
        int n3;
        int n4 = n3 = n < 64 ? n + 1 << 1 : (n >> 1) * 3;
        if (n3 < 0) {
            throw new OutOfMemoryError();
        }
        if (n2 > n3) {
            n3 = n2;
        }
        return n2;
    }

    @Override
    public int getNumBins() {
        return this.size;
    }

    @Override
    public double getBinsize() {
        return this.binsize;
    }

    @Override
    public double getCoverMinimum() {
        return this.base - (double)this.offset * this.binsize;
    }

    @Override
    public double getCoverMaximum() {
        return this.base + (double)(this.size - this.offset) * this.binsize;
    }

    @Override
    public abstract Iter iter();

    public abstract class Iter
    implements Histogram.Iter {
        int bin = 0;

        @Override
        public double getCenter() {
            return AbstractStaticHistogram.this.base + ((double)this.bin + 0.5 - (double)AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public double getLeft() {
            return AbstractStaticHistogram.this.base + (double)(this.bin - AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public double getRight() {
            return AbstractStaticHistogram.this.base + (double)(this.bin + 1 - AbstractStaticHistogram.this.offset) * AbstractStaticHistogram.this.binsize;
        }

        @Override
        public boolean valid() {
            return this.bin >= 0 && this.bin < AbstractStaticHistogram.this.size;
        }

        @Override
        public Iter advance() {
            ++this.bin;
            return this;
        }

        @Override
        public int getOffset() {
            return this.bin;
        }

        @Override
        public Iter advance(int n) {
            this.bin += n;
            return this;
        }

        @Override
        public Iter retract() {
            --this.bin;
            return this;
        }

        @Override
        public Iter seek(int n) {
            this.bin = n;
            return this;
        }
    }
}

