/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class SVGButton {
    public static final String DEFAULT_BUTTON_COLOR = "lightgray";
    public static final String DEFAULT_TEXT_COLOR = "black";
    private double x;
    private double y;
    private double w;
    private double h;
    private double r = Double.NaN;
    private CSSClass butcss;
    private String title = null;
    private CSSClass titlecss = null;

    public SVGButton(double d, double d2, double d3, double d4, double d5) {
        this.x = d;
        this.y = d2;
        this.w = d3;
        this.h = d4;
        this.r = d5;
        this.butcss = new CSSClass(this, "button");
        this.butcss.setStatement("fill", DEFAULT_BUTTON_COLOR);
        this.butcss.setStatement("stroke", DEFAULT_TEXT_COLOR);
        this.butcss.setStatement("stroke-width", ".01");
    }

    public Element render(SVGPlot sVGPlot) {
        Element element;
        Element element2 = sVGPlot.svgElement("g");
        Element element3 = sVGPlot.svgRect(this.x, this.y, this.w, this.h);
        if (!Double.isNaN(this.r)) {
            SVGUtil.setAtt(element3, "rx", this.r);
            SVGUtil.setAtt(element3, "ry", this.r);
        }
        SVGUtil.setAtt(element3, "style", this.butcss.inlineCSS());
        element2.appendChild(element3);
        if (sVGPlot.getIdElement("light-gradient") != null) {
            element = sVGPlot.svgRect(this.x, this.y, this.w, this.h);
            if (!Double.isNaN(this.r)) {
                SVGUtil.setAtt(element, "rx", this.r);
                SVGUtil.setAtt(element, "ry", this.r);
            }
            SVGUtil.setAtt(element, "style", "fill:url(#light-gradient);fill-opacity:.5");
            element2.appendChild(element);
        }
        if (sVGPlot.getIdElement("shadow-effect") != null) {
            element3.setAttribute("filter", "url(#shadow-effect)");
        }
        if (this.title != null) {
            element = sVGPlot.svgText(this.x + this.w * 0.5, this.y + this.h * 0.7, this.title);
            element.setAttribute("style", this.titlecss.inlineCSS());
            element2.appendChild(element);
        }
        return element2;
    }

    public void setTitle(String string, String string2) {
        this.title = string;
        if (this.titlecss == null) {
            this.titlecss = new CSSClass(this, "text");
            this.titlecss.setStatement("text-anchor", "middle");
            this.titlecss.setStatement("fill", string2);
            this.titlecss.setStatement("font-size", 0.6 * this.h);
        }
    }
}

