/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeMBRVisualization
extends AbstractVisFactory {
    public static final String INDEX = "index";
    public static final String NAME = "Index MBRs";
    protected Parameterizer settings;

    public TreeMBRVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, AbstractRStarTree.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<AbstractRStarTree<RStarTreeNode, SpatialEntry, ?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, AbstractRStarTree<RStarTreeNode, SpatialEntry, ?> abstractRStarTree, ScatterPlotProjector<?> scatterPlotProjector) {
                VisualizationTask visualizationTask = new VisualizationTask(TreeMBRVisualization.NAME, visualizerContext, abstractRStarTree, scatterPlotProjector.getRelation(), TreeMBRVisualization.this);
                visualizationTask.level = 1;
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(abstractRStarTree, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILL_ID = new OptionID("index.fill", "Partially transparent filling of index pages.");
        protected boolean fill = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(FILL_ID);
            if (parameterization.grab(flag)) {
                this.fill = flag.isTrue();
            }
        }

        @Override
        protected TreeMBRVisualization makeInstance() {
            return new TreeMBRVisualization(this);
        }
    }

    public class Instance<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected AbstractRStarTree<N, E, ?> tree;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.tree = (AbstractRStarTree)AbstractRStarTree.class.cast(visualizationTask.getResult());
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            int n = BitsUtil.cardinality(this.proj.getVisibleDimensions2D());
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            if (this.tree != null) {
                SpatialEntry spatialEntry = (SpatialEntry)this.tree.getRootEntry();
                for (int i = 0; i < this.tree.getHeight(); ++i) {
                    CSSClass cSSClass = new CSSClass(this, TreeMBRVisualization.INDEX + i);
                    double d = 1.0 - (double)i / (double)this.tree.getHeight();
                    if (TreeMBRVisualization.this.settings.fill) {
                        cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                        cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                        cSSClass.setStatement("fill", colorLibrary.getColor(i));
                        cSSClass.setStatement("fill-opacity", 0.1 / (double)(n - 1));
                    } else {
                        cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                        cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                        cSSClass.setStatement("fill", "none");
                    }
                    cSSClass.setStatement("stroke-linecap", "round");
                    cSSClass.setStatement("stroke-linejoin", "round");
                    this.svgp.addCSSClassOrLogError(cSSClass);
                }
                this.visualizeRTreeEntry(this.svgp, this.layer, this.proj, this.tree, spatialEntry, 0);
            }
        }

        private void visualizeRTreeEntry(SVGPlot sVGPlot, Element element, Projection2D projection2D, AbstractRStarTree<? extends N, E, ?> abstractRStarTree, E e, int n) {
            Object object;
            E e2 = e;
            if (TreeMBRVisualization.this.settings.fill) {
                object = SVGHyperCube.drawFilled(sVGPlot, TreeMBRVisualization.INDEX + n, projection2D, e2);
                element.appendChild((Node)object);
            } else {
                object = SVGHyperCube.drawFrame(sVGPlot, projection2D, e2);
                SVGUtil.setCSSClass((Element)object, TreeMBRVisualization.INDEX + n);
                element.appendChild((Node)object);
            }
            if (!e.isLeafEntry()) {
                object = (AbstractRStarTreeNode)abstractRStarTree.getNode(e);
                for (int i = 0; i < ((AbstractNode)object).getNumEntries(); ++i) {
                    SpatialEntry spatialEntry = (SpatialEntry)((AbstractNode)object).getEntry(i);
                    if (spatialEntry.isLeafEntry()) continue;
                    this.visualizeRTreeEntry(sVGPlot, element, projection2D, abstractRStarTree, spatialEntry, n + 1);
                }
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.context.removeDataStoreListener(this);
        }
    }
}

