/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultWriter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.ArrayList;
import java.util.List;

public class OutputStep
implements WorkflowStep {
    private List<ResultHandler> resulthandlers = null;
    protected static ArrayList<Class<? extends ResultHandler>> defaultHandlers = null;

    public OutputStep(List<ResultHandler> list) {
        this.resulthandlers = list;
    }

    public void runResultHandlers(ResultHierarchy resultHierarchy, Database database) {
        for (ResultHandler resultHandler : this.resulthandlers) {
            Thread.currentThread().setName(resultHandler.toString());
            resultHandler.processNewResult(resultHierarchy, database);
        }
    }

    public static void setDefaultHandlerWriter() {
        defaultHandlers = new ArrayList(1);
        defaultHandlers.add(ResultWriter.class);
    }

    public static void setDefaultHandlerVisualizer() {
        Class<Object> clazz;
        defaultHandlers = new ArrayList(1);
        try {
            clazz = ClassLoader.getSystemClassLoader().loadClass("de.lmu.ifi.dbs.elki.result.AutomaticVisualization");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = ResultWriter.class;
        }
        defaultHandlers.add(clazz);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private List<ResultHandler> resulthandlers = null;
        public static final OptionID RESULT_HANDLER_ID = new OptionID("resulthandler", "Result handler class.");
        public static final OptionID OUTPUT_ID = new OptionID("out", "Directory name (or name of an existing file) to write the obtained results in. If this parameter is omitted, per default the output will sequentially be given to STDOUT.");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(RESULT_HANDLER_ID, ResultHandler.class);
            if (defaultHandlers != null) {
                objectListParameter.setDefaultValue(defaultHandlers);
            }
            if (parameterization.grab(objectListParameter)) {
                this.resulthandlers = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected OutputStep makeInstance() {
            return new OutputStep(this.resulthandlers);
        }
    }
}

