/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParseProblemManager;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.EpsilonTreeAdaptor;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.annotations.EolAnnotationsUtil;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public abstract class AbstractModule
extends AbstractModuleElement
implements IModule {
    protected EpsilonParser parser;
    protected ArrayList<ParseProblem> parseProblems = new ArrayList();

    @Override
    public abstract void buildModel() throws Exception;

    public abstract String getMainRule();

    public abstract Lexer createLexer(InputStream var1);

    public abstract EpsilonParser createParser(TokenStream var1);

    @Override
    public abstract void reset();

    @Override
    public AST getAst() {
        return this.ast;
    }

    public abstract List<ModuleElement> getChildren();

    @Override
    public List<ParseProblem> getParseProblems() {
        return this.parseProblems;
    }

    @Override
    public boolean parse(String code) throws Exception {
        return this.parse(code, null);
    }

    @Override
    public boolean parse(String code, File file) throws Exception {
        this.sourceFile = file;
        if (file != null) {
            this.sourceUri = file.toURI();
        }
        return this.parse(this.sourceUri, new ByteArrayInputStream(code.getBytes()));
    }

    @Override
    public boolean parse(File file) throws Exception {
        return this.parse(file.toURI());
    }

    @Override
    public boolean parse(URI uri) throws Exception {
        this.sourceUri = uri;
        String uriScheme = uri.getScheme();
        if ("file".equals(uriScheme)) {
            this.sourceFile = new File(uri);
        }
        return this.parse(uri, uri.toURL().openStream());
    }

    protected boolean invokeMainRule() throws Exception {
        EpsilonParseProblemManager.INSTANCE.reset();
        try {
            AST cst = (AST)((ParserRuleReturnScope)ReflectionUtil.executeMethod(this.parser, this.getMainRule(), new Object[0])).getTree();
            this.ast = this.createAst(cst, null);
        }
        catch (RecognitionException ex) {
            ParseProblem problem = new ParseProblem();
            problem.setLine(ex.line);
            problem.setColumn(ex.charPositionInLine);
            problem.setReason(ex.getMessage());
            this.getParseProblems().add(problem);
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            ParseProblem problem = new ParseProblem();
            Token next = this.parser.input.LT(1);
            problem.setLine(next.getLine());
            problem.setColumn(next.getCharPositionInLine());
            problem.setReason("mismatched input: '" + next.getText() + "'");
            this.getParseProblems().add(problem);
        }
        this.parseProblems.addAll(EpsilonParseProblemManager.INSTANCE.getParseProblems());
        EpsilonParseProblemManager.INSTANCE.reset();
        if (this.getParseProblems().size() == 0) {
            EolAnnotationsUtil.assignAnnotations(this.ast);
            this.buildModel();
            return true;
        }
        return false;
    }

    protected AST createAst(AST cst, AST parentAst) {
        AST ast = this.adapt(cst, parentAst);
        ast.setToken(cst.getToken());
        ast.setUri(cst.getUri());
        ast.setModule(cst.getModule());
        ast.setExtraTokens(cst.getExtraTokens());
        ast.setImaginary(cst.isImaginary());
        for (AST childCst : cst.getChildren()) {
            if (!(childCst instanceof AST)) continue;
            AST childAst = this.createAst(childCst, ast);
            childAst.setParent(ast);
            ast.addChild(childAst);
        }
        return ast;
    }

    public AST adapt(AST cst, AST parentAst) {
        return new AST();
    }

    private boolean parse(URI uri, InputStream iStream) throws Exception {
        this.parseProblems.clear();
        Scanner s = new Scanner(iStream);
        try {
            s.useDelimiter("\\A");
            String contents = s.hasNext() ? s.next() : "";
            ByteArrayInputStream noTabsStream = new ByteArrayInputStream(contents.replaceAll("\t", " ").getBytes());
            Lexer lexer = this.createLexer(noTabsStream);
            CommonTokenStream stream = new CommonTokenStream(lexer);
            EpsilonTreeAdaptor adaptor = new EpsilonTreeAdaptor(uri, (IModule)this);
            this.parser = this.createParser(stream);
            this.parser.setDeepTreeAdaptor(adaptor);
            boolean bl = this.invokeMainRule();
            return bl;
        }
        catch (Exception ex) {
            this.parseProblems.add(new ParseProblem("Exception during parsing: " + ex.getLocalizedMessage(), 0));
            throw ex;
        }
        finally {
            s.close();
        }
    }
}

