/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.front.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.util.EuclideanDistance;
import org.uma.jmetal.util.point.util.PointDistance;

public class FrontUtils {
    public static double[] getMaximumValues(Front front) {
        int i;
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        int numberOfObjectives = front.getPoint(0).getNumberOfDimensions();
        double[] maximumValue = new double[numberOfObjectives];
        for (i = 0; i < numberOfObjectives; ++i) {
            maximumValue[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (!(front.getPoint(i).getDimensionValue(j) > maximumValue[j])) continue;
                maximumValue[j] = front.getPoint(i).getDimensionValue(j);
            }
        }
        return maximumValue;
    }

    public static double[] getMinimumValues(Front front) {
        int i;
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        int numberOfObjectives = front.getPoint(0).getNumberOfDimensions();
        double[] minimumValue = new double[numberOfObjectives];
        for (i = 0; i < numberOfObjectives; ++i) {
            minimumValue[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (!(front.getPoint(i).getDimensionValue(j) < minimumValue[j])) continue;
                minimumValue[j] = front.getPoint(i).getDimensionValue(j);
            }
        }
        return minimumValue;
    }

    public static double distanceToNearestPoint(Point point, Front front) {
        return FrontUtils.distanceToNearestPoint(point, front, new EuclideanDistance());
    }

    public static double distanceToNearestPoint(Point point, Front front, PointDistance distance) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            double aux = distance.compute(point, front.getPoint(i));
            if (!(aux < minDistance) || !(aux > 0.0)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static double distanceToClosestPoint(Point point, Front front) {
        return FrontUtils.distanceToClosestPoint(point, front, new EuclideanDistance());
    }

    public static double distanceToClosestPoint(Point point, Front front, PointDistance distance) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        double minDistance = distance.compute(point, front.getPoint(0));
        for (int i = 1; i < front.getNumberOfPoints(); ++i) {
            double aux = distance.compute(point, front.getPoint(i));
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static Front getInvertedFront(Front front) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        if (front.getNumberOfPoints() == 0) {
            throw new JMetalException("The front is empty");
        }
        int numberOfDimensions = front.getPoint(0).getNumberOfDimensions();
        ArrayFront invertedFront = new ArrayFront(front.getNumberOfPoints(), numberOfDimensions);
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfDimensions; ++j) {
                if (front.getPoint(i).getDimensionValue(j) <= 1.0 && front.getPoint(i).getDimensionValue(j) >= 0.0) {
                    invertedFront.getPoint(i).setDimensionValue(j, 1.0 - front.getPoint(i).getDimensionValue(j));
                    continue;
                }
                if (front.getPoint(i).getDimensionValue(j) > 1.0) {
                    invertedFront.getPoint(i).setDimensionValue(j, 0.0);
                    continue;
                }
                if (!(front.getPoint(i).getDimensionValue(j) < 0.0)) continue;
                invertedFront.getPoint(i).setDimensionValue(j, 1.0);
            }
        }
        return invertedFront;
    }

    public static double[][] convertFrontToArray(Front front) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        double[][] arrayFront = new double[front.getNumberOfPoints()][];
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            arrayFront[i] = new double[front.getPoint(i).getNumberOfDimensions()];
            for (int j = 0; j < front.getPoint(i).getNumberOfDimensions(); ++j) {
                arrayFront[i][j] = front.getPoint(i).getDimensionValue(j);
            }
        }
        return arrayFront;
    }

    public static List<DoubleSolution> convertFrontToSolutionList(Front front) {
        if (front == null) {
            throw new JMetalException("The front is null");
        }
        int solutionSetSize = front.getNumberOfPoints();
        int numberOfObjectives = front.getNumberOfPoints() == 0 ? 0 : front.getPoint(0).getNumberOfDimensions();
        ArrayList<DoubleSolution> solutionSet = new ArrayList<DoubleSolution>(solutionSetSize);
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            DefaultDoubleSolution solution = new DefaultDoubleSolution(new DummyClass(numberOfObjectives));
            for (int j = 0; j < numberOfObjectives; ++j) {
                solution.setObjective(j, front.getPoint(i).getDimensionValue(j));
            }
            solutionSet.add(solution);
        }
        return solutionSet;
    }

    private static class DummyClass
    extends AbstractDoubleProblem {
        public DummyClass(int numberOfObjectives) {
            this.setNumberOfObjectives(numberOfObjectives);
        }

        @Override
        public void evaluate(DoubleSolution solution) {
        }
    }
}

