/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KMeansBatchedLloyd<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansBatchedLloyd.class);
    private static final String KEY = KMeansBatchedLloyd.class.getName();
    int blocks;
    RandomFactory random;

    public KMeansBatchedLloyd(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization, int n3, RandomFactory randomFactory) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
        this.blocks = n3;
        this.random = randomFactory;
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        int n;
        int n2 = RelationUtil.dimensionality(relation);
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initializer", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<ModifiableDBIDs> arrayList = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        ArrayDBIDs[] arrayDBIDsArray = DBIDUtil.randomSplit(relation.getDBIDs(), this.blocks, this.random);
        double[][] dArray = new double[this.k][n2];
        int[] nArray = new int[this.k];
        double[] dArray2 = new double[this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        DoubleStatistic doubleStatistic = LOG.isStatistics() ? new DoubleStatistic(this.getClass().getName() + ".variance-sum") : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            boolean bl = false;
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Batch", arrayDBIDsArray.length, LOG) : null;
            for (int i = 0; i < arrayDBIDsArray.length; ++i) {
                for (int j = 0; j < this.k; ++j) {
                    Arrays.fill(dArray[j], 0.0);
                }
                Arrays.fill(nArray, 0);
                Arrays.fill(dArray2, 0.0);
                bl |= this.assignToNearestCluster(relation, arrayDBIDsArray[i], list, dArray, nArray, arrayList, writableIntegerDataStore, dArray2);
                this.updateMeans(list, dArray, arrayList, nArray);
                LOG.incrementProcessed(finiteProgress);
            }
            LOG.ensureCompleted(finiteProgress);
            this.logVarstat(doubleStatistic, dArray2);
            if (!bl) break;
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            DBIDs dBIDs = (DBIDs)arrayList.get(i);
            if (dBIDs.size() == 0) continue;
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray2[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>(dBIDs, kMeansModel));
        }
        return clustering;
    }

    protected boolean assignToNearestCluster(Relation<V> relation, DBIDs dBIDs, List<? extends NumberVector> list, double[][] dArray, int[] nArray, List<? extends ModifiableDBIDs> list2, WritableIntegerDataStore writableIntegerDataStore, double[] dArray2) {
        boolean bl = false;
        DistanceFunction distanceFunction = this.getDistanceFunction();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            int n = 0;
            for (int i = 0; i < this.k; ++i) {
                double d2 = distanceFunction.distance(numberVector, list.get(i));
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            int n2 = n;
            dArray2[n2] = dArray2[n2] + d;
            bl |= this.updateAssignment(dBIDIter, numberVector, list2, writableIntegerDataStore, dArray, nArray, n);
            dBIDIter.advance();
        }
        return bl;
    }

    protected boolean updateAssignment(DBIDIter dBIDIter, V v, List<? extends ModifiableDBIDs> list, WritableIntegerDataStore writableIntegerDataStore, double[][] dArray, int[] nArray, int n) {
        int n2;
        int n3 = writableIntegerDataStore.intValue(dBIDIter);
        if (n3 == n) {
            return false;
        }
        list.get(n).add(dBIDIter);
        int n4 = n;
        nArray[n4] = nArray[n4] + 1;
        double[] dArray2 = dArray[n];
        for (n2 = 0; n2 < v.getDimensionality(); ++n2) {
            int n5 = n2;
            dArray2[n5] = dArray2[n5] + v.doubleValue(n2);
        }
        if (n3 >= 0) {
            list.get(n3).remove(dBIDIter);
            int n6 = n3;
            nArray[n6] = nArray[n6] - 1;
            dArray2 = dArray[n3];
            for (n2 = 0; n2 < v.getDimensionality(); ++n2) {
                int n7 = n2;
                dArray2[n7] = dArray2[n7] - v.doubleValue(n2);
            }
        }
        writableIntegerDataStore.putInt(dBIDIter, n);
        return true;
    }

    protected void updateMeans(List<Vector> list, double[][] dArray, List<ModifiableDBIDs> list2, int[] nArray) {
        for (int i = 0; i < this.k; ++i) {
            int n = list2.get(i).size();
            int n2 = n - nArray[i];
            if (n == 0) continue;
            if (n2 == 0) {
                list.set(i, new Vector(dArray[i]).times(1.0 / (double)n));
                continue;
            }
            if (n2 == n) {
                list.get(i).plusTimesEquals(new Vector(dArray[i]), 1.0 / (double)n);
                continue;
            }
            list.get(i).timesEquals((double)n2 / (double)n).plusTimesEquals(new Vector(dArray[i]), 1.0 / (double)n);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        public static final OptionID BLOCKS_ID = new OptionID("kmeans.blocks", "Number of blocks to use for processing. Means will be recomputed after each block.");
        public static final OptionID RANDOM_ID = new OptionID("kmeans.blocks.random", "Random source for producing blocks.");
        int blocks;
        RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(BLOCKS_ID, 10);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.blocks = intParameter.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected KMeansBatchedLloyd<V> makeInstance() {
            return new KMeansBatchedLloyd(this.distanceFunction, this.k, this.maxiter, this.initializer, this.blocks, this.random);
        }
    }
}

