/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Reference(authors="G. Hamerly", title="Making k-means even faster", booktitle="Proc. 2010 SIAM International Conference on Data Mining", url="http://dx.doi.org/10.1137/1.9781611972801.12")
public class KMeansHamerly<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansHamerly.class);
    private static final String KEY = KMeansHamerly.class.getName();
    private boolean varstat = false;

    public KMeansHamerly(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization, boolean bl) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
        this.varstat = bl;
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        int n;
        int n2;
        if (relation.size() <= 0) {
            return new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<ModifiableDBIDs> arrayList = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, Double.POSITIVE_INFINITY);
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, 0.0);
        int n3 = list.get(0).getDimensionality();
        ArrayList<Vector> arrayList2 = new ArrayList<Vector>(this.k);
        for (int i = 0; i < this.k; ++i) {
            arrayList2.add(new Vector(n3));
        }
        double[] dArray = new double[this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        LongStatistic longStatistic = LOG.isStatistics() ? new LongStatistic(KEY + ".reassignments") : null;
        for (n2 = 0; this.maxiter <= 0 || n2 < this.maxiter; ++n2) {
            int n4;
            LOG.incrementProcessed(indefiniteProgress);
            if (n2 == 0) {
                n4 = this.initialAssignToNearestCluster(relation, list, arrayList2, arrayList, writableIntegerDataStore, writableDoubleDataStore, writableDoubleDataStore2);
            } else {
                this.recomputeSeperation(list, dArray);
                n4 = this.assignToNearestCluster(relation, list, arrayList2, arrayList, writableIntegerDataStore, dArray, writableDoubleDataStore, writableDoubleDataStore2);
            }
            if (longStatistic != null) {
                longStatistic.setLong(n4);
                LOG.statistics(longStatistic);
            }
            if (n4 == 0) break;
            for (int i = 0; i < this.k; ++i) {
                int n5 = ((ModifiableDBIDs)arrayList.get(i)).size();
                ((Vector)arrayList2.get(i)).timesEquals(n5 > 0 ? 1.0 / (double)n5 : 1.0);
            }
            double d = this.maxMoved(list, arrayList2, dArray);
            this.updateBounds(relation, writableIntegerDataStore, writableDoubleDataStore, writableDoubleDataStore2, dArray, d);
            for (n = 0; n < this.k; ++n) {
                int n6 = ((ModifiableDBIDs)arrayList.get(n)).size();
                list.get(n).set((Vector)arrayList2.get(n));
                ((Vector)arrayList2.get(n)).timesEquals(n6 > 0 ? (double)n6 : 1.0);
            }
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n2));
        }
        writableDoubleDataStore.destroy();
        writableDoubleDataStore2.destroy();
        double d = 0.0;
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (n = 0; n < arrayList.size(); ++n) {
            DBIDs dBIDs = (DBIDs)arrayList.get(n);
            if (dBIDs.size() == 0) continue;
            double d2 = 0.0;
            Vector vector = list.get(n);
            Object object = dBIDs.iter();
            while (object.valid()) {
                d2 += this.distanceFunction.distance(vector, (NumberVector)relation.get((DBIDRef)object));
                object.advance();
            }
            d += d2;
            object = new KMeansModel(vector, d2);
            clustering.addToplevelCluster(new Cluster<Object>(dBIDs, object));
        }
        if (LOG.isStatistics() && this.varstat) {
            LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".variance-sum", d));
        }
        return clustering;
    }

    private void recomputeSeperation(List<Vector> list, double[] dArray) {
        int n;
        int n2 = list.size();
        assert (dArray.length == n2);
        boolean bl = this.distanceFunction instanceof SquaredEuclideanDistanceFunction;
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        for (n = 1; n < n2; ++n) {
            Vector vector = list.get(n);
            for (int i = 0; i < n; ++i) {
                double d = this.distanceFunction.distance(vector, list.get(i));
                dArray[n] = d < dArray[n] ? d : dArray[n];
                dArray[i] = d < dArray[i] ? d : dArray[i];
            }
        }
        n = 0;
        while (n < n2) {
            dArray[n] = bl ? Math.sqrt(dArray[n]) : dArray[n];
            int n3 = n++;
            dArray[n3] = dArray[n3] * 0.5;
        }
    }

    private int initialAssignToNearestCluster(Relation<V> relation, List<Vector> list, List<Vector> list2, List<ModifiableDBIDs> list3, WritableIntegerDataStore writableIntegerDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        assert (this.k == list.size());
        DistanceFunction distanceFunction = this.getDistanceFunction();
        boolean bl = distanceFunction instanceof SquaredEuclideanDistanceFunction;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            int n = -1;
            for (int i = 0; i < this.k; ++i) {
                double d3 = distanceFunction.distance(numberVector, list.get(i));
                if (d3 < d) {
                    n = i;
                    d2 = d;
                    d = d3;
                    continue;
                }
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
            if (bl) {
                d = Math.sqrt(d);
                d2 = Math.sqrt(d2);
            }
            ModifiableDBIDs modifiableDBIDs = list3.get(n);
            modifiableDBIDs.add(dBIDIter);
            writableIntegerDataStore.putInt(dBIDIter, n);
            double[] dArray = list2.get(n).getArrayRef();
            for (int i = 0; i < numberVector.getDimensionality(); ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + numberVector.doubleValue(i);
            }
            writableDoubleDataStore.putDouble(dBIDIter, d);
            writableDoubleDataStore2.putDouble(dBIDIter, d2);
            dBIDIter.advance();
        }
        return relation.size();
    }

    private int assignToNearestCluster(Relation<V> relation, List<Vector> list, List<Vector> list2, List<ModifiableDBIDs> list3, WritableIntegerDataStore writableIntegerDataStore, double[] dArray, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
        assert (this.k == list.size());
        int n = 0;
        DistanceFunction distanceFunction = this.getDistanceFunction();
        boolean bl = distanceFunction instanceof SquaredEuclideanDistanceFunction;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n2 = writableIntegerDataStore.intValue(dBIDIter);
            double d = writableDoubleDataStore2.doubleValue(dBIDIter);
            double d2 = dArray[n2];
            double d3 = writableDoubleDataStore.doubleValue(dBIDIter);
            if (!(d3 <= d) && !(d3 <= d2)) {
                NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
                d3 = distanceFunction.distance(numberVector, list.get(n2));
                d3 = bl ? Math.sqrt(d3) : d3;
                writableDoubleDataStore.putDouble(dBIDIter, d3);
                if (!(d3 <= d) && !(d3 <= d2)) {
                    double d4 = Double.POSITIVE_INFINITY;
                    double d5 = Double.POSITIVE_INFINITY;
                    int n3 = -1;
                    for (int i = 0; i < this.k; ++i) {
                        double d6 = distanceFunction.distance(numberVector, list.get(i));
                        if (d6 < d4) {
                            n3 = i;
                            d5 = d4;
                            d4 = d6;
                            continue;
                        }
                        if (!(d6 < d5)) continue;
                        d5 = d6;
                    }
                    if (bl) {
                        d4 = Math.sqrt(d4);
                        d5 = Math.sqrt(d5);
                    }
                    if (n3 != n2) {
                        writableIntegerDataStore.putInt(dBIDIter, n3);
                        list3.get(n3).add(dBIDIter);
                        list3.get(n2).remove(dBIDIter);
                        double[] dArray2 = list2.get(n3).getArrayRef();
                        double[] dArray3 = list2.get(n2).getArrayRef();
                        int n4 = 0;
                        while (n4 < numberVector.getDimensionality()) {
                            double d7 = numberVector.doubleValue(n4);
                            int n5 = n4;
                            dArray2[n5] = dArray2[n5] + d7;
                            int n6 = n4++;
                            dArray3[n6] = dArray3[n6] - d7;
                        }
                        ++n;
                        writableDoubleDataStore.putDouble(dBIDIter, d4);
                    }
                    writableDoubleDataStore2.putDouble(dBIDIter, d5);
                }
            }
            dBIDIter.advance();
        }
        return n;
    }

    private double maxMoved(List<Vector> list, List<Vector> list2, double[] dArray) {
        assert (list.size() == this.k);
        assert (list2.size() == this.k);
        assert (dArray.length == this.k);
        boolean bl = this.distanceFunction instanceof SquaredEuclideanDistanceFunction;
        double d = 0.0;
        for (int i = 0; i < this.k; ++i) {
            double d2 = this.distanceFunction.distance(list.get(i), list2.get(i));
            dArray[i] = d2 = bl ? Math.sqrt(d2) : d2;
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    private void updateBounds(Relation<V> relation, WritableIntegerDataStore writableIntegerDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2, double[] dArray, double d) {
        d = -d;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            writableDoubleDataStore.increment(dBIDIter, dArray[writableIntegerDataStore.intValue(dBIDIter)]);
            writableDoubleDataStore2.increment(dBIDIter, d);
            dBIDIter.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        public static final OptionID VARSTAT_ID = new OptionID("kmeans.varstat", "Compute the final clustering variance statistic. Needs an additional full pass over the data set.");
        protected boolean varstat = false;

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected void getParameterDistanceFunction(Parameterization parameterization) {
            super.getParameterDistanceFunction(parameterization);
            if (this.distanceFunction instanceof SquaredEuclideanDistanceFunction) {
                return;
            }
            if (this.distanceFunction != null && !this.distanceFunction.isMetric()) {
                LOG.warning("Hamerly k-means requires a metric distance, and k-means should only be used with squared Euclidean distance!");
            }
        }

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(VARSTAT_ID);
            if (parameterization.grab(flag)) {
                this.varstat = flag.isTrue();
            }
        }

        @Override
        protected KMeansHamerly<V> makeInstance() {
            return new KMeansHamerly(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }
}

