/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Z-Test Outlier Detection")
@Description(value="Outliers are detected by their z-deviation from the local mean.")
@Reference(authors="S. Shekhar and C.-T. Lu and P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="http://dx.doi.org/10.1023/A:1023455925009")
public class CTLuZTestOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuZTestOutlier.class);

    public CTLuZTestOutlier(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<? extends NumberVector> relation2) {
        Object object;
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        MeanVariance meanVariance = new MeanVariance();
        Object object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            object = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2);
            Mean mean = new Mean();
            DBIDIter dBIDIter = object.iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, dBIDIter)) {
                    mean.put(relation2.get(dBIDIter).doubleValue(0));
                }
                dBIDIter.advance();
            }
            double d = mean.getCount() > 0.0 ? relation2.get((DBIDRef)object2).doubleValue(0) - mean.getMean() : 0.0;
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            meanVariance.put(d);
            object2.advance();
        }
        object2 = new DoubleMinMax();
        object = relation2.iterDBIDs();
        while (object.valid()) {
            double d = Math.abs(writableDoubleDataStore.doubleValue((DBIDRef)object) - meanVariance.getMean()) / meanVariance.getSampleStddev();
            ((DoubleMinMax)object2).put(d);
            writableDoubleDataStore.putDouble((DBIDRef)object, d);
            object.advance();
        }
        object = new MaterializedDoubleRelation("ZTest", "Z Test score", writableDoubleDataStore, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object2).getMin(), ((DoubleMinMax)object2).getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuZTestOutlier<N> makeInstance() {
            return new CTLuZTestOutlier(this.npredf);
        }
    }
}

