/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.AbstractIntegerDBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrivialDBIDFactory
extends AbstractIntegerDBIDFactory {
    AtomicInteger next = new AtomicInteger(1);

    @Override
    public final DBID generateSingleDBID() {
        int n = this.next.getAndIncrement();
        if (n == Integer.MAX_VALUE) {
            throw new AbortException("DBID allocation error - too many objects allocated!");
        }
        IntegerDBID integerDBID = new IntegerDBID(n);
        return integerDBID;
    }

    @Override
    public final void deallocateSingleDBID(DBIDRef dBIDRef) {
    }

    @Override
    public final DBIDRange generateStaticDBIDRange(int n) {
        int n2 = this.next.getAndAdd(n);
        if (n2 > this.next.get()) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange integerDBIDRange = new IntegerDBIDRange(n2, n);
        return integerDBIDRange;
    }

    @Override
    public DBIDRange generateStaticDBIDRange(int n, int n2) {
        int n3;
        int n4 = n + n2;
        if (n4 > Integer.MAX_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange integerDBIDRange = new IntegerDBIDRange(n, n2);
        while ((n3 = this.next.get()) < n4 && !this.next.compareAndSet(n3, n4)) {
        }
        return integerDBIDRange;
    }

    @Override
    public void deallocateDBIDRange(DBIDRange dBIDRange) {
    }
}

