/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter;

import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class FixedDBIDsFilter
implements ObjectFilter {
    BundleMeta meta;
    int curid = 0;

    public FixedDBIDsFilter(int n) {
        this.curid = n;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        DBIDRange dBIDRange = DBIDFactory.FACTORY.generateStaticDBIDRange(this.curid, multipleObjectsBundle.dataLength());
        multipleObjectsBundle.setDBIDs(dBIDRange);
        this.curid += multipleObjectsBundle.dataLength();
        return multipleObjectsBundle;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID IDSTART_ID = new OptionID("dbc.startid", "Object ID to start counting with");
        int startid = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(IDSTART_ID, 0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.startid = intParameter.intValue();
            }
        }

        @Override
        protected FixedDBIDsFilter makeInstance() {
            return new FixedDBIDsFilter(this.startid);
        }
    }
}

