/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractDBIDRangeDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.AsciiDistanceParser;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.map.TLongDoubleMap;
import gnu.trove.map.hash.TLongDoubleHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@Title(value="File based double distance for database objects.")
@Description(value="Loads double distance values from an external text file.")
public class FileBasedDoubleDistanceFunction
extends AbstractDBIDRangeDistanceFunction {
    private static final Logging LOG = Logging.getLogger(FileBasedDoubleDistanceFunction.class);
    private TLongDoubleMap cache;
    private DistanceParser parser;
    private File matrixfile;
    private int min;
    private int max;

    public FileBasedDoubleDistanceFunction(DistanceParser distanceParser, File file) {
        this.parser = distanceParser;
        this.matrixfile = file;
    }

    @Override
    public <O extends DBID> DistanceQuery<O> instantiate(Relation<O> relation) {
        if (this.cache == null) {
            try {
                this.loadCache(this.parser, this.matrixfile);
            }
            catch (IOException iOException) {
                throw new AbortException("Could not load external distance file: " + this.matrixfile.toString(), iOException);
            }
        }
        return super.instantiate(relation);
    }

    @Override
    public double distance(int n, int n2) {
        return n == n2 ? 0.0 : this.cache.get(FileBasedDoubleDistanceFunction.makeKey(n + this.min, n2 + this.min));
    }

    private void loadCache(DistanceParser distanceParser, File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(file)));
        this.cache = new TLongDoubleHashMap(10, 0.5f, -1L, Double.POSITIVE_INFINITY);
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        distanceParser.parse(bufferedInputStream, new DistanceCacheWriter(){

            @Override
            public void put(int n, int n2, double d) {
                if (n < n2) {
                    FileBasedDoubleDistanceFunction.this.min = n < FileBasedDoubleDistanceFunction.this.min ? n : FileBasedDoubleDistanceFunction.this.min;
                    FileBasedDoubleDistanceFunction.this.max = n2 > FileBasedDoubleDistanceFunction.this.max ? n2 : FileBasedDoubleDistanceFunction.this.max;
                } else {
                    FileBasedDoubleDistanceFunction.this.min = n2 < FileBasedDoubleDistanceFunction.this.min ? n2 : FileBasedDoubleDistanceFunction.this.min;
                    FileBasedDoubleDistanceFunction.this.max = n > FileBasedDoubleDistanceFunction.this.max ? n : FileBasedDoubleDistanceFunction.this.max;
                }
                FileBasedDoubleDistanceFunction.this.cache.put(FileBasedDoubleDistanceFunction.makeKey(n, n2), d);
            }

            @Override
            public boolean containsKey(int n, int n2) {
                return FileBasedDoubleDistanceFunction.this.cache.containsKey(FileBasedDoubleDistanceFunction.makeKey(n, n2));
            }
        });
        if (this.min != 0) {
            LOG.verbose("Distance matrix is supposed to be 0-indexed. Choosing offset " + this.min + " to compensate.");
        }
    }

    protected static final long makeKey(int n, int n2) {
        return n < n2 ? (long)n << 32 | (long)n2 : (long)n2 << 32 | (long)n;
    }

    @Override
    public void checkRange(DBIDRange dBIDRange) {
        int n = this.max + 1 - this.min;
        if (n < dBIDRange.size()) {
            LOG.warning("Distance matrix has size " + n + " but range has size: " + dBIDRange.size());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileBasedDoubleDistanceFunction fileBasedDoubleDistanceFunction = (FileBasedDoubleDistanceFunction)object;
        return this.cache.equals(fileBasedDoubleDistanceFunction.cache);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MATRIX_ID = new OptionID("distance.matrix", "The name of the file containing the distance matrix.");
        public static final OptionID PARSER_ID = new OptionID("distance.parser", "Parser used to load the distance matrix.");
        protected File matrixfile = null;
        protected DistanceParser parser = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(MATRIX_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.matrixfile = (File)fileParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(PARSER_ID, (Class<?>)DistanceParser.class, AsciiDistanceParser.class))) {
                this.parser = (DistanceParser)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected FileBasedDoubleDistanceFunction makeInstance() {
            return new FileBasedDoubleDistanceFunction(this.parser, this.matrixfile);
        }
    }
}

