/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.AbstractLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.PolynomialApproximation;
import de.lmu.ifi.dbs.elki.index.tree.query.GenericMTreeDistanceSearchCandidate;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.PolynomialRegression;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import java.io.Externalizable;
import java.util.List;
import java.util.Map;

public abstract class MkAppTree<O>
extends AbstractMkTree<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
    private static final Logging LOG = Logging.getLogger(MkAppTree.class);

    public MkAppTree(Relation<O> relation, PageFile<MkAppTreeNode<O>> pageFile, MkAppTreeSettings<O> mkAppTreeSettings) {
        super(relation, pageFile, mkAppTreeSettings);
    }

    @Override
    public void insert(MkAppEntry mkAppEntry, boolean bl) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    protected void preInsert(MkAppEntry mkAppEntry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insertAll(List<MkAppEntry> list) {
        if (list.isEmpty()) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("insert " + list + "\n");
        }
        if (!this.initialized) {
            this.initialize((Entry)list.get(0));
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(list.size());
        for (MkAppEntry mkAppEntry : list) {
            arrayModifiableDBIDs.add(mkAppEntry.getRoutingObjectID());
            super.insert(mkAppEntry, false);
        }
        Map<DBID, KNNList> map = this.batchNN((AbstractMTreeNode)this.getRoot(), arrayModifiableDBIDs, ((MkAppTreeSettings)this.settings).k_max + 1);
        this.adjustApproximatedKNNDistances((MkAppEntry)this.getRootEntry(), map);
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef dBIDRef, int n) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        UpdatableHeap updatableHeap = new UpdatableHeap();
        ((Heap)updatableHeap).add(new GenericMTreeDistanceSearchCandidate(0.0, this.getRootID(), null));
        while (!updatableHeap.isEmpty()) {
            double d;
            double d2;
            MkAppEntry mkAppEntry;
            int n2;
            GenericMTreeDistanceSearchCandidate genericMTreeDistanceSearchCandidate = (GenericMTreeDistanceSearchCandidate)((Heap)updatableHeap).poll();
            MkAppTreeNode mkAppTreeNode = (MkAppTreeNode)this.getNode(genericMTreeDistanceSearchCandidate.nodeID);
            if (!mkAppTreeNode.isLeaf()) {
                for (n2 = 0; n2 < mkAppTreeNode.getNumEntries(); ++n2) {
                    double d3;
                    mkAppEntry = (MkAppEntry)mkAppTreeNode.getEntry(n2);
                    d2 = this.distance(mkAppEntry.getRoutingObjectID(), dBIDRef);
                    d = mkAppEntry.getCoveringRadius() > d2 ? 0.0 : d2 - mkAppEntry.getCoveringRadius();
                    double d4 = d3 = ((MkAppTreeSettings)this.settings).log ? Math.exp(mkAppEntry.approximatedValueAt(n)) : mkAppEntry.approximatedValueAt(n);
                    if (d3 < 0.0) {
                        d3 = 0.0;
                    }
                    if (!(d <= d3)) continue;
                    ((Heap)updatableHeap).add(new GenericMTreeDistanceSearchCandidate(d, this.getPageID(mkAppEntry), mkAppEntry.getRoutingObjectID()));
                }
                continue;
            }
            for (n2 = 0; n2 < mkAppTreeNode.getNumEntries(); ++n2) {
                mkAppEntry = (MkAppLeafEntry)mkAppTreeNode.getEntry(n2);
                d2 = this.distance(((MTreeLeafEntry)((Object)mkAppEntry)).getRoutingObjectID(), dBIDRef);
                double d5 = d = ((MkAppTreeSettings)this.settings).log ? StrictMath.exp(((MkAppLeafEntry)mkAppEntry).approximatedValueAt(n)) : ((MkAppLeafEntry)mkAppEntry).approximatedValueAt(n);
                if (d < 0.0) {
                    d = 0.0;
                }
                if (!(d2 <= d)) continue;
                modifiableDoubleDBIDList.add(d2, ((MTreeLeafEntry)((Object)mkAppEntry)).getRoutingObjectID());
            }
        }
        return modifiableDoubleDBIDList;
    }

    public int getK_max() {
        return ((MkAppTreeSettings)this.settings).k_max;
    }

    @Override
    protected void initializeCapacities(MkAppEntry mkAppEntry) {
        int n = 8;
        double d = 12.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - d) / (8 + n + n + (((MkAppTreeSettings)this.settings).p + 1) * 4 + 2) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - d) / (4 + n + (((MkAppTreeSettings)this.settings).p + 1) * 4 + 2) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
        this.initialized = true;
        if (LOG.isVerbose()) {
            LOG.verbose("Directory Capacity: " + (this.dirCapacity - 1) + "\nLeaf Capacity:    " + (this.leafCapacity - 1));
        }
    }

    private double[] getMeanKNNList(DBIDs dBIDs, Map<DBID, KNNList> map) {
        double[] dArray = new double[((MkAppTreeSettings)this.settings).k_max];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            KNNList kNNList = map.get(dBID);
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (n < ((MkAppTreeSettings)this.settings).k_max && doubleDBIDListIter.valid()) {
                int n2 = n++;
                dArray[n2] = dArray[n2] + doubleDBIDListIter.doubleValue();
                doubleDBIDListIter.advance();
            }
            dBIDIter.advance();
        }
        int n = 0;
        while (n < ((MkAppTreeSettings)this.settings).k_max) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / (double)dBIDs.size();
        }
        return dArray;
    }

    private void adjustApproximatedKNNDistances(MkAppEntry mkAppEntry, Map<DBID, KNNList> map) {
        Externalizable externalizable;
        int n;
        MkAppTreeNode mkAppTreeNode = (MkAppTreeNode)this.getNode(mkAppEntry);
        if (mkAppTreeNode.isLeaf()) {
            for (n = 0; n < mkAppTreeNode.getNumEntries(); ++n) {
                externalizable = (MkAppLeafEntry)mkAppTreeNode.getEntry(n);
                PolynomialApproximation polynomialApproximation = this.approximateKnnDistances(this.getMeanKNNList(((AbstractLeafEntry)externalizable).getDBID(), map));
                ((MkAppLeafEntry)externalizable).setKnnDistanceApproximation(polynomialApproximation);
            }
        } else {
            for (n = 0; n < mkAppTreeNode.getNumEntries(); ++n) {
                externalizable = (MkAppEntry)mkAppTreeNode.getEntry(n);
                this.adjustApproximatedKNNDistances((MkAppEntry)externalizable, map);
            }
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        this.leafEntryIDs(mkAppTreeNode, arrayModifiableDBIDs);
        externalizable = this.approximateKnnDistances(this.getMeanKNNList(arrayModifiableDBIDs, map));
        mkAppEntry.setKnnDistanceApproximation((PolynomialApproximation)externalizable);
    }

    private void leafEntryIDs(MkAppTreeNode<O> mkAppTreeNode, ModifiableDBIDs modifiableDBIDs) {
        if (mkAppTreeNode.isLeaf()) {
            for (int i = 0; i < mkAppTreeNode.getNumEntries(); ++i) {
                MkAppEntry mkAppEntry = (MkAppEntry)mkAppTreeNode.getEntry(i);
                modifiableDBIDs.add(((LeafEntry)((Object)mkAppEntry)).getDBID());
            }
        } else {
            for (int i = 0; i < mkAppTreeNode.getNumEntries(); ++i) {
                MkAppTreeNode mkAppTreeNode2 = (MkAppTreeNode)this.getNode(mkAppTreeNode.getEntry(i));
                this.leafEntryIDs(mkAppTreeNode2, modifiableDBIDs);
            }
        }
    }

    private PolynomialApproximation approximateKnnDistances(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (((MkAppTreeSettings)this.settings).log) {
            double d;
            for (int i = 0; i < ((MkAppTreeSettings)this.settings).k_max && (d = dArray[i]) == 0.0; ++i) {
                ++n;
            }
        }
        Vector vector = new Vector(((MkAppTreeSettings)this.settings).k_max - n);
        Vector vector2 = new Vector(((MkAppTreeSettings)this.settings).k_max - n);
        for (int i = 0; i < ((MkAppTreeSettings)this.settings).k_max - n; ++i) {
            if (((MkAppTreeSettings)this.settings).log) {
                vector.set(i, Math.log(i + n));
                vector2.set(i, Math.log(dArray[i + n]));
                continue;
            }
            vector.set(i, i + n);
            vector2.set(i, dArray[i + n]);
        }
        PolynomialRegression polynomialRegression = new PolynomialRegression(vector2, vector, ((MkAppTreeSettings)this.settings).p);
        PolynomialApproximation polynomialApproximation = new PolynomialApproximation(polynomialRegression.getEstimatedCoefficients().getArrayCopy());
        if (LOG.isDebugging()) {
            stringBuilder.append("approximation ").append(polynomialApproximation);
            LOG.debugFine(stringBuilder.toString());
        }
        return polynomialApproximation;
    }

    @Override
    protected MkAppTreeNode<O> createNewLeafNode() {
        return new MkAppTreeNode(this.leafCapacity, true);
    }

    @Override
    protected MkAppTreeNode<O> createNewDirectoryNode() {
        return new MkAppTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkAppEntry createNewDirectoryEntry(MkAppTreeNode<O> mkAppTreeNode, DBID dBID, double d) {
        return new MkAppDirectoryEntry(dBID, d, mkAppTreeNode.getPageID(), mkAppTreeNode.coveringRadiusFromEntries(dBID, this), null);
    }

    @Override
    protected MkAppEntry createRootEntry() {
        return new MkAppDirectoryEntry(null, 0.0, 0, 0.0, null);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

