/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class OutputStreamLogger
extends OutputStreamWriter {
    private int charsSinceNewline = 0;
    protected static final char CARRIAGE_RETURN = '\r';
    public static final char UNIX_NEWLINE = '\n';
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final char[] NEWLINEC = NEWLINE.toCharArray();
    public static final String WHITESPACE = "                                                                                ";

    public OutputStreamLogger(OutputStream outputStream) {
        super(outputStream);
    }

    public OutputStreamLogger(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    public OutputStreamLogger(OutputStream outputStream, Charset charset) {
        super(outputStream, charset);
    }

    public OutputStreamLogger(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        super(outputStream, charsetEncoder);
    }

    @Override
    public void close() {
    }

    private int tailingNonNewline(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + (n2 - 1) - i;
            if (cArray[n3] == '\n') {
                return i;
            }
            if (cArray[n3] != '\r') continue;
            return i;
        }
        return n2;
    }

    private int tailingNonNewline(String string, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + (n2 - 1) - i;
            if (string.charAt(n3) == '\n') {
                return i;
            }
            if (string.charAt(n3) != '\r') continue;
            return i;
        }
        return n2;
    }

    private int countNonNewline(char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            if (cArray[n3] == '\n') {
                return i;
            }
            if (cArray[n3] != '\r') continue;
            return i;
        }
        return n2;
    }

    private int countNonNewline(String string, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            if (string.charAt(n3) == '\n') {
                return i;
            }
            if (string.charAt(n3) != '\r') continue;
            return i;
        }
        return n2;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.charsSinceNewline > 0) {
            if (cArray[n] != '\r') {
                super.write(NEWLINEC, 0, NEWLINEC.length);
                this.charsSinceNewline = 0;
            } else {
                int n3 = this.countNonNewline(cArray, n + 1, n2 - 1);
                if (n3 < this.charsSinceNewline) {
                    super.write(13);
                    while (this.charsSinceNewline > 0) {
                        int n4 = Math.min(this.charsSinceNewline, WHITESPACE.length());
                        super.write(WHITESPACE, 0, n4);
                        this.charsSinceNewline -= n4;
                    }
                } else {
                    this.charsSinceNewline = 0;
                }
            }
        }
        this.charsSinceNewline = this.tailingNonNewline(cArray, n, n2);
        super.write(cArray, n, n2);
        this.flush();
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.charsSinceNewline > 0) {
            if (string.charAt(n) != '\r') {
                super.write(NEWLINEC, 0, NEWLINEC.length);
                this.charsSinceNewline = 0;
            } else {
                int n3 = this.countNonNewline(string, n + 1, n2 - 1);
                if (n3 < this.charsSinceNewline) {
                    super.write(13);
                    while (this.charsSinceNewline > 0) {
                        int n4 = Math.min(this.charsSinceNewline, WHITESPACE.length());
                        super.write(WHITESPACE, 0, n4);
                        this.charsSinceNewline -= n4;
                    }
                } else {
                    this.charsSinceNewline = 0;
                }
            }
        }
        this.charsSinceNewline = this.tailingNonNewline(string, n, n2);
        super.write(string, n, n2);
        this.flush();
    }
}

