/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.random;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="S. Vigna", title="An experimental exploration of Marsaglia's xorshift generators, scrambled", booktitle="", url="http://vigna.di.unimi.it/ftp/papers/xorshift.pdf")
public class XorShift1024NonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long[] x;
    int p = 0;

    public XorShift1024NonThreadsafeRandom() {
    }

    public XorShift1024NonThreadsafeRandom(long l) {
        super(l);
    }

    @Override
    public void setSeed(long l) {
        this.x = new long[16];
        long l2 = l != 0L ? l : 4101842887655102017L;
        for (int i = 0; i < 16; ++i) {
            l2 ^= l2 >>> 12;
            l2 ^= l2 << 25;
            l2 ^= l2 >>> 27;
            this.x[i] = l2 * 2685821657736338717L;
        }
    }

    @Override
    public long nextLong() {
        long l = this.x[this.p];
        this.p = this.p + 1 & 0xF;
        long l2 = this.x[this.p];
        l2 ^= l2 << 31;
        l2 ^= l2 >>> 11;
        l ^= l >>> 30;
        this.x[this.p] = l ^ l2;
        return this.x[this.p] * 1181783497276652981L;
    }

    @Override
    protected int next(int n) {
        return (int)(this.nextLong() >>> 64 - n);
    }
}

