/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="B. M. Hill", title="A simple general approach to inference about the tail of a distribution", booktitle="The annals of statistics 3(5)", url="http://dx.doi.org/10.1214/aos/1176343247")
public class HillEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final HillEstimator STATIC = new HillEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int n2 = n - 1;
        double d = numberArrayAdapter.getDouble(a, n2);
        if (d <= 0.0) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double d2 = 0.5 * d;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = numberArrayAdapter.getDouble(a, i);
            assert (d4 > 0.0);
            d3 += d4 < d2 ? Math.log(d4 / d) : Math.log1p((d4 - d) / d);
        }
        return (double)(-n2) / d3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected HillEstimator makeInstance() {
            return STATIC;
        }
    }
}

