/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public abstract class AbstractPageFileFactory<P extends Page>
implements PageFileFactory<P> {
    protected int pageSize;

    public AbstractPageFileFactory(int n) {
        this.pageSize = n;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public static abstract class Parameterizer<P extends Page>
    extends AbstractParameterizer {
        public static final OptionID PAGE_SIZE_ID = new OptionID("pagefile.pagesize", "The size of a page in bytes.");
        protected int pageSize;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(PAGE_SIZE_ID, 4000);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.pageSize = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected abstract PageFileFactory<P> makeInstance();
    }
}

