/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.lines;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;

public class SolidLineStyleLibrary
implements LineStyleLibrary {
    private ColorLibrary colors;
    private String dotcolor;
    private String greycolor;

    public SolidLineStyleLibrary(StyleLibrary styleLibrary) {
        this.colors = styleLibrary.getColorSet("plot");
        this.dotcolor = styleLibrary.getColor("plot.marker");
        this.greycolor = styleLibrary.getColor("plot.grey");
    }

    @Override
    public void formatCSSClass(CSSClass cSSClass, int n, double d, Object ... objectArray) {
        if (n == -2) {
            cSSClass.setStatement("stroke", this.greycolor);
        } else if (n == -1) {
            cSSClass.setStatement("stroke", this.dotcolor);
        } else {
            cSSClass.setStatement("stroke", this.colors.getColor(n));
        }
        boolean bl = false;
        for (Object object : objectArray) {
            if ("strong".equals(object)) {
                d *= 1.5;
                continue;
            }
            if ("weak".equals(object)) {
                cSSClass.setStatement("stroke-opacity", ".50");
                d *= 0.75;
                continue;
            }
            if (!"interpolated".equals(object)) continue;
            bl = true;
        }
        cSSClass.setStatement("stroke-width", SVGUtil.fmt(d));
        if (bl) {
            cSSClass.setStatement("stroke-dasharray", "" + SVGUtil.fmt(d / 100.0 * 2.0) + "," + SVGUtil.fmt(d / 100.0 * 2.0));
        }
    }
}

