/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import org.w3c.dom.Element;

public class SVGHyperSphere {
    public static final double EUCLIDEAN_KAPPA = 0.5522847498;

    public static Element drawManhattan(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, double d) {
        double[] dArray = numberVector.getColumnVector().getArrayRef();
        long[] lArray = projection2D.getVisibleDimensions2D();
        SVGPath sVGPath = new SVGPath();
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n3 = n;
            dArray[n3] = dArray[n3] - d;
            int n4 = n;
            dArray[n4] = dArray[n4] - d;
            double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n5 = n;
            dArray[n5] = dArray[n5] + d;
            int n6 = BitsUtil.nextSetBit(lArray, 0);
            while (n6 >= 0) {
                if (n < n6) {
                    int n7 = n6;
                    dArray[n7] = dArray[n7] + d;
                    double[] dArray4 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n8 = n6;
                    dArray[n8] = dArray[n8] - d;
                    int n9 = n6;
                    dArray[n9] = dArray[n9] - d;
                    double[] dArray5 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n10 = n6;
                    dArray[n10] = dArray[n10] + d;
                    sVGPath.moveTo(dArray2[0], dArray2[1]);
                    sVGPath.drawTo(dArray4[0], dArray4[1]);
                    sVGPath.moveTo(dArray2[0], dArray2[1]);
                    sVGPath.drawTo(dArray5[0], dArray5[1]);
                    sVGPath.moveTo(dArray3[0], dArray3[1]);
                    sVGPath.drawTo(dArray4[0], dArray4[1]);
                    sVGPath.moveTo(dArray3[0], dArray3[1]);
                    sVGPath.drawTo(dArray5[0], dArray5[1]);
                    sVGPath.close();
                }
                n6 = BitsUtil.nextSetBit(lArray, n6 + 1);
            }
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawEuclidean(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, double d) {
        double[] dArray = numberVector.getColumnVector().getArrayRef();
        long[] lArray = projection2D.getVisibleDimensions2D();
        SVGPath sVGPath = new SVGPath();
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n3 = n;
            dArray[n3] = dArray[n3] - d;
            int n4 = n;
            dArray[n4] = dArray[n4] - d;
            double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n5 = n;
            dArray[n5] = dArray[n5] + d;
            double[] dArray4 = new double[dArray.length];
            dArray4[n] = d;
            double[] dArray5 = projection2D.fastProjectRelativeDataToRenderSpace(dArray4);
            int n6 = BitsUtil.nextSetBit(lArray, 0);
            while (n6 >= 0) {
                if (n < n6) {
                    int n7 = n6;
                    dArray[n7] = dArray[n7] + d;
                    double[] dArray6 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n8 = n6;
                    dArray[n8] = dArray[n8] - d;
                    int n9 = n6;
                    dArray[n9] = dArray[n9] - d;
                    double[] dArray7 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n10 = n6;
                    dArray[n10] = dArray[n10] + d;
                    double[] dArray8 = new double[dArray.length];
                    dArray8[n6] = d;
                    double[] dArray9 = projection2D.fastProjectRelativeDataToRenderSpace(dArray8);
                    sVGPath.moveTo(dArray2[0], dArray2[1]);
                    sVGPath.cubicTo(dArray2[0] + dArray9[0] * 0.5522847498, dArray2[1] + dArray9[1] * 0.5522847498, dArray6[0] + dArray5[0] * 0.5522847498, dArray6[1] + dArray5[1] * 0.5522847498, dArray6[0], dArray6[1]);
                    sVGPath.cubicTo(dArray6[0] - dArray5[0] * 0.5522847498, dArray6[1] - dArray5[1] * 0.5522847498, dArray3[0] + dArray9[0] * 0.5522847498, dArray3[1] + dArray9[1] * 0.5522847498, dArray3[0], dArray3[1]);
                    sVGPath.cubicTo(dArray3[0] - dArray9[0] * 0.5522847498, dArray3[1] - dArray9[1] * 0.5522847498, dArray7[0] - dArray5[0] * 0.5522847498, dArray7[1] - dArray5[1] * 0.5522847498, dArray7[0], dArray7[1]);
                    sVGPath.cubicTo(dArray7[0] + dArray5[0] * 0.5522847498, dArray7[1] + dArray5[1] * 0.5522847498, dArray2[0] - dArray9[0] * 0.5522847498, dArray2[1] - dArray9[1] * 0.5522847498, dArray2[0], dArray2[1]);
                    sVGPath.close();
                }
                n6 = BitsUtil.nextSetBit(lArray, n6 + 1);
            }
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawLp(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double[] dArray = numberVector.getColumnVector().getArrayRef();
        long[] lArray = projection2D.getVisibleDimensions2D();
        if (d2 > 1.0) {
            d5 = Math.pow(0.5, 1.0 / d2);
            d4 = Math.min(1.3, 4.0 * (2.0 * d5 - 1.0) / 3.0);
            d3 = 0.0;
        } else if (d2 < 1.0) {
            d5 = 1.0 - Math.pow(0.5, 1.0 / d2);
            d4 = 0.0;
            d3 = Math.min(1.3, 4.0 * (2.0 * d5 - 1.0) / 3.0);
        } else {
            d4 = 0.0;
            d3 = 0.0;
        }
        SVGPath sVGPath = new SVGPath();
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n3 = n;
            dArray[n3] = dArray[n3] - d;
            int n4 = n;
            dArray[n4] = dArray[n4] - d;
            double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n5 = n;
            dArray[n5] = dArray[n5] + d;
            double[] dArray4 = new double[dArray.length];
            dArray4[n] = d;
            double[] dArray5 = projection2D.fastProjectRelativeDataToRenderSpace(dArray4);
            int n6 = BitsUtil.nextSetBit(lArray, 0);
            while (n6 >= 0) {
                if (n < n6) {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    int n7 = n6;
                    dArray[n7] = dArray[n7] + d;
                    double[] dArray6 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n8 = n6;
                    dArray[n8] = dArray[n8] - d;
                    int n9 = n6;
                    dArray[n9] = dArray[n9] - d;
                    double[] dArray7 = projection2D.fastProjectDataToRenderSpace(dArray);
                    int n10 = n6;
                    dArray[n10] = dArray[n10] + d;
                    double[] dArray8 = new double[dArray.length];
                    dArray8[n6] = d;
                    double[] dArray9 = projection2D.fastProjectRelativeDataToRenderSpace(dArray8);
                    if (d2 > 1.0) {
                        sVGPath.moveTo(dArray2[0], dArray2[1]);
                        d13 = dArray2[0] + dArray9[0] * d4;
                        d12 = dArray2[1] + dArray9[1] * d4;
                        d11 = dArray6[0] + dArray5[0] * d4;
                        d10 = dArray6[1] + dArray5[1] * d4;
                        sVGPath.cubicTo(d13, d12, d11, d10, dArray6[0], dArray6[1]);
                        d9 = dArray6[0] - dArray5[0] * d4;
                        d8 = dArray6[1] - dArray5[1] * d4;
                        d7 = dArray3[0] + dArray9[0] * d4;
                        d6 = dArray3[1] + dArray9[1] * d4;
                        sVGPath.cubicTo(d9, d8, d7, d6, dArray3[0], dArray3[1]);
                        double d14 = dArray3[0] - dArray9[0] * d4;
                        double d15 = dArray3[1] - dArray9[1] * d4;
                        double d16 = dArray7[0] - dArray5[0] * d4;
                        double d17 = dArray7[1] - dArray5[1] * d4;
                        sVGPath.cubicTo(d14, d15, d16, d17, dArray7[0], dArray7[1]);
                        double d18 = dArray7[0] + dArray5[0] * d4;
                        double d19 = dArray7[1] + dArray5[1] * d4;
                        double d20 = dArray2[0] - dArray9[0] * d4;
                        double d21 = dArray2[1] - dArray9[1] * d4;
                        sVGPath.cubicTo(d18, d19, d20, d21, dArray2[0], dArray2[1]);
                        sVGPath.close();
                    } else if (d2 < 1.0) {
                        d13 = dArray2[0] - dArray5[0] * d3;
                        d12 = dArray2[1] - dArray5[1] * d3;
                        d11 = dArray6[0] - dArray9[0] * d3;
                        d10 = dArray6[1] - dArray9[1] * d3;
                        d9 = dArray3[0] + dArray5[0] * d3;
                        d8 = dArray3[1] + dArray5[1] * d3;
                        d7 = dArray7[0] + dArray9[0] * d3;
                        d6 = dArray7[1] + dArray9[1] * d3;
                        sVGPath.moveTo(dArray2[0], dArray2[1]);
                        sVGPath.cubicTo(d13, d12, d11, d10, dArray6[0], dArray6[1]);
                        sVGPath.cubicTo(d11, d10, d9, d8, dArray3[0], dArray3[1]);
                        sVGPath.cubicTo(d9, d8, d7, d6, dArray7[0], dArray7[1]);
                        sVGPath.cubicTo(d7, d6, d13, d12, dArray2[0], dArray2[1]);
                        sVGPath.close();
                    } else {
                        sVGPath.moveTo(dArray2[0], dArray2[1]);
                        sVGPath.lineTo(dArray6[0], dArray6[1]);
                        sVGPath.lineTo(dArray3[0], dArray3[1]);
                        sVGPath.lineTo(dArray7[0], dArray7[1]);
                        sVGPath.lineTo(dArray2[0], dArray2[1]);
                        sVGPath.close();
                    }
                }
                n6 = BitsUtil.nextSetBit(lArray, n6 + 1);
            }
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawCross(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, double d) {
        double[] dArray = numberVector.getColumnVector().getArrayRef();
        long[] lArray = projection2D.getVisibleDimensions2D();
        SVGPath sVGPath = new SVGPath();
        int n = BitsUtil.nextSetBit(lArray, 0);
        while (n >= 0) {
            int n2 = n;
            dArray[n2] = dArray[n2] + d;
            double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n3 = n;
            dArray[n3] = dArray[n3] - d;
            sVGPath.moveTo(dArray2[0], dArray2[1]);
            int n4 = n;
            dArray[n4] = dArray[n4] - d;
            double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
            int n5 = n;
            dArray[n5] = dArray[n5] + d;
            sVGPath.drawTo(dArray3[0], dArray3[1]);
            sVGPath.close();
            n = BitsUtil.nextSetBit(lArray, n + 1);
        }
        return sVGPath.makeElement(sVGPlot);
    }
}

