/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.OPTICSModel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class OPTICSClusterVisualization
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(OPTICSClusterVisualization.class);
    private static final String NAME = "OPTICS Cluster Ranges";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<OPTICSProjector> iter = VisualizationTree.filter(visualizerContext, object, OPTICSProjector.class);
        while (iter.valid()) {
            OPTICSProjector oPTICSProjector = iter.get();
            Clustering<OPTICSModel> clustering = OPTICSClusterVisualization.findOPTICSClustering(visualizerContext, oPTICSProjector.getResult());
            if (clustering != null) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, clustering, null, this);
                visualizationTask.level = 100;
                visualizerContext.addVis(oPTICSProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    protected static Clustering<OPTICSModel> findOPTICSClustering(VisualizerContext visualizerContext, Result result) {
        Hierarchy.Iter<Clustering> iter = VisualizationTree.filterResults(visualizerContext, result, Clustering.class);
        while (iter.valid()) {
            Clustering clustering = iter.get();
            if (clustering.getToplevelClusters().size() != 0) {
                try {
                    Cluster cluster = clustering.getToplevelClusters().iterator().next();
                    if (cluster.getModel() instanceof OPTICSModel) {
                        return clustering;
                    }
                }
                catch (Exception exception) {
                    LOG.warning("Clustering with no cluster detected.", exception);
                }
            }
            iter.advance();
        }
        return null;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        protected static final String CSS_BRACKET = "opticsBracket";
        Clustering<OPTICSModel> clus;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.clus = (Clustering)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            ColorLibrary colorLibrary = this.context.getStyleLibrary().getColorSet("plot");
            HashMap hashMap = new HashMap();
            int n = 0;
            for (Cluster<OPTICSModel> cluster : this.clus.getAllClusters()) {
                hashMap.put(cluster, colorLibrary.getColor(n));
                ++n;
            }
            this.drawClusters(this.clus, this.clus.iterToplevelClusters(), 1, hashMap);
        }

        private void drawClusters(Clustering<OPTICSModel> clustering, Hierarchy.Iter<Cluster<OPTICSModel>> iter, int n, Map<Cluster<?>, String> map) {
            while (iter.valid()) {
                Object object;
                Cluster<OPTICSModel> cluster = iter.get();
                try {
                    object = cluster.getModel();
                    double d = this.plotwidth * (((double)((OPTICSModel)object).getStartIndex() + 0.25) / (double)this.optics.getResult().size());
                    double d2 = this.plotwidth * (((double)((OPTICSModel)object).getEndIndex() + 0.75) / (double)this.optics.getResult().size());
                    double d3 = this.plotheight + (double)n * 100.0 * 0.01;
                    Element element = this.svgp.svgLine(d, d3, d2, d3);
                    SVGUtil.addCSSClass(element, CSS_BRACKET);
                    String string = map.get(cluster);
                    if (string != null) {
                        SVGUtil.setAtt(element, "style", "stroke:" + string);
                    }
                    this.layer.appendChild(element);
                }
                catch (ClassCastException classCastException) {
                    LOG.warning("Expected OPTICSModel, got: " + cluster.getModel().getClass().getSimpleName());
                }
                object = clustering.getClusterHierarchy().iterChildren(cluster);
                if (object != null) {
                    this.drawClusters(clustering, (Hierarchy.Iter<Cluster<OPTICSModel>>)object, n + 1, map);
                }
                iter.advance();
            }
        }

        private void addCSSClasses() {
            if (!this.svgp.getCSSClassManager().contains(CSS_BRACKET)) {
                CSSClass cSSClass = new CSSClass(this, CSS_BRACKET);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

