/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolAxisRangeVisualization
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(SelectionToolAxisRangeVisualization.class);
    private static final String NAME = "Axis Range Selection";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 1000;
                visualizationTask.tool = true;
                visualizationTask.addUpdateFlags(2);
                visualizationTask.addFlags(5);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionAxisRangeMarker";
        private Element rtag;
        private Element etag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g");
            SVGUtil.addCSSClass(this.rtag, CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, -0.1 * this.getMarginLeft(), -0.1 * this.getMarginTop(), this.getSizeX() + this.getMarginLeft() * 0.2, this.getSizeY() + this.getMarginTop() * 0.2, this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.etag);
        }

        private void deleteChildren(Element element) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getLastChild());
            }
        }

        private void updateSelectionRectKoordinates(double d, double d2, double d3, double d4, ModifiableHyperBoundingBox modifiableHyperBoundingBox) {
            double d5;
            int n;
            int n2 = this.proj.getVisibleDimensions();
            int n3 = n2 + 1;
            int n4 = -1;
            for (n = 0; n < n2; ++n) {
                d5 = this.getVisibleAxisX(n);
                if (!(d < d5) && !(d2 < d5)) continue;
                n3 = n;
                break;
            }
            while (n <= n2) {
                d5 = this.getVisibleAxisX(n);
                if (d2 < d5 && d < d5) {
                    n4 = n;
                    break;
                }
                ++n;
            }
            double d6 = Math.max(Math.min(d3, d4), 0.0);
            double d7 = Math.min(Math.max(d3, d4), this.getSizeY());
            for (int i = n3; i < n4; ++i) {
                double d8 = this.proj.fastProjectRenderToDataSpace(d6, i);
                double d9 = this.proj.fastProjectRenderToDataSpace(d7, i);
                int n5 = this.proj.getDimForVisibleAxis(i);
                if (LOG.isDebugging()) {
                    LOG.debug("Axis " + i + " dimension " + n5 + " " + d8 + " to " + d9);
                }
                modifiableHyperBoundingBox.setMin(n5, Math.min(d8, d9));
                modifiableHyperBoundingBox.setMax(n5, Math.max(d8, d9));
            }
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
            double d2 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
            double d3 = Math.abs(sVGPoint.getX() - sVGPoint2.getX());
            double d4 = Math.abs(sVGPoint.getY() - sVGPoint2.getY());
            this.rtag.appendChild(this.svgp.svgRect(d, d2, d3, d4));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            if (sVGPoint.getX() != sVGPoint2.getX() || sVGPoint.getY() != sVGPoint2.getY()) {
                this.updateSelection(this.proj, sVGPoint, sVGPoint2);
            }
            return true;
        }

        private void updateSelection(Projection projection, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
            DBIDSelection dBIDSelection = this.context.getSelection();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = dBIDSelection != null ? DBIDUtil.newHashSet(dBIDSelection.getSelectedIds()) : DBIDUtil.newHashSet();
            if (sVGPoint == null || sVGPoint2 == null) {
                LOG.warning("no rect selected: p1: " + sVGPoint + " p2: " + sVGPoint2);
            } else {
                double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
                double d2 = Math.max(sVGPoint.getX(), sVGPoint2.getX());
                double d3 = Math.max(sVGPoint.getY(), sVGPoint2.getY());
                double d4 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
                int n = projection.getInputDimensionality();
                ModifiableHyperBoundingBox modifiableHyperBoundingBox = dBIDSelection instanceof RangeSelection ? ((RangeSelection)dBIDSelection).getRanges() : new ModifiableHyperBoundingBox(n, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                this.updateSelectionRectKoordinates(d, d2, d3, d4, modifiableHyperBoundingBox);
                hashSetModifiableDBIDs.clear();
                DBIDIter dBIDIter = this.relation.iterDBIDs();
                while (dBIDIter.valid()) {
                    block5: {
                        NumberVector numberVector = (NumberVector)this.relation.get(dBIDIter);
                        for (int i = 0; i < n; ++i) {
                            double d5 = modifiableHyperBoundingBox.getMin(i);
                            double d6 = modifiableHyperBoundingBox.getMax(i);
                            if (!(d6 < Double.POSITIVE_INFINITY) || !(d5 > Double.NEGATIVE_INFINITY) || !(numberVector.doubleValue(i) < d5) && !(numberVector.doubleValue(i) > d6)) {
                                continue;
                            }
                            break block5;
                        }
                        hashSetModifiableDBIDs.add(dBIDIter);
                    }
                    dBIDIter.advance();
                }
                this.context.setSelection(new RangeSelection(hashSetModifiableDBIDs, modifiableHyperBoundingBox));
            }
        }

        protected void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass cSSClass = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection.active"));
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection.active"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

