/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.IntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DendrogramVisualization
extends AbstractVisFactory {
    private static final String NAME = "Dendrogram";
    private Style style = Style.RECTANGULAR;

    public DendrogramVisualization(Style style) {
        this.style = style;
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<PointerHierarchyRepresentationResult> iter = VisualizationTree.filterResults(visualizerContext, object, PointerHierarchyRepresentationResult.class);
        while (iter.valid()) {
            PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, pointerHierarchyRepresentationResult, null, this);
            visualizationTask.level = 200;
            visualizationTask.addUpdateFlags(4);
            visualizationTask.reqwidth = 1.0;
            visualizationTask.reqheight = 1.0;
            visualizerContext.addVis(visualizerContext.getStylingPolicy(), visualizationTask);
            visualizerContext.addVis(pointerHierarchyRepresentationResult, new SwitchStyleAction(visualizationTask, visualizerContext));
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STYLE_ID = new OptionID("dendrogram.style", "Drawing style for dendrograms.");
        private Style style = Style.RECTANGULAR;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            EnumParameter<Style> enumParameter = new EnumParameter<Style>(STYLE_ID, Style.class, Style.RECTANGULAR);
            if (parameterization.grab(enumParameter)) {
                this.style = (Style)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected DendrogramVisualization makeInstance() {
            return new DendrogramVisualization(this.style);
        }
    }

    public class Instance
    extends AbstractVisualization {
        private static final String KEY_CAPTION = "key-caption";
        private static final String KEY_HIERLINE = "key-hierarchy";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2) {
            super(visualizationTask, visualizationPlot, d, d2);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            Object object;
            this.layer = this.svgp.svgElement("g");
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult = (PointerHierarchyRepresentationResult)this.task.getResult();
            DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
            DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
            DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
            IntegerDataStore integerDataStore = pointerHierarchyRepresentationResult.getPositions();
            DBIDVar dBIDVar = DBIDUtil.newVar();
            int n = dBIDs.size();
            double d = 10.0 / Math.log1p(n);
            double d2 = 100.0;
            double d3 = d2 / this.getWidth() * this.getHeight();
            double d4 = d2 / (double)n;
            double d5 = d4 * 0.5;
            double d6 = Double.MIN_NORMAL;
            Object object2 = dBIDs.iter();
            while (object2.valid()) {
                double d7;
                if (!DBIDUtil.equal((DBIDRef)object2, dBIDDataStore.assignVar((DBIDRef)object2, dBIDVar)) && (d7 = doubleDataStore.doubleValue((DBIDRef)object2)) != Double.POSITIVE_INFINITY) {
                    d6 = d7 > d6 ? d7 : d6;
                }
                object2.advance();
            }
            object2 = new LinearScale(0.0, d6);
            try {
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, (LinearScale)object2, 0.0, d3, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
            }
            catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
                LoggingUtil.exception(cSSNamingConflict);
            }
            double[] dArray = new double[n << 1];
            Object object3 = dBIDs.iter();
            while (object3.valid()) {
                int n2 = integerDataStore.intValue((DBIDRef)object3);
                dArray[n2] = (double)n2 * d4 + d5;
                dArray[n2 + n] = d3;
                object3.advance();
            }
            object3 = DBIDUtil.newArray(dBIDs);
            object3.sort(new DataStoreUtil.AscendingByDoubleDataStoreAndId(doubleDataStore));
            if (stylingPolicy instanceof ClassStylingPolicy) {
                object = (ClassStylingPolicy)stylingPolicy;
                this.setupCSS(this.svgp, (ClassStylingPolicy)object, d);
                int n3 = object.getMinStyle() - 1;
                int n4 = object.getMaxStyle();
                SVGPath[] sVGPathArray = new SVGPath[n4 - n3 + 1];
                for (int i = 0; i < sVGPathArray.length; ++i) {
                    sVGPathArray[i] = new SVGPath();
                }
                DBIDArrayMIter dBIDArrayMIter = object3.iter();
                while (dBIDArrayMIter.valid()) {
                    dBIDDataStore.assignVar(dBIDArrayMIter, dBIDVar);
                    double d8 = doubleDataStore.doubleValue(dBIDArrayMIter);
                    int n5 = integerDataStore.intValue(dBIDArrayMIter);
                    int n6 = object.getStyleForDBID(dBIDArrayMIter);
                    double d9 = dArray[n5];
                    double d10 = dArray[n5 + n];
                    if (DBIDUtil.equal(dBIDArrayMIter, dBIDVar)) {
                        sVGPathArray[n6 - n3 + 1].moveTo(d9, d10).verticalLineTo(d3 * (1.0 - ((LinearScale)object2).getScaled(d8)));
                    } else {
                        int n7 = integerDataStore.intValue(dBIDVar);
                        int n8 = object.getStyleForDBID(dBIDVar);
                        double d11 = dArray[n7];
                        double d12 = dArray[n7 + n];
                        double d13 = (d9 + d11) * 0.5;
                        double d14 = d3 * (1.0 - ((LinearScale)object2).getScaled(d8));
                        switch (DendrogramVisualization.this.style) {
                            case RECTANGULAR: {
                                if (n6 == n8) {
                                    sVGPathArray[n6 - n3 + 1].moveTo(d9, d10).verticalLineTo(d14).horizontalLineTo(d11).verticalLineTo(d12);
                                    break;
                                }
                                sVGPathArray[d10 == d3 ? n6 - n3 + 1 : 0].moveTo(d9, d10).verticalLineTo(d14);
                                sVGPathArray[d12 == d3 ? n8 - n3 + 1 : 0].moveTo(d11, d12).verticalLineTo(d14);
                                sVGPathArray[0].moveTo(d9, d14).horizontalLineTo(d11);
                                break;
                            }
                            case TRIANGULAR: {
                                if (n6 == n8) {
                                    sVGPathArray[n6 - n3 + 1].moveTo(d9, d10).drawTo(d13, d14).drawTo(d11, d12);
                                    break;
                                }
                                sVGPathArray[d10 == d3 ? n6 - n3 + 1 : 0].moveTo(d9, d10).drawTo(d13, d14);
                                sVGPathArray[d12 == d3 ? n8 - n3 + 1 : 0].moveTo(d11, d12).drawTo(d13, d14);
                            }
                        }
                        dArray[n7] = d13;
                        dArray[n7 + n] = d14;
                    }
                    dBIDArrayMIter.advance();
                }
                for (int i = 0; i < sVGPathArray.length; ++i) {
                    SVGPath sVGPath = sVGPathArray[i];
                    if (!sVGPath.isStarted()) continue;
                    Element element = sVGPath.makeElement(this.svgp);
                    SVGUtil.setCSSClass(element, i > 0 ? "key-hierarchy_" + (i + n3 - 1) : KEY_HIERLINE);
                    this.layer.appendChild(element);
                }
            } else {
                this.setupCSS(this.svgp, d);
                object = new SVGPath();
                Object object4 = object3.iter();
                while (object4.valid()) {
                    double d15 = doubleDataStore.doubleValue((DBIDRef)object4);
                    int n9 = integerDataStore.intValue((DBIDRef)object4);
                    double d16 = dArray[n9];
                    double d17 = dArray[n9 + n];
                    if (DBIDUtil.equal((DBIDRef)object4, dBIDDataStore.assignVar((DBIDRef)object4, dBIDVar))) {
                        ((SVGPath)object).moveTo(d16, d17).verticalLineTo(d3 * (1.0 - ((LinearScale)object2).getScaled(d15)));
                    } else {
                        int n10 = integerDataStore.intValue(dBIDVar);
                        double d18 = dArray[n10];
                        double d19 = dArray[n10 + n];
                        double d20 = (d16 + d18) * 0.5;
                        double d21 = d3 * (1.0 - ((LinearScale)object2).getScaled(d15));
                        switch (DendrogramVisualization.this.style) {
                            case RECTANGULAR: {
                                ((SVGPath)object).moveTo(d16, d17).verticalLineTo(d21).horizontalLineTo(d18).verticalLineTo(d19);
                                break;
                            }
                            case TRIANGULAR: {
                                ((SVGPath)object).moveTo(d16, d17).drawTo(d20, d21).drawTo(d18, d19);
                            }
                        }
                        dArray[n10] = d20;
                        dArray[n10 + n] = d21;
                    }
                    object4.advance();
                }
                object4 = ((SVGPath)object).makeElement(this.svgp);
                SVGUtil.setCSSClass((Element)object4, KEY_HIERLINE);
                this.layer.appendChild((Node)object4);
            }
            double d22 = styleLibrary.getSize("margin");
            String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), d2, d3, d22);
            SVGUtil.setAtt(this.layer, "transform", string);
        }

        protected void setupCSS(SVGPlot sVGPlot, double d) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d2 = styleLibrary.getTextSize("key");
            String string = styleLibrary.getFontFamily("key");
            String string2 = styleLibrary.getColor("key");
            CSSClass cSSClass = new CSSClass(sVGPlot, KEY_CAPTION);
            cSSClass.setStatement("font-size", d2);
            cSSClass.setStatement("font-family", string);
            cSSClass.setStatement("fill", string2);
            cSSClass.setStatement("font-weight", "bold");
            sVGPlot.addCSSClassOrLogError(cSSClass);
            CSSClass cSSClass2 = new CSSClass(sVGPlot, KEY_HIERLINE);
            cSSClass2.setStatement("stroke", string2);
            cSSClass2.setStatement("stroke-width", d * styleLibrary.getLineWidth("key.hierarchy") / 100.0);
            cSSClass2.setStatement("stroke-linecap", "round");
            cSSClass2.setStatement("fill", "none");
            sVGPlot.addCSSClassOrLogError(cSSClass2);
            sVGPlot.updateStyleElement();
        }

        protected void setupCSS(SVGPlot sVGPlot, ClassStylingPolicy classStylingPolicy, double d) {
            this.setupCSS(sVGPlot, d);
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            for (int i = classStylingPolicy.getMinStyle(); i <= classStylingPolicy.getMaxStyle(); ++i) {
                CSSClass cSSClass = new CSSClass(sVGPlot, "key-hierarchy_" + i);
                cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("key.hierarchy") / 100.0);
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("fill", "none");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            sVGPlot.updateStyleElement();
        }
    }

    public class SwitchStyleAction
    implements VisualizationMenuAction {
        private VisualizationTask task;
        private VisualizerContext context;

        public SwitchStyleAction(VisualizationTask visualizationTask, VisualizerContext visualizerContext) {
            this.task = visualizationTask;
            this.context = visualizerContext;
        }

        @Override
        public String getMenuName() {
            return "Switch Dendrogram Style";
        }

        @Override
        public void activate() {
            switch (DendrogramVisualization.this.style) {
                case RECTANGULAR: {
                    DendrogramVisualization.this.style = Style.TRIANGULAR;
                    break;
                }
                case TRIANGULAR: {
                    DendrogramVisualization.this.style = Style.RECTANGULAR;
                }
            }
            this.context.visChanged(this.task);
        }

        @Override
        public boolean enabled() {
            return true;
        }
    }

    public static enum Style {
        RECTANGULAR,
        TRIANGULAR;

    }
}

