/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.packageManagement.DefaultPackageManager;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.PackageManager;
import org.pentaho.packageManagement.VersionPackageConstraint;
import weka.core.ClassDiscovery;
import weka.core.ClassloaderUtil;
import weka.core.Environment;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.beans.BeansProperties;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.PluginManager;
import weka.gui.explorer.ExplorerDefaults;

public class WekaPackageManager {
    private static String WEKAFILES_DIR_NAME = "wekafiles";
    public static File WEKA_HOME = new File(String.valueOf(System.getProperty("user.home")) + File.separator + WEKAFILES_DIR_NAME);
    public static File PACKAGES_DIR = new File(String.valueOf(WEKA_HOME.toString()) + File.separator + "packages");
    private static String PROPERTIES_DIR_NAME = "props";
    public static File PROPERTIES_DIR = new File(String.valueOf(WEKA_HOME.toString()) + File.separator + PROPERTIES_DIR_NAME);
    private static PackageManager PACKAGE_MANAGER = PackageManager.create();
    private static URL REP_URL;
    private static URL CACHE_URL;
    private static boolean INITIAL_CACHE_BUILD_NEEDED;
    private static String PACKAGE_LIST_FILENAME;
    private static String PRIMARY_REPOSITORY;
    private static String REP_MIRROR;
    private static boolean USER_SET_REPO;
    private static String PACKAGE_MANAGER_PROPS_FILE_NAME;
    public static boolean m_offline;
    private static boolean m_loadPackages;
    protected static boolean m_wekaHomeEstablished;
    protected static boolean m_packagesLoaded;
    public static boolean m_initialPackageLoadingInProcess;
    public static boolean m_noPackageMetaDataAvailable;

    static {
        INITIAL_CACHE_BUILD_NEEDED = false;
        PACKAGE_LIST_FILENAME = "packageListWithVersion.txt";
        PRIMARY_REPOSITORY = "http://weka.sourceforge.net/packageMetaData";
        USER_SET_REPO = false;
        PACKAGE_MANAGER_PROPS_FILE_NAME = "PackageManager.props";
        m_loadPackages = true;
        m_initialPackageLoadingInProcess = false;
        WekaPackageManager.establishWekaHome();
    }

    protected static boolean establishWekaHome() {
        File generalProps;
        String loadPackages;
        String offline;
        if (m_wekaHomeEstablished) {
            return true;
        }
        Environment env = Environment.getSystemWide();
        String wh = env.getVariableValue("WEKA_HOME");
        if (wh != null) {
            WEKA_HOME = new File(wh);
            PACKAGES_DIR = new File(String.valueOf(wh) + File.separator + "packages");
            PROPERTIES_DIR = new File(String.valueOf(wh) + File.separator + PROPERTIES_DIR_NAME);
        } else {
            env.addVariableSystemWide("WEKA_HOME", WEKA_HOME.toString());
        }
        boolean ok = true;
        if (!WEKA_HOME.exists() && !WEKA_HOME.mkdir()) {
            System.err.println("Unable to create WEKA_HOME (" + WEKA_HOME.getAbsolutePath() + ")");
            ok = false;
        }
        if (!PACKAGES_DIR.exists() && !PACKAGES_DIR.mkdir()) {
            System.err.println("Unable to create packages directory (" + PACKAGES_DIR.getAbsolutePath() + ")");
            ok = false;
        }
        m_wekaHomeEstablished = ok;
        PACKAGE_MANAGER.setPackageHome(PACKAGES_DIR);
        try {
            File repPropsFile;
            String repURL = env.getVariableValue("weka.core.wekaPackageRepositoryURL");
            if ((repURL == null || repURL.length() == 0) && (repPropsFile = new File(String.valueOf(PROPERTIES_DIR.toString()) + File.separator + "PackageRepository.props")).exists()) {
                Properties repProps = new Properties();
                repProps.load(new FileInputStream(repPropsFile));
                repURL = repProps.getProperty("weka.core.wekaPackageRepositoryURL");
            }
            if (repURL == null || repURL.length() == 0) {
                repURL = PRIMARY_REPOSITORY;
            } else {
                WekaPackageManager.log(Logger.Level.INFO, "[WekaPackageManager] weka.core.WekaPackageRepositoryURL = " + repURL);
                USER_SET_REPO = true;
            }
            REP_URL = new URL(repURL);
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        PACKAGE_MANAGER.setBaseSystemName("weka");
        PACKAGE_MANAGER.setBaseSystemVersion(Version.VERSION);
        File cacheDir = new File(String.valueOf(WEKA_HOME.toString()) + File.separator + "repCache");
        try {
            String tempCacheString = "file://" + cacheDir.toString();
            tempCacheString = tempCacheString.replace(" ", "%20");
            tempCacheString = tempCacheString.replace('\\', '/');
            if (tempCacheString.startsWith("file://") && !tempCacheString.startsWith("file:///")) {
                tempCacheString = tempCacheString.substring(7);
                tempCacheString = "file:///" + tempCacheString;
            }
            URI tempURI = new URI(tempCacheString);
            CACHE_URL = tempURI.toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File packagesList = new File(String.valueOf(cacheDir.getAbsolutePath()) + File.separator + PACKAGE_LIST_FILENAME);
        if (!cacheDir.exists()) {
            if (!cacheDir.mkdir()) {
                System.err.println("Unable to create repository cache directory (" + cacheDir.getAbsolutePath() + ")");
                WekaPackageManager.log(Logger.Level.WARNING, "Unable to create repository cache directory (" + cacheDir.getAbsolutePath() + ")");
                CACHE_URL = null;
            } else {
                INITIAL_CACHE_BUILD_NEEDED = true;
            }
        }
        if (!packagesList.exists()) {
            INITIAL_CACHE_BUILD_NEEDED = true;
        }
        if ((offline = env.getVariableValue("weka.packageManager.offline")) != null) {
            m_offline = offline.equalsIgnoreCase("true");
        }
        if ((loadPackages = env.getVariableValue("weka.packageManager.loadPackages")) == null) {
            loadPackages = env.getVariableValue("weka.core.loadPackages");
        }
        if (loadPackages != null) {
            m_loadPackages = loadPackages.equalsIgnoreCase("true");
        }
        if ((generalProps = new File(String.valueOf(PROPERTIES_DIR.toString()) + File.separator + PACKAGE_MANAGER_PROPS_FILE_NAME)).exists()) {
            Properties gProps = new Properties();
            try {
                String pluginManagerDisableList;
                gProps.load(new FileInputStream(generalProps));
                String repURL = gProps.getProperty("weka.core.wekaPackageRepositoryURL");
                if (repURL != null && repURL.length() > 0) {
                    REP_URL = new URL(repURL);
                    PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
                }
                if ((offline = gProps.getProperty("weka.packageManager.offline")) != null && offline.length() > 0) {
                    m_offline = offline.equalsIgnoreCase("true");
                }
                if ((loadPackages = gProps.getProperty("weka.packageManager.loadPackages")) == null) {
                    loadPackages = env.getVariableValue("weka.core.loadPackages");
                }
                if (loadPackages != null) {
                    m_loadPackages = loadPackages.equalsIgnoreCase("true");
                }
                if ((pluginManagerDisableList = gProps.getProperty("weka.pluginManager.disable")) != null && pluginManagerDisableList.length() > 0) {
                    String[] parts;
                    ArrayList<String> disable = new ArrayList<String>();
                    String[] stringArray = parts = pluginManagerDisableList.split(",");
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        disable.add(s.trim());
                        ++n2;
                    }
                    PluginManager.addToDisabledList(disable);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (INITIAL_CACHE_BUILD_NEEDED && m_offline) {
            m_noPackageMetaDataAvailable = true;
        }
        return ok;
    }

    protected static void establishMirror() {
        if (m_offline) {
            return;
        }
        try {
            String mirrorListURL = "http://www.cs.waikato.ac.nz/ml/weka/packageMetaDataMirror.txt";
            URLConnection conn = null;
            URL connURL = new URL(mirrorListURL);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            REP_MIRROR = bi.readLine();
            bi.close();
            if (REP_MIRROR != null && REP_MIRROR.length() > 0 && !REP_MIRROR.equals(PRIMARY_REPOSITORY) && !USER_SET_REPO) {
                WekaPackageManager.log(Logger.Level.INFO, "[WekaPackageManager] Package manager using repository mirror: " + REP_MIRROR);
                REP_URL = new URL(REP_MIRROR);
            }
        }
        catch (Exception ex) {
            WekaPackageManager.log(Logger.Level.WARNING, "[WekaPackageManager] The repository meta data mirror file seems to be unavailable (" + ex.getMessage() + ")");
        }
    }

    protected static void log(Logger.Level level, String message) {
        try {
            File logFile = new File(String.valueOf(WEKA_HOME.toString()) + File.separator + "weka.log");
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, true));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String linefeed = System.getProperty("line.separator");
            String m = String.valueOf(format.format(new Date())) + " " + (Object)((Object)level) + ": " + message + linefeed;
            writer.write(m);
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeExplorerProps(String installedPackageName) {
        try {
            Properties expProps = new Properties();
            String explorerProps = String.valueOf(WekaPackageManager.getPackageHome().getAbsolutePath()) + File.separator + installedPackageName + File.separator + "Explorer.props";
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(explorerProps));
            expProps.load(bi);
            bi.close();
            bi = null;
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                if (string.endsWith("Policy")) continue;
                String existingVal = ExplorerDefaults.get(string, "");
                String toRemove = expProps.getProperty(string);
                if (existingVal.length() <= 0) continue;
                existingVal = existingVal.replace(String.valueOf(toRemove) + ",", "");
                existingVal = existingVal.replace("," + toRemove, "");
                ExplorerDefaults.set(string, existingVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processGenericPropertiesCreatorProps(File propsFile) {
        try {
            Properties expProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            expProps.load(bi);
            bi.close();
            bi = null;
            Properties GPCInputProps = GenericPropertiesCreator.getGlobalInputProperties();
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                String newVal;
                String existingVal = GPCInputProps.getProperty(string, "");
                if (existingVal.length() > 0) {
                    newVal = expProps.getProperty(string);
                    if (existingVal.indexOf(newVal) >= 0) continue;
                    newVal = String.valueOf(existingVal) + "," + newVal;
                    GPCInputProps.put(string, newVal);
                    continue;
                }
                newVal = expProps.getProperty(string);
                GPCInputProps.put(string, newVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processExplorerProps(File propsFile) {
        try {
            Properties expProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            expProps.load(bi);
            bi.close();
            bi = null;
            Set<Object> keys = expProps.keySet();
            for (String string : keys) {
                if (string.endsWith("Policy")) continue;
                String existingVal = ExplorerDefaults.get(string, "");
                if (existingVal.length() > 0) {
                    String newVal;
                    String replacePolicy = expProps.getProperty(String.valueOf(string) + "Policy");
                    if (replacePolicy != null && replacePolicy.length() > 0) {
                        if (replacePolicy.equalsIgnoreCase("replace")) {
                            newVal = expProps.getProperty(string);
                            ExplorerDefaults.set(string, newVal);
                            continue;
                        }
                        newVal = expProps.getProperty(string);
                        if (existingVal.indexOf(newVal) >= 0) continue;
                        newVal = String.valueOf(existingVal) + "," + newVal;
                        ExplorerDefaults.set(string, newVal);
                        continue;
                    }
                    newVal = expProps.getProperty(string);
                    if (existingVal.indexOf(newVal) >= 0) continue;
                    newVal = String.valueOf(existingVal) + "," + newVal;
                    ExplorerDefaults.set(string, newVal);
                    continue;
                }
                String newVal = expProps.getProperty(string);
                ExplorerDefaults.set(string, newVal);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processGUIEditorsProps(File propsFile) {
        GenericObjectEditor.registerEditors();
        try {
            Properties editorProps = new Properties();
            BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
            editorProps.load(bi);
            bi.close();
            bi = null;
            Enumeration<?> enm = editorProps.propertyNames();
            while (enm.hasMoreElements()) {
                String name = enm.nextElement().toString();
                String value = editorProps.getProperty(name, "");
                System.err.println("Registering " + name + " " + value);
                GenericObjectEditor.registerEditor(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void processPluginManagerProps(File propsFile) {
        try {
            PluginManager.addFromProperties(propsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void loadPackageDirectory(File directory, boolean verbose, List<File> goePropsFiles, boolean avoidTriggeringFullClassDiscovery) throws Exception {
        File content;
        File[] contents;
        File[] fileArray = contents = directory.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            content = fileArray[n2];
            if (content.isFile() && content.getPath().endsWith(".jar")) {
                if (verbose) {
                    System.out.println("[Weka] loading " + content.getPath());
                }
                ClassloaderUtil.addFile(content.getPath());
            } else if (content.isDirectory() && content.getName().equalsIgnoreCase("lib")) {
                WekaPackageManager.loadPackageDirectory(content, verbose, goePropsFiles, avoidTriggeringFullClassDiscovery);
            }
            ++n2;
        }
        fileArray = contents;
        n = contents.length;
        n2 = 0;
        while (n2 < n) {
            content = fileArray[n2];
            if (content.isFile() && content.getPath().endsWith("Beans.props")) {
                BeansProperties.addToPluginBeanProps(content);
                if (!avoidTriggeringFullClassDiscovery) {
                    KnowledgeFlowApp.disposeSingleton();
                }
            } else if (content.isFile() && content.getPath().endsWith("Explorer.props") && !avoidTriggeringFullClassDiscovery) {
                WekaPackageManager.processExplorerProps(content);
            } else if (content.isFile() && content.getPath().endsWith("GUIEditors.props") && !avoidTriggeringFullClassDiscovery) {
                WekaPackageManager.processGUIEditorsProps(content);
            } else if (content.isFile() && content.getPath().endsWith("GenericPropertiesCreator.props") && !avoidTriggeringFullClassDiscovery) {
                if (goePropsFiles != null) {
                    goePropsFiles.add(content);
                } else {
                    WekaPackageManager.processGenericPropertiesCreatorProps(content);
                }
            } else if (content.isFile() && content.getPath().endsWith("PluginManager.props")) {
                WekaPackageManager.processPluginManagerProps(content);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean loadCheck(Package toLoad, File packageRoot, PrintStream ... progress) {
        boolean load;
        try {
            load = toLoad.isCompatibleBaseSystem();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (!load) {
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println("[Weka] Skipping package " + toLoad.getName() + " because it is not compatible with Weka " + PACKAGE_MANAGER.getBaseSystemVersion().toString());
                ++n2;
            }
            return false;
        }
        if (!WekaPackageManager.checkForMissingClasses(toLoad, progress) || !WekaPackageManager.checkForMissingFiles(toLoad, packageRoot, progress)) {
            return false;
        }
        if (!WekaPackageManager.checkForUnsetEnvVar(toLoad, progress)) {
            return false;
        }
        if (m_offline) {
            return true;
        }
        try {
            List<Dependency> missing = toLoad.getMissingDependencies();
            if (missing.size() > 0) {
                PrintStream[] printStreamArray = progress;
                int n = progress.length;
                int n3 = 0;
                while (n3 < n) {
                    PrintStream p = printStreamArray[n3];
                    p.println("[Weka] " + toLoad.getName() + " can't be loaded because the following" + " packages are missing:");
                    for (Dependency d : missing) {
                        p.println(d.getTarget());
                    }
                    ++n3;
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        try {
            List<Dependency> depends = toLoad.getDependencies();
            for (Dependency d : depends) {
                if (!d.getTarget().getPackage().isInstalled() || WekaPackageManager.loadCheck(d.getTarget().getPackage(), packageRoot, progress)) continue;
                PrintStream[] printStreamArray = progress;
                int n = progress.length;
                int n4 = 0;
                while (n4 < n) {
                    PrintStream p = printStreamArray[n4];
                    p.println("[Weka] Can't load " + toLoad.getName() + " because " + d.getTarget() + " can't be loaded.");
                    ++n4;
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkForUnsetEnvVar(Package toLoad, PrintStream ... progress) {
        Object doNotLoadMessage;
        int n;
        Object doNotLoadIfUnsetVar = toLoad.getPackageMetaDataElement("DoNotLoadIfEnvVarNotSet");
        boolean result = true;
        if (doNotLoadIfUnsetVar != null && doNotLoadIfUnsetVar.toString().length() > 0) {
            String[] elements = doNotLoadIfUnsetVar.toString().split(",");
            Environment env = Environment.getSystemWide();
            String[] stringArray = elements;
            int n2 = elements.length;
            n = 0;
            while (n < n2) {
                String var = stringArray[n];
                if (env.getVariableValue(var.trim()) == null) {
                    PrintStream[] printStreamArray = progress;
                    int n3 = progress.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        PrintStream p = printStreamArray[n4];
                        p.println("[Weka] " + toLoad.getName() + " can't be loaded because " + "the environment variable " + var + " is not set.");
                        ++n4;
                    }
                    result = false;
                    break;
                }
                ++n;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement("DoNotLoadIfEnvVarNotSetMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            PrintStream[] printStreamArray = progress;
            n = progress.length;
            int n5 = 0;
            while (n5 < n) {
                PrintStream p = printStreamArray[n5];
                String dnlM = doNotLoadMessage.toString();
                try {
                    dnlM = Environment.getSystemWide().substitute(dnlM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.println("[Weka] " + dnlM);
                ++n5;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkForMissingClasses(Package toLoad, PrintStream ... progress) {
        result = true;
        doNotLoadIfClassNotInstantiable = toLoad.getPackageMetaDataElement("DoNotLoadIfClassNotPresent");
        if (doNotLoadIfClassNotInstantiable != null && doNotLoadIfClassNotInstantiable.toString().length() > 0) {
            tok = new StringTokenizer(doNotLoadIfClassNotInstantiable.toString(), ",");
            while (tok.hasMoreTokens()) {
                nextT = tok.nextToken().trim();
                try {
                    Class.forName(nextT);
                    continue;
                }
                catch (Exception ex) {
                    var10_8 = progress;
                    var9_10 = progress.length;
                    var8_12 = 0;
                    ** while (var8_12 < var9_10)
                }
lbl-1000:
                // 1 sources

                {
                    p = var10_8[var8_12];
                    p.println("[Weka] " + toLoad.getName() + " can't be loaded because " + nextT + " can't be instantiated.");
                    ++var8_12;
                    continue;
                }
lbl20:
                // 1 sources

                result = false;
                break;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement("DoNotLoadIfClassNotPresentMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            var8_13 = progress;
            var7_15 = progress.length;
            var6_7 = 0;
            while (var6_7 < var7_15) {
                p = var8_13[var6_7];
                dnlM = doNotLoadMessage.toString();
                try {
                    dnlM = Environment.getSystemWide().substitute(dnlM);
                }
                catch (Exception var10_9) {
                    // empty catch block
                }
                p.println("[Weka] " + dnlM);
                ++var6_7;
            }
        }
        return result;
    }

    public static boolean checkForMissingFiles(Package toLoad, File packageRoot, PrintStream ... progress) {
        Object doNotLoadMessage;
        int n;
        boolean result = true;
        Object doNotLoadIfFileMissing = toLoad.getPackageMetaDataElement("DoNotLoadIfFileNotPresent");
        String packageRootPath = String.valueOf(packageRoot.getPath()) + File.separator;
        if (doNotLoadIfFileMissing != null && doNotLoadIfFileMissing.toString().length() > 0) {
            StringTokenizer tok = new StringTokenizer(doNotLoadIfFileMissing.toString(), ",");
            while (tok.hasMoreTokens()) {
                String nextT = tok.nextToken().trim();
                File toCheck = new File(String.valueOf(packageRootPath) + nextT);
                if (toCheck.exists()) continue;
                PrintStream[] printStreamArray = progress;
                int n2 = progress.length;
                n = 0;
                while (n < n2) {
                    PrintStream p = printStreamArray[n];
                    p.println("[Weka] " + toLoad.getName() + " can't be loaded because " + toCheck.getPath() + " appears to be missing.");
                    ++n;
                }
                result = false;
                break;
            }
        }
        if (!result && (doNotLoadMessage = toLoad.getPackageMetaDataElement("DoNotLoadIfFileNotPresentMessage")) != null && doNotLoadMessage.toString().length() > 0) {
            String dnlM = doNotLoadMessage.toString();
            try {
                dnlM = Environment.getSystemWide().substitute(dnlM);
            }
            catch (Exception toCheck) {
                // empty catch block
            }
            PrintStream[] printStreamArray = progress;
            n = progress.length;
            int n3 = 0;
            while (n3 < n) {
                PrintStream p = printStreamArray[n3];
                p.println("[Weka] " + dnlM);
                ++n3;
            }
        }
        return result;
    }

    public static synchronized void loadPackages(boolean verbose) {
        WekaPackageManager.loadPackages(verbose, false, true);
    }

    public static synchronized void loadPackages(boolean verbose, boolean avoidTriggeringFullClassDiscovery, boolean refreshGOEProperties) {
        ArrayList<File> goePropsFiles = new ArrayList<File>();
        if (!m_loadPackages) {
            return;
        }
        if (m_packagesLoaded) {
            return;
        }
        m_packagesLoaded = true;
        m_initialPackageLoadingInProcess = true;
        if (WekaPackageManager.establishWekaHome()) {
            File[] contents = PACKAGES_DIR.listFiles();
            if (contents.length > 0) {
                WekaPackageManager.establishCacheIfNeeded(System.out);
            }
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.isDirectory()) {
                    try {
                        boolean load;
                        Package toLoad = WekaPackageManager.getInstalledPackageInfo(content.getName());
                        if (toLoad != null && (load = WekaPackageManager.loadCheck(toLoad, content, System.err))) {
                            if (verbose) {
                                System.out.println("[Weka] loading package " + content.getName());
                            }
                            WekaPackageManager.loadPackageDirectory(content, verbose, goePropsFiles, avoidTriggeringFullClassDiscovery);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.err.println("[Weka] Problem loading package " + content.getName() + " skipping...");
                    }
                }
                ++n2;
            }
        }
        m_initialPackageLoadingInProcess = false;
        if (!avoidTriggeringFullClassDiscovery) {
            for (File f : goePropsFiles) {
                WekaPackageManager.processGenericPropertiesCreatorProps(f);
            }
        }
        if (refreshGOEProperties) {
            System.err.println("Refreshing GOE props...");
            WekaPackageManager.refreshGOEProperties();
        }
    }

    public static void refreshGOEProperties() {
        ClassDiscovery.clearClassCache();
        GenericPropertiesCreator.regenerateGlobalOutputProperties();
        GenericObjectEditor.determineClasses();
        ConverterUtils.initialize();
        KnowledgeFlowApp.disposeSingleton();
        KnowledgeFlowApp.reInitialize();
    }

    public static PackageManager getUnderlyingPackageManager() {
        return PACKAGE_MANAGER;
    }

    public static int repoZipArchiveSize() {
        int size = -1;
        try {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            String numPackagesS = String.valueOf(PACKAGE_MANAGER.getPackageRepositoryURL().toString()) + "/repoSize.txt";
            URLConnection conn = null;
            URL connURL = new URL(numPackagesS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String n = bi.readLine();
            try {
                size = Integer.parseInt(n);
            }
            catch (NumberFormatException ne) {
                System.err.println("[WekaPackageManager] problem parsing the size of repository zip archive from the server.");
            }
            bi.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return size;
    }

    public static int numRepositoryPackages() {
        int numPackages = -1;
        try {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            String numPackagesS = String.valueOf(PACKAGE_MANAGER.getPackageRepositoryURL().toString()) + "/numPackages.txt";
            URLConnection conn = null;
            URL connURL = new URL(numPackagesS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String n = bi.readLine();
            try {
                numPackages = Integer.parseInt(n);
            }
            catch (NumberFormatException ne) {
                System.err.println("[WekaPackageManager] problem parsing number of packages from server.");
            }
            bi.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return numPackages;
    }

    public static Map<String, String> getPackageList(boolean local) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            WekaPackageManager.useCacheOrOnlineRepository();
            if (!local) {
                PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
            }
            String packageListS = String.valueOf(PACKAGE_MANAGER.getPackageRepositoryURL().toString()) + "/packageListWithVersion.txt";
            URLConnection conn = null;
            URL connURL = new URL(packageListS);
            conn = PACKAGE_MANAGER.setProxyAuthentication(connURL) ? connURL.openConnection(PACKAGE_MANAGER.getProxy()) : connURL.openConnection();
            conn.setConnectTimeout(30000);
            BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String l = null;
            while ((l = bi.readLine()) != null) {
                String[] parts = l.split(":");
                if (parts.length != 2) continue;
                result.put(parts[0], parts[1]);
            }
            bi.close();
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static Exception establishCacheIfNeeded(PrintStream ... progress) {
        if (m_offline) {
            return null;
        }
        if (REP_MIRROR == null) {
            WekaPackageManager.establishMirror();
        }
        Exception problem = null;
        if (INITIAL_CACHE_BUILD_NEEDED) {
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println("Caching repository meta data, please wait...");
                ++n2;
            }
            problem = WekaPackageManager.refreshCache(progress);
            INITIAL_CACHE_BUILD_NEEDED = false;
        }
        return problem;
    }

    public static Exception checkForNewPackages(PrintStream ... progress) {
        Map<String, String> repositoryPackageNameList;
        if (m_offline) {
            return null;
        }
        Exception problem = null;
        Map<String, String> localPackageNameList = WekaPackageManager.getPackageList(true);
        if (localPackageNameList == null) {
            System.err.println("Local package list is missing, trying a cache refresh to restore...");
            WekaPackageManager.refreshCache(progress);
            localPackageNameList = WekaPackageManager.getPackageList(true);
            if (localPackageNameList == null) {
                return null;
            }
        }
        if ((repositoryPackageNameList = WekaPackageManager.getPackageList(false)) == null) {
            return null;
        }
        if (repositoryPackageNameList.keySet().size() != localPackageNameList.keySet().size()) {
            if (repositoryPackageNameList.keySet().size() < localPackageNameList.keySet().size()) {
                PrintStream[] printStreamArray = progress;
                int n = progress.length;
                int n2 = 0;
                while (n2 < n) {
                    PrintStream p = printStreamArray[n2];
                    p.println("Some packages no longer exist at the repository. Refreshing cache...");
                    ++n2;
                }
            } else {
                PrintStream[] printStreamArray = progress;
                int n = progress.length;
                int n3 = 0;
                while (n3 < n) {
                    PrintStream p = printStreamArray[n3];
                    p.println("There are new packages at the repository. Refreshing cache...");
                    ++n3;
                }
            }
            problem = WekaPackageManager.refreshCache(progress);
        } else {
            boolean refresh = false;
            for (String localPackage : localPackageNameList.keySet()) {
                String localVersion = localPackageNameList.get(localPackage);
                String repoVersion = repositoryPackageNameList.get(localPackage);
                if (repoVersion == null || localVersion.equals(repoVersion)) continue;
                refresh = true;
                break;
            }
            if (refresh) {
                PrintStream[] printStreamArray = progress;
                int n = progress.length;
                int n4 = 0;
                while (n4 < n) {
                    PrintStream p = printStreamArray[n4];
                    p.println("There are newer versions of existing packages at the repository. Refreshing cache...");
                    ++n4;
                }
                problem = WekaPackageManager.refreshCache(progress);
            }
        }
        return problem;
    }

    public static Exception refreshCache(PrintStream ... progress) {
        Exception problem = null;
        if (CACHE_URL == null) {
            return null;
        }
        PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        String cacheDir = String.valueOf(WEKA_HOME.toString()) + File.separator + "repCache";
        try {
            ZipEntry ze;
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println("Refresh in progress. Please wait...");
                ++n2;
            }
            byte[] zip = PACKAGE_MANAGER.getRepositoryPackageMetaDataOnlyAsZip(progress);
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
            byte[] buff = new byte[1024];
            while ((ze = zis.getNextEntry()) != null) {
                int amountRead;
                if (ze.isDirectory()) {
                    new File(cacheDir, ze.getName()).mkdir();
                    continue;
                }
                BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(new File(cacheDir, ze.getName())));
                while ((amountRead = zis.read(buff)) != -1) {
                    bo.write(buff, 0, amountRead);
                }
                bo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CACHE_URL = null;
            try {
                DefaultPackageManager.deleteDir(new File(cacheDir), System.out);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return e;
        }
        return problem;
    }

    public static boolean installedPackageResourceExists(String packageName, String resourceName) {
        String fullResourcePath = String.valueOf(WekaPackageManager.getPackageHome().toString()) + File.separator + packageName + File.separator + resourceName;
        return new File(fullResourcePath).exists();
    }

    private static void useCacheOrOnlineRepository() {
        if (REP_MIRROR == null) {
            WekaPackageManager.establishMirror();
        }
        if (CACHE_URL != null) {
            PACKAGE_MANAGER.setPackageRepositoryURL(CACHE_URL);
        } else if (REP_URL != null) {
            PACKAGE_MANAGER.setPackageRepositoryURL(REP_URL);
        }
    }

    public static File getPackageHome() {
        return PACKAGE_MANAGER.getPackageHome();
    }

    public static Package mostRecentVersionWithRespectToConstraint(PackageConstraint toCheck) throws Exception {
        Package target = toCheck.getPackage();
        Package result = null;
        List<Object> availableVersions = PACKAGE_MANAGER.getRepositoryPackageVersions(target.getName());
        for (Object version : availableVersions) {
            Package candidate = PACKAGE_MANAGER.getRepositoryPackageInfo(target.getName(), version);
            if (!toCheck.checkConstraint(candidate)) continue;
            result = candidate;
            break;
        }
        if (result == null) {
            throw new Exception("[WekaPackageManager] unable to find a version of package " + target.getName() + " that meets constraint " + toCheck.toString());
        }
        return result;
    }

    public static boolean installPackages(List<Package> toInstall, PrintStream ... progress) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        ArrayList<Boolean> upgrades = new ArrayList<Boolean>();
        for (Package p : toInstall) {
            if (p.isInstalled()) {
                upgrades.add(new Boolean(true));
                continue;
            }
            upgrades.add(new Boolean(false));
        }
        PACKAGE_MANAGER.installPackages(toInstall, progress);
        boolean atLeastOneUpgrade = false;
        ArrayList<File> gpcFiles = new ArrayList<File>();
        int i = 0;
        for (Package p : toInstall) {
            boolean isAnUpgrade;
            if (isAnUpgrade = ((Boolean)upgrades.get(i++)).booleanValue()) {
                atLeastOneUpgrade = true;
            }
            String packageName = p.getName();
            File packageDir = new File(String.valueOf(PACKAGE_MANAGER.getPackageHome().toString()) + File.separator + packageName);
            boolean loadIt = WekaPackageManager.loadCheck(p, packageDir, progress);
            if (!(loadIt & !isAnUpgrade)) continue;
            WekaPackageManager.loadPackageDirectory(packageDir, false, gpcFiles, false);
        }
        for (File f : gpcFiles) {
            WekaPackageManager.processGenericPropertiesCreatorProps(f);
        }
        return atLeastOneUpgrade;
    }

    public static List<Object> getRepositoryPackageVersions(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageVersions(packageName);
    }

    public static URL getPackageRepositoryURL() {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getPackageRepositoryURL();
    }

    public static List<Package> getAllPackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAllPackages(new PrintStream[0]);
    }

    public static List<Package> getAvailablePackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAvailablePackages();
    }

    public static List<Package> getInstalledPackages() throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getInstalledPackages();
    }

    public static List<Dependency> getAllDependenciesForPackage(Package target, Map<String, List<Dependency>> conflicts) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getAllDependenciesForPackage(target, conflicts);
    }

    public static Package getPackageArchiveInfo(String packageArchivePath) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getPackageArchiveInfo(packageArchivePath);
    }

    public static Package getInstalledPackageInfo(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getInstalledPackageInfo(packageName);
    }

    public static Package getRepositoryPackageInfo(String packageName) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageInfo(packageName);
    }

    public static Package getRepositoryPackageInfo(String packageName, String version) throws Exception {
        WekaPackageManager.useCacheOrOnlineRepository();
        return PACKAGE_MANAGER.getRepositoryPackageInfo(packageName, version);
    }

    public static boolean installPackageFromRepository(String packageName, String version, PrintStream ... progress) throws Exception {
        File packageRoot;
        WekaPackageManager.useCacheOrOnlineRepository();
        Package toLoad = WekaPackageManager.getRepositoryPackageInfo(packageName);
        boolean isAnUpgrade = toLoad.isInstalled();
        Object specialInstallMessage = toLoad.getPackageMetaDataElement("MessageToDisplayOnInstallation");
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String siM = specialInstallMessage.toString();
            try {
                siM = Environment.getSystemWide().substitute(siM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "**** Special installation message ****\n" + siM + "\n**** Special installation message ****";
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println(message);
                ++n2;
            }
        }
        PACKAGE_MANAGER.installPackageFromRepository(packageName, version, progress);
        File packageDir = new File(String.valueOf(PACKAGE_MANAGER.getPackageHome().toString()) + File.separator + packageName);
        boolean loadIt = WekaPackageManager.checkForMissingClasses(toLoad, progress);
        if (loadIt && !isAnUpgrade && (loadIt = WekaPackageManager.checkForMissingFiles(toLoad, packageRoot = new File(PACKAGE_MANAGER.getPackageHome() + File.separator + packageName), progress))) {
            WekaPackageManager.loadPackageDirectory(packageDir, false, null, false);
        }
        return isAnUpgrade;
    }

    public static String installPackageFromArchive(String packageArchivePath, PrintStream ... progress) throws Exception {
        File packageRoot;
        WekaPackageManager.useCacheOrOnlineRepository();
        Package toInstall = PACKAGE_MANAGER.getPackageArchiveInfo(packageArchivePath);
        Object specialInstallMessage = toInstall.getPackageMetaDataElement("MessageToDisplayOnInstallation");
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String siM = specialInstallMessage.toString();
            try {
                siM = Environment.getSystemWide().substitute(siM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "**** Special installation message ****\n" + siM + "\n**** Special installation message ****";
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println(message);
                ++n2;
            }
        }
        PACKAGE_MANAGER.installPackageFromArchive(packageArchivePath, progress);
        boolean loadIt = WekaPackageManager.checkForMissingClasses(toInstall, progress);
        if (loadIt && (loadIt = WekaPackageManager.checkForMissingFiles(toInstall, packageRoot = new File(PACKAGE_MANAGER.getPackageHome() + File.separator + toInstall.getName()), progress))) {
            WekaPackageManager.loadPackageDirectory(packageRoot, false, null, false);
        }
        return toInstall.getName();
    }

    public static String installPackageFromURL(URL packageURL, PrintStream ... progress) throws Exception {
        File packageRoot;
        boolean loadIt;
        WekaPackageManager.useCacheOrOnlineRepository();
        String packageName = PACKAGE_MANAGER.installPackageFromURL(packageURL, progress);
        Package installed = PACKAGE_MANAGER.getInstalledPackageInfo(packageName);
        Object specialInstallMessage = installed.getPackageMetaDataElement("MessageToDisplayOnInstallation");
        if (specialInstallMessage != null && specialInstallMessage.toString().length() > 0) {
            String message = "**** Special installation message ****\n" + specialInstallMessage.toString() + "\n**** Special installation message ****";
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println(message);
                ++n2;
            }
        }
        if ((loadIt = WekaPackageManager.checkForMissingClasses(installed, progress)) && (loadIt = WekaPackageManager.checkForMissingFiles(installed, packageRoot = new File(PACKAGE_MANAGER.getPackageHome() + File.separator + installed.getName()), progress))) {
            WekaPackageManager.loadPackageDirectory(packageRoot, false, null, false);
        }
        return packageName;
    }

    public static void uninstallPackage(String packageName, boolean updateKnowledgeFlow, PrintStream ... progress) throws Exception {
        File packageToDel;
        if (updateKnowledgeFlow && (packageToDel = new File(String.valueOf(PACKAGE_MANAGER.getPackageHome().toString()) + File.separator + packageName)).exists() && packageToDel.isDirectory()) {
            File[] contents;
            File[] fileArray = contents = packageToDel.listFiles();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.isFile() && content.getPath().endsWith("Beans.props")) {
                    KnowledgeFlowApp.removeFromPluginBeanProps(content);
                    KnowledgeFlowApp.disposeSingleton();
                    break;
                }
                ++n2;
            }
        }
        PACKAGE_MANAGER.uninstallPackage(packageName, progress);
    }

    private static void printPackageInfo(Map<?, ?> packageProps) {
        Set<?> keys = packageProps.keySet();
        for (Object key : keys) {
            Object value = packageProps.get(key);
            System.out.println(String.valueOf(Utils.padLeft(key.toString(), 11)) + ":\t" + value.toString());
        }
    }

    protected static void printPackageArchiveInfo(String packagePath) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getPackageArchiveInfo(packagePath).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    protected static void printInstalledPackageInfo(String packageName) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getInstalledPackageInfo(packageName).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    protected static void printRepositoryPackageInfo(String packageName, String version) throws Exception {
        Map<?, ?> packageProps = WekaPackageManager.getRepositoryPackageInfo(packageName, version).getPackageMetaData();
        WekaPackageManager.printPackageInfo(packageProps);
    }

    private static String queryUser() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String result = null;
        try {
            result = br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void removeInstalledPackage(String packageName, boolean force, PrintStream ... progress) throws Exception {
        ArrayList<Package> compromised = new ArrayList<Package>();
        List<Package> installedPackages = null;
        if (!force) {
            installedPackages = WekaPackageManager.getInstalledPackages();
            block0: for (Package p : installedPackages) {
                List<Dependency> tempDeps = p.getDependencies();
                for (Dependency d : tempDeps) {
                    if (!d.getTarget().getPackage().getName().equals(packageName)) continue;
                    compromised.add(p);
                    continue block0;
                }
            }
            if (compromised.size() > 0) {
                System.out.println("The following installed packages depend on " + packageName + " :\n");
                for (Package p : compromised) {
                    System.out.println("\t" + p.getName());
                }
                System.out.println("\nDo you wish to proceed [y/n]?");
                String response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
            }
        }
        if (force) {
            System.out.println("Forced uninstall.");
        }
        compromised = null;
        installedPackages = null;
        WekaPackageManager.uninstallPackage(packageName, false, progress);
    }

    private static void installPackageFromRepository(String packageName, String version, boolean force) throws Exception {
        Package toInstall = null;
        try {
            toInstall = WekaPackageManager.getRepositoryPackageInfo(packageName, version);
        }
        catch (Exception ex) {
            System.err.println("[WekaPackageManager] Package " + packageName + " at version " + version + " doesn't seem to exist!");
            return;
        }
        if (!force) {
            String response;
            boolean ok = toInstall.isCompatibleBaseSystem();
            if (!ok) {
                List<Dependency> baseSysDep = toInstall.getBaseSystemDependency();
                StringBuffer depList = new StringBuffer();
                for (Dependency bd : baseSysDep) {
                    depList.append(String.valueOf(bd.getTarget().toString()) + " ");
                }
                System.err.println("Can't install package " + packageName + " because it requires " + depList.toString());
                return;
            }
            if (toInstall.isInstalled()) {
                String response2;
                Package installedVersion = WekaPackageManager.getInstalledPackageInfo(packageName);
                if (!toInstall.equals(installedVersion)) {
                    System.out.println("Package " + packageName + "[" + installedVersion + "] is already installed. Replace with " + toInstall + " [y/n]?");
                    response2 = WekaPackageManager.queryUser();
                    if (response2 != null && (response2.equalsIgnoreCase("n") || response2.equalsIgnoreCase("no"))) {
                        return;
                    }
                } else {
                    System.out.println("Package " + packageName + "[" + installedVersion + "] is already installed. Install again [y/n]?");
                    response2 = WekaPackageManager.queryUser();
                    if (response2 != null && (response2.equalsIgnoreCase("n") || response2.equalsIgnoreCase("no"))) {
                        return;
                    }
                }
            }
            HashMap<String, List<Dependency>> conflicts = new HashMap<String, List<Dependency>>();
            List<Dependency> dependencies = WekaPackageManager.getAllDependenciesForPackage(toInstall, conflicts);
            if (conflicts.size() > 0) {
                System.err.println("Package " + packageName + " requires the following packages:\n");
                for (Dependency d : dependencies) {
                    System.err.println("\t" + d);
                }
                System.err.println("\nThere are conflicting dependencies:\n");
                Set pNames = conflicts.keySet();
                for (String pName : pNames) {
                    System.err.println("Conflicts for " + pName);
                    List confsForPackage = (List)conflicts.get(pName);
                    for (Dependency problem : confsForPackage) {
                        System.err.println("\t" + problem);
                    }
                }
                System.err.println("Unable to continue with installation.");
                return;
            }
            ArrayList<PackageConstraint> needsUpgrade = new ArrayList<PackageConstraint>();
            ArrayList<Package> finalListToInstall = new ArrayList<Package>();
            for (Dependency toCheck : dependencies) {
                if (toCheck.getTarget().getPackage().isInstalled()) {
                    String toCheckName = toCheck.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
                    Package installedVersion = PACKAGE_MANAGER.getInstalledPackageInfo(toCheckName);
                    if (toCheck.getTarget().checkConstraint(installedVersion)) continue;
                    needsUpgrade.add(toCheck.getTarget());
                    Package mostRecent = toCheck.getTarget().getPackage();
                    if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                        mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                    }
                    finalListToInstall.add(mostRecent);
                    continue;
                }
                Package mostRecent = toCheck.getTarget().getPackage();
                if (toCheck.getTarget() instanceof VersionPackageConstraint) {
                    mostRecent = WekaPackageManager.mostRecentVersionWithRespectToConstraint(toCheck.getTarget());
                }
                finalListToInstall.add(mostRecent);
            }
            if (needsUpgrade.size() > 0) {
                System.out.println("The following packages will be upgraded in order to install " + packageName);
                for (PackageConstraint tempC : needsUpgrade) {
                    System.out.println("\t" + tempC);
                }
                System.out.print("\nOK to continue [y/n]? > ");
                response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
                boolean conflictsAfterUpgrade = false;
                List<Package> installed = WekaPackageManager.getInstalledPackages();
                ArrayList<Package> toUpgrade = new ArrayList<Package>();
                Iterator upI = needsUpgrade.iterator();
                while (upI.hasNext()) {
                    toUpgrade.add(((PackageConstraint)upI.next()).getPackage());
                }
                toUpgrade.add(toInstall);
                int i = 0;
                while (i < installed.size()) {
                    List<Dependency> problem;
                    Package tempP = installed.get(i);
                    String tempPName = tempP.getName();
                    boolean checkIt = true;
                    int j = 0;
                    while (j < needsUpgrade.size()) {
                        if (tempPName.equals(((PackageConstraint)needsUpgrade.get(j)).getPackage().getName())) {
                            checkIt = false;
                            break;
                        }
                        ++j;
                    }
                    if (checkIt && (problem = tempP.getIncompatibleDependencies(toUpgrade)).size() > 0) {
                        conflictsAfterUpgrade = true;
                        System.err.println("Package " + tempP.getName() + " will have a compatibility" + "problem with the following packages after upgrading them:");
                        Iterator<Dependency> dI = problem.iterator();
                        while (dI.hasNext()) {
                            System.err.println("\t" + dI.next().getTarget().getPackage());
                        }
                    }
                    ++i;
                }
                if (conflictsAfterUpgrade) {
                    System.err.println("Unable to continue with installation.");
                    return;
                }
            }
            if (finalListToInstall.size() > 0) {
                System.out.println("To install " + packageName + " the following packages will" + " be installed/upgraded:\n\n");
                Iterator i = finalListToInstall.iterator();
                while (i.hasNext()) {
                    System.out.println("\t" + i.next());
                }
                System.out.print("\nOK to proceed [y/n]? > ");
                response = WekaPackageManager.queryUser();
                if (response != null && (response.equalsIgnoreCase("n") || response.equalsIgnoreCase("no"))) {
                    return;
                }
            }
            WekaPackageManager.installPackages(finalListToInstall, System.out);
            WekaPackageManager.installPackageFromRepository(packageName, version, System.out);
        } else {
            WekaPackageManager.installPackageFromRepository(packageName, version, System.out);
        }
    }

    private static void listPackages(String arg) throws Exception {
        if (m_offline && (arg.equalsIgnoreCase("all") || arg.equalsIgnoreCase("available"))) {
            System.out.println("Running offline - unable to display available or all package information");
            return;
        }
        List<Package> packageList = null;
        WekaPackageManager.useCacheOrOnlineRepository();
        if (arg.equalsIgnoreCase("all")) {
            packageList = PACKAGE_MANAGER.getAllPackages(new PrintStream[0]);
        } else if (arg.equals("installed")) {
            packageList = PACKAGE_MANAGER.getInstalledPackages();
        } else if (arg.equals("available")) {
            packageList = PACKAGE_MANAGER.getAvailablePackages();
        } else {
            System.err.println("[WekaPackageManager] Unknown argument " + arg);
            WekaPackageManager.printUsage();
            return;
        }
        StringBuffer result = new StringBuffer();
        result.append("Installed\tRepository\tPackage\n");
        result.append("=========\t==========\t=======\n");
        for (Package p : packageList) {
            String installedV = "-----    ";
            String repositoryV = "-----     ";
            if (p.isInstalled()) {
                Package installedP = WekaPackageManager.getInstalledPackageInfo(p.getName());
                installedV = String.valueOf(installedP.getPackageMetaDataElement("Version").toString()) + "    ";
                try {
                    if (!m_offline) {
                        Package repP = WekaPackageManager.getRepositoryPackageInfo(p.getName());
                        repositoryV = String.valueOf(repP.getPackageMetaDataElement("Version").toString()) + "     ";
                    }
                }
                catch (Exception exception) {}
            } else {
                repositoryV = String.valueOf(p.getPackageMetaDataElement("Version").toString()) + "     ";
            }
            String title = p.getPackageMetaDataElement("Title").toString();
            result.append(String.valueOf(installedV) + "\t" + repositoryV + "\t" + p.getName() + ": " + title + "\n");
        }
        System.out.println(result.toString());
    }

    private static void printUsage() {
        System.out.println("Usage: weka.core.WekaPackageManager [-offline] [option]");
        System.out.println("Options:\n\t-list-packages <all | installed | available>\n\t-package-info <repository | installed | archive> <packageName | packageZip>\n\t-install-package <packageName | packageZip | URL> [version]\n\t-uninstall-package packageName\n\t-refresh-cache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        try {
            block28: {
                block30: {
                    block29: {
                        int i = 0;
                        while (true) {
                            if (i >= args.length) {
                                WekaPackageManager.establishCacheIfNeeded(System.out);
                                WekaPackageManager.checkForNewPackages(System.out);
                                if (args.length != 0 && !args[0].equalsIgnoreCase("-h") && !args[0].equalsIgnoreCase("-help")) break;
                                WekaPackageManager.printUsage();
                                return;
                            }
                            if (args[i].equals("-offline")) {
                                m_offline = true;
                                String[] temp = new String[args.length - 1];
                                if (i > 0) {
                                    System.arraycopy(args, 0, temp, 0, i);
                                }
                                System.arraycopy(args, i + 1, temp, i, args.length - (i + 1));
                                args = temp;
                            }
                            ++i;
                        }
                        if (!args[0].equals("-package-info")) break block29;
                        if (args.length < 3) {
                            WekaPackageManager.printUsage();
                            return;
                        }
                        if (args[1].equals("archive")) {
                            WekaPackageManager.printPackageArchiveInfo(args[2]);
                            break block28;
                        } else if (args[1].equals("installed")) {
                            WekaPackageManager.printInstalledPackageInfo(args[2]);
                            break block28;
                        } else {
                            if (!args[1].equals("repository")) {
                                System.err.println("[WekaPackageManager] Unknown argument " + args[2]);
                                WekaPackageManager.printUsage();
                                return;
                            }
                            String version = "Latest";
                            if (args.length == 4) {
                                version = args[3];
                            }
                            try {
                                WekaPackageManager.printRepositoryPackageInfo(args[2], version);
                            }
                            catch (Exception ex) {
                                System.out.println("[WekaPackageManager] Nothing known about package " + args[2] + " at the repository!");
                            }
                        }
                        break block28;
                    }
                    if (!args[0].equals("-install-package")) break block30;
                    String targetLowerCase = args[1].toLowerCase();
                    if (targetLowerCase.startsWith("http://") || targetLowerCase.startsWith("https://")) {
                        URL packageURL = new URL(args[1]);
                        WekaPackageManager.installPackageFromURL(packageURL, System.out);
                        break block28;
                    } else if (targetLowerCase.endsWith(".zip")) {
                        WekaPackageManager.installPackageFromArchive(args[1], System.out);
                        break block28;
                    } else {
                        String version = "Latest";
                        if (args.length == 3) {
                            version = args[2];
                        }
                        WekaPackageManager.installPackageFromRepository(args[1], version, false);
                    }
                    break block28;
                }
                if (args[0].equals("-uninstall-package")) {
                    if (args.length < 2) {
                        WekaPackageManager.printUsage();
                        return;
                    }
                    boolean force = false;
                    if (args.length == 3 && args[2].equals("-force")) {
                        force = true;
                    }
                    WekaPackageManager.removeInstalledPackage(args[1], force, System.out);
                    return;
                }
                if (args[0].equals("-list-packages")) {
                    if (args.length < 2) {
                        WekaPackageManager.printUsage();
                        return;
                    }
                    WekaPackageManager.listPackages(args[1]);
                } else if (args[0].equals("-refresh-cache")) {
                    WekaPackageManager.refreshCache(System.out);
                } else {
                    System.err.println("Unknown option: " + args[0]);
                    WekaPackageManager.printUsage();
                }
            }
            System.exit(0);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

