/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DatabaseConnectionDialog
extends JDialog {
    private static final long serialVersionUID = -1081946748666245054L;
    protected JTextField m_DbaseURLText;
    protected JLabel m_DbaseURLLab;
    protected JTextField m_UserNameText;
    protected JLabel m_UserNameLab;
    protected JPasswordField m_PasswordText;
    protected JLabel m_PasswordLab;
    protected JCheckBox m_DebugCheckBox;
    protected JLabel m_DebugLab;
    protected int m_returnValue;

    public DatabaseConnectionDialog(Frame parentFrame) {
        this(parentFrame, "", "");
    }

    public DatabaseConnectionDialog(Frame parentFrame, String url, String uname) {
        this(parentFrame, url, uname, true);
    }

    public DatabaseConnectionDialog(Frame parentFrame, String url, String uname, boolean debug) {
        super(parentFrame, "Database Connection Parameters", true);
        this.DbConnectionDialog(url, uname, debug);
    }

    public String getURL() {
        return this.m_DbaseURLText.getText();
    }

    public String getUsername() {
        return this.m_UserNameText.getText();
    }

    public String getPassword() {
        return new String(this.m_PasswordText.getPassword());
    }

    public boolean getDebug() {
        return this.m_DebugCheckBox.isSelected();
    }

    public int getReturnValue() {
        return this.m_returnValue;
    }

    public void DbConnectionDialog(String url, String uname) {
        this.DbConnectionDialog(url, uname, true);
    }

    public void DbConnectionDialog(String url, String uname, boolean debug) {
        JPanel DbP = new JPanel();
        if (debug) {
            DbP.setLayout(new GridLayout(5, 1));
        } else {
            DbP.setLayout(new GridLayout(4, 1));
        }
        this.m_DbaseURLText = new JTextField(url, 50);
        this.m_DbaseURLLab = new JLabel(" Database URL", 2);
        this.m_DbaseURLLab.setFont(new Font("Monospaced", 0, 12));
        this.m_DbaseURLLab.setDisplayedMnemonic('D');
        this.m_DbaseURLLab.setLabelFor(this.m_DbaseURLText);
        this.m_UserNameText = new JTextField(uname, 25);
        this.m_UserNameLab = new JLabel(" Username    ", 2);
        this.m_UserNameLab.setFont(new Font("Monospaced", 0, 12));
        this.m_UserNameLab.setDisplayedMnemonic('U');
        this.m_UserNameLab.setLabelFor(this.m_UserNameText);
        this.m_PasswordText = new JPasswordField(25);
        this.m_PasswordLab = new JLabel(" Password    ", 2);
        this.m_PasswordLab.setFont(new Font("Monospaced", 0, 12));
        this.m_PasswordLab.setDisplayedMnemonic('P');
        this.m_PasswordLab.setLabelFor(this.m_PasswordText);
        this.m_DebugCheckBox = new JCheckBox();
        this.m_DebugLab = new JLabel(" Debug       ", 2);
        this.m_DebugLab.setFont(new Font("Monospaced", 0, 12));
        this.m_DebugLab.setDisplayedMnemonic('P');
        this.m_DebugLab.setLabelFor(this.m_DebugCheckBox);
        JPanel urlP = new JPanel();
        urlP.setLayout(new FlowLayout(0));
        urlP.add(this.m_DbaseURLLab);
        urlP.add(this.m_DbaseURLText);
        DbP.add(urlP);
        JPanel usernameP = new JPanel();
        usernameP.setLayout(new FlowLayout(0));
        usernameP.add(this.m_UserNameLab);
        usernameP.add(this.m_UserNameText);
        DbP.add(usernameP);
        JPanel passwordP = new JPanel();
        passwordP.setLayout(new FlowLayout(0));
        passwordP.add(this.m_PasswordLab);
        passwordP.add(this.m_PasswordText);
        DbP.add(passwordP);
        if (debug) {
            JPanel debugP = new JPanel();
            debugP.setLayout(new FlowLayout(0));
            debugP.add(this.m_DebugLab);
            debugP.add(this.m_DebugCheckBox);
            DbP.add(debugP);
        }
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.setMnemonic('O');
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseConnectionDialog.this.m_returnValue = 0;
                DatabaseConnectionDialog.this.dispose();
            }
        });
        cancel.setMnemonic('C');
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseConnectionDialog.this.m_returnValue = -1;
                DatabaseConnectionDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.err.println("Cancelled!!");
                DatabaseConnectionDialog.this.m_returnValue = -1;
            }
        });
        DbP.add(buttonsP);
        this.getContentPane().add((Component)DbP, "Center");
        this.pack();
        this.getRootPane().setDefaultButton(ok);
        this.setResizable(false);
    }

    public static void main(String[] args) {
        DatabaseConnectionDialog dbd = new DatabaseConnectionDialog(null, "URL", "username");
        dbd.setVisible(true);
        System.out.println(String.valueOf(dbd.getReturnValue()) + ":" + dbd.getUsername() + ":" + dbd.getPassword() + ":" + dbd.getURL());
    }
}

