/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator.impl;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;
import org.uma.jmetal.util.solutionattribute.impl.NumberOfViolatedConstraints;
import org.uma.jmetal.util.solutionattribute.impl.OverallConstraintViolation;

public class ViolationThresholdComparator<S extends Solution<?>>
implements ConstraintViolationComparator<S> {
    private double threshold = 0.0;
    private OverallConstraintViolation<S> overallConstraintViolation = new OverallConstraintViolation();
    private NumberOfViolatedConstraints<S> numberOfViolatedConstraints = new NumberOfViolatedConstraints();

    @Override
    public int compare(S solution1, S solution2) {
        if (this.overallConstraintViolation.getAttribute(solution1) == null) {
            return 0;
        }
        double overall1 = (double)((Integer)this.numberOfViolatedConstraints.getAttribute(solution1)).intValue() * (Double)this.overallConstraintViolation.getAttribute(solution1);
        double overall2 = (double)((Integer)this.numberOfViolatedConstraints.getAttribute(solution2)).intValue() * (Double)this.overallConstraintViolation.getAttribute(solution2);
        if (overall1 < 0.0 && overall2 < 0.0) {
            if (overall1 > overall2) {
                return -1;
            }
            if (overall2 > overall1) {
                return 1;
            }
            return 0;
        }
        if (overall1 == 0.0 && overall2 < 0.0) {
            return -1;
        }
        if (overall1 < 0.0 && overall2 == 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean needToCompare(S solution1, S solution2) {
        double overall1 = Math.abs((double)((Integer)this.numberOfViolatedConstraints.getAttribute(solution1)).intValue() * (Double)this.overallConstraintViolation.getAttribute(solution1));
        double overall2 = Math.abs((double)((Integer)this.numberOfViolatedConstraints.getAttribute(solution2)).intValue() * (Double)this.overallConstraintViolation.getAttribute(solution2));
        boolean needToCompare = overall1 > this.threshold || overall2 > this.threshold;
        return needToCompare;
    }

    public double feasibilityRatio(List<S> solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            if (!((Double)this.overallConstraintViolation.getAttribute((Solution)solutionSet.get(i)) < 0.0)) continue;
            aux += 1.0;
        }
        return aux / (double)solutionSet.size();
    }

    public double meanOverallViolation(List<S> solutionSet) {
        double aux = 0.0;
        for (int i = 0; i < solutionSet.size(); ++i) {
            aux += Math.abs((double)((Integer)this.numberOfViolatedConstraints.getAttribute((Solution)solutionSet.get(i))).intValue() * (Double)this.overallConstraintViolation.getAttribute((Solution)solutionSet.get(i)));
        }
        return aux / (double)solutionSet.size();
    }

    public void updateThreshold(List<S> set) {
        this.threshold = this.feasibilityRatio(set) * this.meanOverallViolation(set);
    }
}

