/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractIndexBasedDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborPreprocessor;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

public class SharedNearestNeighborJaccardDistanceFunction<O>
extends AbstractIndexBasedDistanceFunction<O, SharedNearestNeighborIndex<O>> {
    public SharedNearestNeighborJaccardDistanceFunction(SharedNearestNeighborIndex.Factory<O, SharedNearestNeighborIndex<O>> factory) {
        super(factory);
    }

    @Override
    public <T extends O> Instance<T> instantiate(Relation<T> relation) {
        SharedNearestNeighborIndex sharedNearestNeighborIndex = (SharedNearestNeighborIndex)this.indexFactory.instantiate(relation);
        return new Instance<T>(relation, sharedNearestNeighborIndex, this);
    }

    public static class Parameterizer<O>
    extends AbstractIndexBasedDistanceFunction.Parameterizer<SharedNearestNeighborIndex.Factory<O, SharedNearestNeighborIndex<O>>> {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configIndexFactory(parameterization, SharedNearestNeighborIndex.Factory.class, SharedNearestNeighborPreprocessor.Factory.class);
        }

        @Override
        protected SharedNearestNeighborJaccardDistanceFunction<O> makeInstance() {
            return new SharedNearestNeighborJaccardDistanceFunction((SharedNearestNeighborIndex.Factory)this.factory);
        }
    }

    public static class Instance<T>
    extends AbstractIndexBasedDistanceFunction.Instance<T, SharedNearestNeighborIndex<T>, SharedNearestNeighborJaccardDistanceFunction<T>> {
        public Instance(Relation<T> relation, SharedNearestNeighborIndex<T> sharedNearestNeighborIndex, SharedNearestNeighborJaccardDistanceFunction<T> sharedNearestNeighborJaccardDistanceFunction) {
            super(relation, sharedNearestNeighborIndex, sharedNearestNeighborJaccardDistanceFunction);
        }

        protected static double jaccardCoefficient(DBIDs dBIDs, DBIDs dBIDs2) {
            int n = 0;
            int n2 = 0;
            DBIDIter dBIDIter = dBIDs.iter();
            DBIDIter dBIDIter2 = dBIDs2.iter();
            while (dBIDIter.valid() && dBIDIter2.valid()) {
                int n3 = DBIDUtil.compare(dBIDIter, dBIDIter2);
                ++n2;
                if (n3 == 0) {
                    ++n;
                    dBIDIter.advance();
                    dBIDIter2.advance();
                    continue;
                }
                if (n3 < 0) {
                    dBIDIter.advance();
                    continue;
                }
                dBIDIter2.advance();
            }
            while (dBIDIter.valid()) {
                ++n2;
                dBIDIter.advance();
            }
            while (dBIDIter2.valid()) {
                ++n2;
                dBIDIter2.advance();
            }
            return (double)n / (double)n2;
        }

        @Override
        public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
            ArrayDBIDs arrayDBIDs = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(dBIDRef);
            ArrayDBIDs arrayDBIDs2 = ((SharedNearestNeighborIndex)this.index).getNearestNeighborSet(dBIDRef2);
            return 1.0 - Instance.jaccardCoefficient(arrayDBIDs, arrayDBIDs2);
        }
    }
}

