/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.extractor;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.extraction.ExtractFlatClusteringFromHierarchy;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.DendrogramModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;

public class ExtractFlatClusteringFromHierarchyEvaluator
implements Evaluator {
    private ExtractFlatClusteringFromHierarchy inner;

    public ExtractFlatClusteringFromHierarchyEvaluator(ExtractFlatClusteringFromHierarchy extractFlatClusteringFromHierarchy) {
        this.inner = extractFlatClusteringFromHierarchy;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<PointerHierarchyRepresentationResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, PointerHierarchyRepresentationResult.class);
        for (PointerHierarchyRepresentationResult pointerHierarchyRepresentationResult : arrayList) {
            DBIDs dBIDs = pointerHierarchyRepresentationResult.getDBIDs();
            DBIDDataStore dBIDDataStore = pointerHierarchyRepresentationResult.getParentStore();
            DoubleDataStore doubleDataStore = pointerHierarchyRepresentationResult.getParentDistanceStore();
            Clustering<DendrogramModel> clustering = this.inner.extractClusters(dBIDs, dBIDDataStore, doubleDataStore);
            pointerHierarchyRepresentationResult.addChildResult(clustering);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        ExtractFlatClusteringFromHierarchy inner;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, DummyHierarchicalClusteringAlgorithm.class);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            chainedParameterization.errorsTo(parameterization);
            this.inner = chainedParameterization.tryInstantiate(ExtractFlatClusteringFromHierarchy.class);
        }

        @Override
        protected ExtractFlatClusteringFromHierarchyEvaluator makeInstance() {
            return new ExtractFlatClusteringFromHierarchyEvaluator(this.inner);
        }
    }

    protected static class DummyHierarchicalClusteringAlgorithm
    implements HierarchicalClusteringAlgorithm {
        @Override
        public TypeInformation[] getInputTypeRestriction() {
            return TypeUtil.array(new TypeInformation[0]);
        }

        @Override
        public PointerHierarchyRepresentationResult run(Database database) {
            throw new AbortException("This must not be called");
        }
    }
}

