/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.AbstractProjectedHashFunctionFamily;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.GaussianRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="M. Datar and N. Immorlica and P. Indyk and V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th annual symposium on Computational geometry", url="http://dx.doi.org/10.1145/997817.997857")
public class EuclideanHashFunctionFamily
extends AbstractProjectedHashFunctionFamily {
    public EuclideanHashFunctionFamily(RandomFactory randomFactory, double d, int n) {
        super(randomFactory, new GaussianRandomProjectionFamily(randomFactory), d, n);
    }

    @Override
    public boolean isCompatible(DistanceFunction<?> distanceFunction) {
        return EuclideanDistanceFunction.class.isInstance(distanceFunction);
    }

    public static class Parameterizer
    extends AbstractProjectedHashFunctionFamily.Parameterizer {
        @Override
        protected EuclideanHashFunctionFamily makeInstance() {
            return new EuclideanHashFunctionFamily(this.random, this.width, this.k);
        }
    }
}

