/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.RandomProjection;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.projected.ProjectedIndex;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.AchlioptasRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

@Reference(title="Finding local anomalies in very high dimensional space", authors="T. de Vries, S. Chawla, M. E. Houle", booktitle="Proc. IEEE 10th International Conference on Data Mining (ICDM)", url="http://dx.doi.org/10.1109/ICDM.2010.151")
public class PINN<O extends NumberVector>
extends ProjectedIndex.Factory<O, O> {
    public PINN(IndexFactory<O, ?> indexFactory, int n, double d, double d2, RandomFactory randomFactory) {
        super(new RandomProjection(n, new AchlioptasRandomProjectionFamily(d, randomFactory)), indexFactory, true, false, d2);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID T_ID = new OptionID("pinn.t", "Target dimensionality.");
        public static final OptionID S_ID = new OptionID("pinn.s", "Sparsity of the random projection.");
        public static final OptionID H_ID = new OptionID("pinn.hmult", "Multiplicator for neighborhood size.");
        public static final OptionID RANDOM_ID = new OptionID("pinn.seed", "Random generator seed.");
        IndexFactory<O, ?> inner;
        int t;
        double s;
        double h;
        RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(ProjectedIndex.Factory.Parameterizer.INDEX_ID, IndexFactory.class);
            if (parameterization.grab(objectParameter)) {
                this.inner = (IndexFactory)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(T_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.t = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(S_ID, 1.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.s = doubleParameter.doubleValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(H_ID, 3.0);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.h = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected PINN<O> makeInstance() {
            return new PINN<O>(this.inner, this.t, this.s, this.h, this.random);
        }
    }
}

