/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Antonin Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proceedings of the 1984 ACM SIGMOD international conference on Management of data", url="http://dx.doi.org/10.1145/971697.602266")
public class RTreeLinearSplit
implements SplitStrategy {
    public static final RTreeLinearSplit STATIC = new RTreeLinearSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A a, ArrayAdapter<E, A> arrayAdapter, int n) {
        double d;
        int n2 = arrayAdapter.size(a);
        long[] lArray = BitsUtil.zero(n2);
        long[] lArray2 = BitsUtil.zero(n2);
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = ((SpatialComparable)arrayAdapter.get(a, 0)).getDimensionality();
        double d4 = Double.NEGATIVE_INFINITY;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < n3; ++i) {
            double d5;
            double d6;
            double d7;
            double d8 = Double.POSITIVE_INFINITY;
            d = Double.NEGATIVE_INFINITY;
            double d9 = Double.NEGATIVE_INFINITY;
            double d10 = Double.POSITIVE_INFINITY;
            double d11 = Double.POSITIVE_INFINITY;
            double d12 = Double.NEGATIVE_INFINITY;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            for (int j = 0; j < n2; ++j) {
                SpatialComparable spatialComparable = (SpatialComparable)arrayAdapter.get(a, j);
                d7 = spatialComparable.getMin(i);
                d6 = spatialComparable.getMax(i);
                d8 = Math.min(d8, d7);
                d12 = Math.max(d12, d6);
                if (d7 >= d) {
                    d9 = d;
                    d = d7;
                    n7 = n6;
                    n6 = j;
                } else if (d7 > d9) {
                    d9 = d7;
                    n7 = j;
                }
                if (d6 <= d10) {
                    d11 = d10;
                    d10 = d6;
                    n9 = n8;
                    n8 = j;
                    continue;
                }
                if (!(d6 < d11)) continue;
                d11 = d6;
                n9 = j;
            }
            if (n6 != n8) {
                d5 = d10 - d / (d12 - d8);
            } else {
                d7 = d10 - d9 / (d12 - d8);
                d6 = d11 - d / (d12 - d8);
                if (d7 > d6) {
                    n6 = n7;
                    d5 = d7;
                } else {
                    n8 = n9;
                    d5 = d6;
                }
            }
            assert (n8 != -1 && n6 != -1 && n8 != n6);
            if (!(d5 > d4)) continue;
            d4 = d5;
            n4 = n6;
            n5 = n8;
        }
        BitsUtil.setI(lArray2, n4);
        BitsUtil.setI(lArray2, n5);
        BitsUtil.setI(lArray, n5);
        SpatialComparable spatialComparable = (SpatialComparable)arrayAdapter.get(a, n4);
        SpatialComparable spatialComparable2 = (SpatialComparable)arrayAdapter.get(a, n5);
        d2 = SpatialUtil.volume(spatialComparable);
        d3 = SpatialUtil.volume(spatialComparable2);
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox(spatialComparable);
        ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = new ModifiableHyperBoundingBox(spatialComparable2);
        n3 = 1;
        int n10 = 1;
        int n11 = n2 - 2;
        n4 = BitsUtil.nextClearBit(lArray2, 0);
        while (n11 > 0 && n4 < n2 && n3 + n11 > n) {
            if (n10 + n11 <= n) {
                while (n4 < n2) {
                    BitsUtil.setI(lArray, n4);
                    n4 = BitsUtil.nextClearBit(lArray2, n4 + 1);
                }
                break;
            }
            n5 = 0;
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n4);
            double d13 = SpatialUtil.volumeUnion(modifiableHyperBoundingBox, spatialComparable) - d2;
            d = SpatialUtil.volumeUnion(modifiableHyperBoundingBox2, spatialComparable) - d3;
            int n12 = n5 = d < d13 ? 1 : 0;
            if (d13 == d) {
                n5 = d2 != d3 ? (d3 < d2 ? 1 : 0) : (n10 < n3 ? 1 : 0);
            }
            BitsUtil.setI(lArray2, n4);
            --n11;
            if (n5 == 0) {
                ++n3;
                modifiableHyperBoundingBox.extend(spatialComparable);
                d2 = SpatialUtil.volume(modifiableHyperBoundingBox);
            } else {
                ++n10;
                BitsUtil.setI(lArray, n4);
                modifiableHyperBoundingBox2.extend(spatialComparable);
                d3 = SpatialUtil.volume(modifiableHyperBoundingBox2);
            }
            n4 = BitsUtil.nextClearBit(lArray2, n4 + 1);
        }
        return lArray;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RTreeLinearSplit makeInstance() {
            return STATIC;
        }
    }
}

