/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

@Reference(authors="B. P. Welford", title="Note on a method for calculating corrected sums of squares and products", booktitle="Technometrics 4(3)")
public class MeanVariance
extends Mean {
    protected double m2 = 0.0;

    public MeanVariance() {
    }

    public MeanVariance(MeanVariance meanVariance) {
        this.m1 = meanVariance.m1;
        this.m2 = meanVariance.m2;
        this.n = meanVariance.n;
    }

    @Override
    public void put(double d) {
        this.n += 1.0;
        double d2 = d - this.m1;
        this.m1 += d2 / this.n;
        this.m2 += d2 * (d - this.m1);
    }

    @Override
    @Reference(authors="D.H.D. West", title="Updating Mean and Variance Estimates: An Improved Method", booktitle="Communications of the ACM, Volume 22 Issue 9")
    public void put(double d, double d2) {
        double d3 = d2 + this.n;
        double d4 = d - this.m1;
        double d5 = d4 * d2 / d3;
        this.m1 += d5;
        this.m2 += this.n * d4 * d5;
        this.n = d3;
    }

    @Override
    public void put(Mean mean) {
        double d;
        if (mean instanceof MeanVariance) {
            d = mean.n + this.n;
            double d2 = mean.m1 - this.m1;
            double d3 = d2 * mean.n / d;
            this.m1 = (this.n * this.m1 + mean.n * mean.m1) / d;
            this.m2 += ((MeanVariance)mean).m2 + d2 * this.n * d3;
        } else {
            throw new AbortException("I cannot combine Mean and MeanVariance to a MeanVariance.");
        }
        this.n = d;
    }

    @Override
    public MeanVariance put(double[] dArray) {
        double d;
        if (dArray.length <= 2) {
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.put(dArray[n]);
            }
            return this;
        }
        double d2 = 0.0;
        int n = dArray.length;
        int n3 = 0;
        while (n3 < n) {
            d2 += dArray[n];
        }
        double d3 = d2 / (double)dArray.length;
        double d4 = 0.0;
        n3 = 0;
        while (n3 < n) {
            d = dArray[n] - d3;
            d4 += d * d;
        }
        d = (double)dArray.length + this.n;
        double d5 = d3 - this.m1;
        double d6 = d5 * (double)dArray.length / d;
        this.m1 = (this.n * this.m1 + d2) / d;
        this.m2 += d4 + d5 * this.n * d6;
        this.n = d;
        return this;
    }

    @Override
    public MeanVariance put(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.put(dArray[i], dArray2[i]);
        }
        return this;
    }

    @Override
    public double getCount() {
        return this.n;
    }

    @Override
    public double getMean() {
        return this.m1;
    }

    public double getNaiveVariance() {
        return this.m2 / this.n;
    }

    public double getSampleVariance() {
        if (!(this.n > 1.0)) {
            throw new ArithmeticException("Cannot compute a reasonable sample variance with weight <= 1.0!");
        }
        return this.m2 / (this.n - 1.0);
    }

    public double getNaiveStddev() {
        return Math.sqrt(this.getNaiveVariance());
    }

    public double getSampleStddev() {
        return Math.sqrt(this.getSampleVariance());
    }

    public double normalizeValue(double d) {
        return (d - this.getMean()) / this.getSampleStddev();
    }

    public double denormalizeValue(double d) {
        return d * this.getSampleStddev() + this.getMean();
    }

    public static MeanVariance[] newArray(int n) {
        MeanVariance[] meanVarianceArray = new MeanVariance[n];
        for (int i = 0; i < n; ++i) {
            meanVarianceArray[i] = new MeanVariance();
        }
        return meanVarianceArray;
    }

    @Override
    public String toString() {
        return "MeanVariance(mean=" + this.getMean() + ",var=" + (this.n > 1.0 ? Double.valueOf(this.getSampleVariance()) : "n/a") + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.m2 = 0.0;
    }
}

