/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Percentage based Eigenpair filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns the first eigenpairs, whose sum of eigenvalues is higher than the given percentage of the sum of all eigenvalues.")
public class PercentageEigenPairFilter
implements EigenPairFilter {
    private static final Logging LOG = Logging.getLogger(PercentageEigenPairFilter.class);
    public static final double DEFAULT_ALPHA = 0.85;
    private double alpha;

    public PercentageEigenPairFilter(double d) {
        this.alpha = d;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        StringBuilder stringBuilder = new StringBuilder();
        if (LOG.isDebugging()) {
            stringBuilder.append("alpha = ").append(this.alpha);
            stringBuilder.append("\nsortedEigenPairs = ").append(sortedEigenPairs);
        }
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        double d = 0.0;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            d += eigenPair.getEigenvalue();
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\ntotalSum = ").append(d);
        }
        double d2 = 0.0;
        boolean bl = false;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            if ((d2 += eigenPair.getEigenvalue()) / d >= this.alpha) {
                if (!bl) {
                    bl = true;
                    arrayList.add(eigenPair);
                    continue;
                }
                arrayList2.add(eigenPair);
                continue;
            }
            arrayList.add(eigenPair);
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nstrong EigenPairs = ").append(arrayList);
            stringBuilder.append("\nweak EigenPairs = ").append(arrayList2);
            LOG.debugFine(stringBuilder.toString());
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALPHA_ID = new OptionID("pca.filter.alpha", "The share (0.0 to 1.0) of variance that needs to be explained by the 'strong' eigenvectors.The filter class will choose the number of strong eigenvectors by this share.");
        private double alpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.85);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected PercentageEigenPairFilter makeInstance() {
            return new PercentageEigenPairFilter(this.alpha);
        }
    }
}

