/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class BetaDistribution
extends AbstractDistribution {
    static final double NUM_PRECISION = 1.0E-15;
    static final double SWITCH = 3000.0;
    static final double[] GAUSSLEGENDRE_Y = new double[]{0.0021695375159141994, 0.011413521097787704, 0.027972308950302116, 0.05172701560049242, 0.08250222548434094, 0.12007019910960293, 0.1641528330075247, 0.21442376986779355, 0.27051082840644336, 0.33199876341447887, 0.39843234186401943, 0.46931971407375483, 0.5441360555665797, 0.6223274528803108, 0.7033150046559717, 0.7864991076831345, 0.8712638961906152, 0.9569818015262914};
    static final double[] GAUSSLEGENDRE_W = new double[]{0.005565719664244557, 0.01291594728406542, 0.020181515297735382, 0.027298621498568734, 0.03421381077029954, 0.04087575092364326, 0.04723508349026558, 0.05324471397775969, 0.0588601442453248, 0.06403979735501548, 0.06874532383573641, 0.07294188500565309, 0.07659841064587064, 0.07968782891207167, 0.0821872667043397, 0.08407821897966195, 0.08534668573933872, 0.08598327567039482};
    private final double alpha;
    private final double beta;
    private double logbab;

    public BetaDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public BetaDistribution(double d, double d2, Random random) {
        super(random);
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid parameters for Beta distribution.");
        }
        this.alpha = d;
        this.beta = d2;
        this.logbab = BetaDistribution.logBeta(d, d2);
    }

    public BetaDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid parameters for Beta distribution.");
        }
        this.alpha = d;
        this.beta = d2;
        this.logbab = BetaDistribution.logBeta(d, d2);
    }

    @Override
    public double pdf(double d) {
        if (d < 0.0 || d > 1.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (this.alpha > 1.0) {
                return 0.0;
            }
            if (this.alpha < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return this.beta;
        }
        if (d == 1.0) {
            if (this.beta > 1.0) {
                return 0.0;
            }
            if (this.beta < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return this.alpha;
        }
        return Math.exp(-this.logbab + Math.log(d) * (this.alpha - 1.0) + Math.log1p(-d) * (this.beta - 1.0));
    }

    @Override
    public double cdf(double d) {
        if (this.alpha <= 0.0 || this.beta <= 0.0 || Double.isNaN(this.alpha) || Double.isNaN(this.beta) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        if (this.alpha > 3000.0 && this.beta > 3000.0) {
            return BetaDistribution.regularizedIncBetaQuadrature(this.alpha, this.beta, d);
        }
        double d2 = Math.exp(-this.logbab + this.alpha * Math.log(d) + this.beta * Math.log1p(-d));
        if (d < (this.alpha + 1.0) / (this.alpha + this.beta + 2.0)) {
            return d2 * BetaDistribution.regularizedIncBetaCF(this.alpha, this.beta, d) / this.alpha;
        }
        return 1.0 - d2 * BetaDistribution.regularizedIncBetaCF(this.beta, this.alpha, 1.0 - d) / this.beta;
    }

    @Override
    public double quantile(double d) {
        if (d < 0.0 || d > 1.0 || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        if (d > 0.5) {
            return 1.0 - BetaDistribution.rawQuantile(1.0 - d, this.beta, this.alpha, this.logbab);
        }
        return BetaDistribution.rawQuantile(d, this.alpha, this.beta, this.logbab);
    }

    @Override
    public double nextRandom() {
        double d = GammaDistribution.nextRandom(this.alpha, 1.0, this.random);
        double d2 = GammaDistribution.nextRandom(this.beta, 1.0, this.random);
        return d / (d + d2);
    }

    @Override
    public String toString() {
        return "BetaDistribution(alpha=" + this.alpha + ", beta=" + this.beta + ")";
    }

    public static double cdf(double d, double d2, double d3) {
        return BetaDistribution.regularizedIncBeta(d, d2, d3);
    }

    public static double pdf(double d, double d2, double d3) {
        if (d2 <= 0.0 || d3 <= 0.0 || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0 || d > 1.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (d2 > 1.0) {
                return 0.0;
            }
            if (d2 < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return d3;
        }
        if (d == 1.0) {
            if (d3 > 1.0) {
                return 0.0;
            }
            if (d3 < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return d2;
        }
        return Math.exp(-BetaDistribution.logBeta(d2, d3) + Math.log(d) * (d2 - 1.0) + Math.log1p(-d) * (d3 - 1.0));
    }

    public static double logpdf(double d, double d2, double d3) {
        if (d2 <= 0.0 || d3 <= 0.0 || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0 || d > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            if (d2 > 1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (d2 < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.log(d3);
        }
        if (d == 1.0) {
            if (d3 > 1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (d3 < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.log(d2);
        }
        return -BetaDistribution.logBeta(d2, d3) + Math.log(d) * (d2 - 1.0) + Math.log1p(-d) * (d3 - 1.0);
    }

    public static double logBeta(double d, double d2) {
        return GammaDistribution.logGamma(d) + GammaDistribution.logGamma(d2) - GammaDistribution.logGamma(d + d2);
    }

    public static double regularizedIncBeta(double d, double d2, double d3) {
        if (d2 <= 0.0 || d3 <= 0.0 || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        if (d2 > 3000.0 && d3 > 3000.0) {
            return BetaDistribution.regularizedIncBetaQuadrature(d2, d3, d);
        }
        double d4 = Math.exp(-BetaDistribution.logBeta(d2, d3) + d2 * Math.log(d) + d3 * Math.log1p(-d));
        if (d < (d2 + 1.0) / (d2 + d3 + 2.0)) {
            return d4 * BetaDistribution.regularizedIncBetaCF(d2, d3, d) / d2;
        }
        return 1.0 - d4 * BetaDistribution.regularizedIncBetaCF(d3, d2, 1.0 - d) / d3;
    }

    protected static double regularizedIncBetaCF(double d, double d2, double d3) {
        double d4 = d + d2;
        double d5 = d + 1.0;
        double d6 = d - 1.0;
        double d7 = 1.0;
        double d8 = 1.0 - d4 * d3 / d5;
        if (Math.abs(d8) < 4.940656458412465E-309) {
            d8 = 4.940656458412465E-309;
        }
        double d9 = d8 = 1.0 / d8;
        for (int i = 1; i < 10000; ++i) {
            int n = 2 * i;
            double d10 = (double)i * (d2 - (double)i) * d3 / ((d6 + (double)n) * (d + (double)n));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 4.940656458412465E-309) {
                d8 = 4.940656458412465E-309;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 4.940656458412465E-309) {
                d7 = 4.940656458412465E-309;
            }
            d8 = 1.0 / d8;
            d9 *= d8 * d7;
            d10 = -(d + (double)i) * (d4 + (double)i) * d3 / ((d + (double)n) * (d5 + (double)n));
            if (Math.abs(d8 = 1.0 + d10 * d8) < 4.940656458412465E-309) {
                d8 = 4.940656458412465E-309;
            }
            if (Math.abs(d7 = 1.0 + d10 / d7) < 4.940656458412465E-309) {
                d7 = 4.940656458412465E-309;
            }
            d8 = 1.0 / d8;
            double d11 = d8 * d7;
            d9 *= d11;
            if (Math.abs(d11 - 1.0) <= 1.0E-15) break;
        }
        return d9;
    }

    protected static double regularizedIncBetaQuadrature(double d, double d2, double d3) {
        double d4;
        double d5 = d + d2;
        double d6 = d - 1.0;
        double d7 = d2 - 1.0;
        double d8 = d / d5;
        double d9 = Math.log(d8);
        double d10 = Math.log1p(-d8);
        double d11 = Math.sqrt(d * d2 / (d5 * d5 * (d5 + 1.0)));
        if (d3 > d / d5) {
            if (d3 >= 1.0) {
                return 1.0;
            }
            d4 = Math.min(1.0, Math.max(d8 + 10.0 * d11, d3 + 5.0 * d11));
        } else {
            if (d3 <= 0.0) {
                return 0.0;
            }
            d4 = Math.max(0.0, Math.min(d8 - 10.0 * d11, d3 - 5.0 * d11));
        }
        double d12 = 0.0;
        for (int i = 0; i < GAUSSLEGENDRE_Y.length; ++i) {
            d11 = d3 + (d4 - d3) * GAUSSLEGENDRE_Y[i];
            d12 += GAUSSLEGENDRE_W[i] * Math.exp(d6 * (Math.log(d11) - d9) + d7 * (Math.log1p(-d11) - d10));
        }
        double d13 = d12 * (d4 - d3) * Math.exp(d6 * d9 - GammaDistribution.logGamma(d) + d7 * d10 - GammaDistribution.logGamma(d2) + GammaDistribution.logGamma(d5));
        return d13 > 0.0 ? 1.0 - d13 : -d13;
    }

    public static double quantile(double d, double d2, double d3) {
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d) || d2 < 0.0 || d3 < 0.0) {
            return Double.NaN;
        }
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        if (d > 0.5) {
            return 1.0 - BetaDistribution.rawQuantile(1.0 - d, d3, d2, BetaDistribution.logBeta(d3, d2));
        }
        return BetaDistribution.rawQuantile(d, d2, d3, BetaDistribution.logBeta(d2, d3));
    }

    protected static double rawQuantile(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10 = Math.sqrt(-2.0 * Math.log(d));
        double d11 = d10 - (2.30753 + 0.27061 * d10) / (1.0 + (0.99229 + 0.04481 * d10) * d10);
        if (d2 > 1.0 && d3 > 1.0) {
            d9 = (d11 * d11 - 3.0) / 6.0;
            d8 = 1.0 / (d2 + d2 - 1.0);
            d7 = 1.0 / (d3 + d3 - 1.0);
            d6 = 2.0 / (d8 + d7);
            double d12 = d11 * Math.sqrt(d6 + d9) / d6 - (d7 - d8) * (d9 + 0.8333333333333334 - 2.0 / (3.0 * d6));
            d5 = d2 / (d2 + d3 * Math.exp(d12 + d12));
        } else {
            d9 = d3 + d3;
            d8 = 1.0 / (9.0 * d3);
            d7 = 1.0 - d8 + d11 * Math.sqrt(d8);
            d5 = (d8 = d9 * d7 * d7 * d7) <= 0.0 ? 1.0 - Math.exp((Math.log1p(-d) + Math.log(d3) + d4) / d3) : ((d8 = (4.0 * d2 + d9 - 2.0) / d8) <= 1.0 ? Math.exp((Math.log(d * d2) + d4) / d2) : 1.0 - 2.0 / (d8 + 1.0));
        }
        if (d5 < 3.0E-308 || d5 > 0.9999999999999998) {
            d5 = 0.5;
        }
        d10 = 1.0 - d2;
        d11 = 1.0 - d3;
        d9 = Math.max(1.0E-300, Math.pow(10.0, -13.0 - 2.5 / (d2 * d2) - 0.5 / (d * d)));
        d8 = 0.0;
        d7 = 0.0;
        d6 = 1.0;
        for (int i = 0; i < 1000; ++i) {
            double d13 = BetaDistribution.cdf(d5, d2, d3);
            if (Double.isInfinite(d13)) {
                return Double.NaN;
            }
            if ((d13 = (d13 - d) * Math.exp(d4 + d10 * Math.log(d5) + d11 * Math.log1p(-d5))) * d7 <= 0.0) {
                d8 = Math.max(Math.abs(d6), 3.0E-308);
            }
            double d14 = 1.0;
            double d15 = 0.0;
            for (int j = 0; j < 1000; ++j) {
                d6 = d14 * d13;
                if (Math.abs(d6) < d8 && (d15 = d5 - d6) >= 0.0 && d15 <= 1.0) {
                    if (d8 <= d9 || Math.abs(d13) <= d9) {
                        return d5;
                    }
                    if (d15 != 0.0 && d15 != 1.0) break;
                }
                d14 /= 3.0;
            }
            if (Math.abs(d15 - d5) < 1.0E-15 * d5) {
                return d5;
            }
            d5 = d15;
            d7 = d13;
        }
        throw new AbortException("Beta quantile computation did not converge.");
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID ALPHA_ID = new OptionID("distribution.beta.alpha", "Beta distribution alpha parameter");
        public static final OptionID BETA_ID = new OptionID("distribution.beta.beta", "Beta distribution beta parameter");
        double alpha;
        double beta;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(ALPHA_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.alpha = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(BETA_ID))) {
                this.beta = doubleParameter.doubleValue();
            }
        }

        @Override
        protected BetaDistribution makeInstance() {
            return new BetaDistribution(this.alpha, this.beta, this.rnd);
        }
    }
}

