/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class LogNormalLMMEstimator
extends AbstractLMMEstimator<LogNormalDistribution> {
    public static final LogNormalLMMEstimator STATIC = new LogNormalLMMEstimator();
    private static final double A0 = 2.0466534;
    private static final double A1 = -3.6544371;
    private static final double A2 = 1.8396733;
    private static final double A3 = -0.20360244;
    private static final double B1 = -2.0182173;
    private static final double B2 = 1.2420401;
    private static final double B3 = -0.21741801;

    private LogNormalLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public LogNormalDistribution estimateFromLMoments(double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (!(dArray[1] > 0.0 && Math.abs(dArray[2]) < 1.0 && dArray[2] > 0.0)) {
            throw new ArithmeticException("L-Moments invalid");
        }
        double d6 = dArray[2];
        if (Math.abs(d6) >= 0.95) {
            d5 = 0.0;
            d4 = -1.0;
            d3 = 0.0;
        } else if (Math.abs(d6) < 1.0E-8) {
            d5 = dArray[0];
            d4 = dArray[1] * MathUtil.SQRTPI;
            d3 = 0.0;
        } else {
            d2 = d6 * d6;
            d3 = -d6 * (2.0466534 + d2 * (-3.6544371 + d2 * (1.8396733 + d2 * -0.20360244))) / (1.0 + d2 * (-2.0182173 + d2 * (1.2420401 + d2 * -0.21741801)));
            d = Math.exp(0.5 * d3 * d3);
            d4 = dArray[1] * d3 / (d * NormalDistribution.erf(0.5 * d3));
            d5 = dArray[0] + d4 * (d - 1.0) / d3;
        }
        d2 = -d3;
        d = d4 / d2;
        return new LogNormalDistribution(Math.log(d), Math.max(d2, Double.MIN_NORMAL), d5 - d);
    }

    @Override
    public Class<? super LogNormalDistribution> getDistributionClass() {
        return LogNormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogNormalLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

