/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedUpdatableHeap;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TiedTopBoundedUpdatableHeap<E>
extends TopBoundedUpdatableHeap<E> {
    private List<E> ties = new ArrayList();

    public TiedTopBoundedUpdatableHeap(int n, Comparator<? super E> comparator) {
        super(n, comparator);
    }

    public TiedTopBoundedUpdatableHeap(int n) {
        this(n, (Comparator<E>)null);
    }

    @Override
    public int size() {
        return super.size() + this.ties.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.ties.clear();
    }

    @Override
    public void offerAt(int n, E e) {
        if (n == -1) {
            Iterator<E> iterator = this.ties.iterator();
            while (iterator.hasNext()) {
                E e2 = iterator.next();
                if (!e.equals(e2)) continue;
                if (this.compare(e, e2) <= 0) {
                    iterator.remove();
                    this.index.remove(e2);
                }
                return;
            }
            throw new AbortException("Heap corrupt - should not be reached");
        }
        if (n >= 0 && this.ties.size() > 0 && this.compare(e, this.ties.get(0)) < 0) {
            this.removeAt(n);
            this.index.remove(e);
            E e3 = this.ties.remove(this.ties.size() - 1);
            super.offerAt(Integer.MIN_VALUE, e3);
            return;
        }
        super.offerAt(n, e);
    }

    @Override
    public E peek() {
        if (this.ties.isEmpty()) {
            return super.peek();
        }
        return this.ties.get(this.ties.size() - 1);
    }

    @Override
    public E poll() {
        if (this.ties.isEmpty()) {
            return (E)super.poll();
        }
        E e = this.ties.remove(this.ties.size() - 1);
        this.index.remove(e);
        return e;
    }

    @Override
    protected void handleOverflow(E e) {
        boolean bl = false;
        if (this.comparator == null) {
            Comparable comparable = (Comparable)e;
            if (comparable.compareTo(this.queue[0]) == 0) {
                bl = true;
            }
        } else if (this.comparator.compare(e, this.queue[0]) == 0) {
            bl = true;
        }
        if (bl) {
            this.ties.add(e);
            this.index.put(e, -1);
        } else {
            this.index.remove(e);
            for (Object e2 : this.ties) {
                this.index.remove(e2);
            }
            this.ties.clear();
        }
    }
}

