/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CoreObjectsModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.geometry.AlphaShape;
import de.lmu.ifi.dbs.elki.math.geometry.GrahamScanConvexHull2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayListIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ClusterHullVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Hull (Scatterplot)";
    Parameterizer settings;

    public ClusterHullVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation, this);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(13);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALPHA_ID = new OptionID("hull.alpha", "Alpha value for hull drawing (in projected space!).");
        double alpha = Double.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, Double.POSITIVE_INFINITY);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ClusterHullVisualization makeInstance() {
            return new ClusterHullVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CLUSTERHULL = "cluster-hull";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double d;
            this.setupCanvas();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy clusterStylingPolicy = (ClusterStylingPolicy)stylingPolicy;
            Clustering<?> clustering = clusterStylingPolicy.getClustering();
            CanvasSize canvasSize = this.proj.estimateViewport();
            double d2 = canvasSize.getDiffX() * canvasSize.getDiffY();
            List<Cluster<?>> list = clustering.getAllClusters();
            List<Cluster<?>> list2 = clustering.getToplevelClusters();
            Hierarchy<Cluster<Model>> hierarchy = clustering.getClusterHierarchy();
            boolean bl = list.size() == list2.size();
            double d3 = d = bl ? 0.5 : 0.5;
            if (ClusterHullVisualization.this.settings.alpha >= Double.POSITIVE_INFINITY) {
                HashMap<Object, DoubleObjPair<Polygon>> hashMap = new HashMap<Object, DoubleObjPair<Polygon>>(list.size());
                for (Cluster<Model> arrayList : list2) {
                    this.buildHullsRecursively(arrayList, hierarchy, hashMap);
                }
                for (Cluster<?> cluster : list) {
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    SVGPath sVGPath;
                    DoubleObjPair doubleObjPair = (DoubleObjPair)hashMap.get(cluster);
                    DoubleObjPair doubleObjPair2 = (DoubleObjPair)hashMap.get(cluster.getModel());
                    if (doubleObjPair != null && doubleObjPair.second != null && ((Polygon)doubleObjPair.second).size() > 1) {
                        sVGPath = new SVGPath((Polygon)doubleObjPair.second);
                        d7 = SpatialUtil.volume((SpatialComparable)doubleObjPair.second);
                        d6 = 1.0 - d7 / d2;
                        d5 = doubleObjPair.first / (double)this.rel.size();
                        d4 = doubleObjPair2 == null ? 1.0 : 0.5;
                        double d8 = d4 * d * Math.sqrt(d5 * d6);
                        this.addCSSClasses(this.svgp, clusterStylingPolicy.getStyleForCluster(cluster), d8);
                        Element element = sVGPath.makeElement(this.svgp);
                        SVGUtil.addCSSClass(element, CLUSTERHULL + clusterStylingPolicy.getStyleForCluster(cluster));
                        this.layer.appendChild(element);
                    }
                    if (doubleObjPair2 == null || doubleObjPair2.second == null || ((Polygon)doubleObjPair2.second).size() <= 1) continue;
                    sVGPath = new SVGPath((Polygon)doubleObjPair2.second);
                    d7 = SpatialUtil.volume((SpatialComparable)doubleObjPair2.second);
                    d6 = 1.0 - d7 / d2;
                    d5 = doubleObjPair2.first / (double)this.rel.size();
                    d4 = 0.5 * d * Math.sqrt(d5 * d6);
                    this.addCSSClasses(this.svgp, clusterStylingPolicy.getStyleForCluster(cluster), d4);
                    Element element = sVGPath.makeElement(this.svgp);
                    SVGUtil.addCSSClass(element, CLUSTERHULL + clusterStylingPolicy.getStyleForCluster(cluster));
                    this.layer.appendChild(element);
                }
            } else {
                for (Cluster<Model> cluster : list) {
                    List<Object> list3;
                    ArrayList<Vector> arrayList = new ArrayList<Vector>();
                    double d9 = this.addRecursively(arrayList, hierarchy, cluster);
                    if (arrayList.size() < 1) continue;
                    if (arrayList.size() > 2) {
                        list3 = new AlphaShape(arrayList, ClusterHullVisualization.this.settings.alpha * 100.0).compute();
                    } else {
                        list3 = new ArrayList<Polygon>(1);
                        list3.add(new Polygon(arrayList));
                    }
                    for (Polygon polygon : list3) {
                        SVGPath sVGPath = new SVGPath(polygon);
                        Element element = sVGPath.makeElement(this.svgp);
                        this.addCSSClasses(this.svgp, clusterStylingPolicy.getStyleForCluster(cluster), d * d9 / (double)this.rel.size());
                        SVGUtil.addCSSClass(element, CLUSTERHULL + clusterStylingPolicy.getStyleForCluster(cluster));
                        this.layer.appendChild(element);
                    }
                }
            }
        }

        private DoubleObjPair<Polygon> buildHullsRecursively(Cluster<Model> cluster, Hierarchy<Cluster<Model>> hierarchy, Map<Object, DoubleObjPair<Polygon>> map) {
            int n;
            double d;
            Model model = cluster.getModel();
            DBIDs dBIDs = cluster.getIDs();
            boolean bl = false;
            DBIDs dBIDs2 = null;
            if (model instanceof CoreObjectsModel) {
                dBIDs2 = ((CoreObjectsModel)model).getCoreObjects();
                bl = dBIDs2.size() > 0;
            }
            GrahamScanConvexHull2D grahamScanConvexHull2D = new GrahamScanConvexHull2D();
            GrahamScanConvexHull2D grahamScanConvexHull2D2 = bl ? new GrahamScanConvexHull2D() : null;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDIter));
                if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                    Vector vector = new Vector(dArray);
                    grahamScanConvexHull2D.add(vector);
                    if (bl && dBIDs2.contains(dBIDIter)) {
                        grahamScanConvexHull2D2.add(vector);
                    }
                }
                dBIDIter.advance();
            }
            double d2 = dBIDs.size();
            double d3 = d = bl ? (double)dBIDs2.size() : 0.0;
            if (hierarchy != null && map != null && (n = hierarchy.numChildren(cluster)) > 0) {
                Hierarchy.Iter<Cluster<Model>> iter = hierarchy.iterChildren(cluster);
                while (iter.valid()) {
                    Cluster<Model> cluster2 = iter.get();
                    DoubleObjPair<Polygon> doubleObjPair = map.get(cluster2);
                    if (doubleObjPair == null) {
                        doubleObjPair = this.buildHullsRecursively(cluster2, hierarchy, map);
                    }
                    Object object = ((Polygon)doubleObjPair.second).iter();
                    while (((ArrayListIter)object).valid()) {
                        grahamScanConvexHull2D.add((Vector)((ArrayListIter)object).get());
                        ((ArrayListIter)object).advance();
                    }
                    if (bl && (object = map.get(cluster2.getModel())) != null) {
                        ArrayListIter<Vector> arrayListIter = ((Polygon)((DoubleObjPair)object).second).iter();
                        while (arrayListIter.valid()) {
                            grahamScanConvexHull2D2.add(arrayListIter.get());
                            arrayListIter.advance();
                        }
                        d += ((DoubleObjPair)object).first / (double)n;
                    }
                    d2 += doubleObjPair.first / (double)n;
                    iter.advance();
                }
            }
            DoubleObjPair<Polygon> doubleObjPair = new DoubleObjPair<Polygon>(d2, grahamScanConvexHull2D.getHull());
            map.put(cluster, doubleObjPair);
            if (bl) {
                map.put(model, new DoubleObjPair<Polygon>(d, grahamScanConvexHull2D2.getHull()));
            }
            return doubleObjPair;
        }

        private double addRecursively(ArrayList<Vector> arrayList, Hierarchy<Cluster<Model>> hierarchy, Cluster<Model> cluster) {
            DBIDs dBIDs = cluster.getIDs();
            double d = dBIDs.size();
            Iter iter = dBIDs.iter();
            while (iter.valid()) {
                double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)((Object)iter)));
                if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
                    arrayList.add(new Vector(dArray));
                }
                iter.advance();
            }
            iter = hierarchy.iterChildren(cluster);
            while (iter.valid()) {
                d += 0.5 * this.addRecursively(arrayList, hierarchy, (Cluster)iter.get());
                iter.advance();
            }
            return d;
        }

        private void addCSSClasses(SVGPlot sVGPlot, int n, double d) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            CSSClass cSSClass = new CSSClass(this, CLUSTERHULL + n);
            cSSClass.setStatement("stroke-width", 0.5 * styleLibrary.getLineWidth("plot"));
            String string = colorLibrary.getColor(n);
            cSSClass.setStatement("stroke", string);
            cSSClass.setStatement("fill", string);
            cSSClass.setStatement("fill-opacity", d);
            sVGPlot.addCSSClassOrLogError(cSSClass);
        }
    }
}

