/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;

public class ConverterFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -5373058011025481738L;
    public static final int UNHANDLED_DIALOG = 0;
    public static final int LOADER_DIALOG = 1;
    public static final int SAVER_DIALOG = 2;
    protected ConverterFileChooser m_Self;
    protected static Vector<ExtensionFileFilter> m_LoaderFileFilters;
    protected static Vector<ExtensionFileFilter> m_SaverFileFilters;
    protected int m_DialogType;
    protected Object m_CurrentConverter;
    protected JButton m_ConfigureButton;
    protected PropertyChangeListener m_Listener;
    protected FileFilter m_LastFilter;
    protected Capabilities m_CapabilitiesFilter;
    protected boolean m_OverwriteWarning = true;
    protected boolean m_FileMustExist = true;
    protected JCheckBox m_CheckBoxOptions;
    protected JLabel m_LabelOptions;
    protected GenericObjectEditor m_Editor = null;
    protected int m_EditorResult;
    protected boolean m_CoreConvertersOnly = false;

    static {
        ConverterFileChooser.initDefaultFilters();
    }

    public static void initDefaultFilters() {
        ConverterFileChooser.initFilters(true, ConverterUtils.getFileLoaders());
        ConverterFileChooser.initFilters(false, ConverterUtils.getFileSavers());
    }

    public ConverterFileChooser() {
        this.initialize();
    }

    public ConverterFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    public ConverterFileChooser(String currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    protected void initialize() {
        this.m_Self = this;
        this.m_CheckBoxOptions = new JCheckBox("Invoke options dialog");
        this.m_CheckBoxOptions.setMnemonic('I');
        this.m_LabelOptions = new JLabel("<html><br>Note:<br><br>Some file formats offer additional<br>options which can be customized<br>when invoking the options dialog.</html>");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_CheckBoxOptions, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.m_LabelOptions, "North");
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)panel2, "Center");
        this.setAccessory(panel);
        this.m_Editor = new GenericObjectEditor(false);
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConverterFileChooser.this.m_EditorResult = 0;
                ConverterFileChooser.this.m_CurrentConverter = ConverterFileChooser.this.m_Editor.getValue();
                try {
                    ((FileSourcedConverter)ConverterFileChooser.this.m_CurrentConverter).setFile(((FileSourcedConverter)ConverterFileChooser.this.m_CurrentConverter).retrieveFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConverterFileChooser.this.m_EditorResult = 1;
            }
        });
    }

    protected Vector<ExtensionFileFilter> filterNonCoreLoaderFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (!this.getCoreConvertersOnly()) {
            result = list;
        } else {
            result = new Vector();
            int i = 0;
            while (i < list.size()) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileLoader loader = ConverterUtils.getLoaderForExtension(filter.getExtensions()[0]);
                if (ConverterUtils.isCoreFileLoader(loader.getClass().getName())) {
                    result.add(filter);
                }
                ++i;
            }
        }
        return result;
    }

    protected Vector<ExtensionFileFilter> filterNonCoreSaverFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (!this.getCoreConvertersOnly()) {
            result = list;
        } else {
            result = new Vector();
            int i = 0;
            while (i < list.size()) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileSaver saver = ConverterUtils.getSaverForExtension(filter.getExtensions()[0]);
                if (ConverterUtils.isCoreFileSaver(saver.getClass().getName())) {
                    result.add(filter);
                }
                ++i;
            }
        }
        return result;
    }

    protected Vector<ExtensionFileFilter> filterSaverFileFilters(Vector<ExtensionFileFilter> list) {
        Vector<ExtensionFileFilter> result;
        if (this.m_CapabilitiesFilter == null) {
            result = list;
        } else {
            result = new Vector();
            int i = 0;
            while (i < list.size()) {
                ExtensionFileFilter filter = list.get(i);
                AbstractFileSaver saver = ConverterUtils.getSaverForExtension(filter.getExtensions()[0]);
                if (saver.getCapabilities().supports(this.m_CapabilitiesFilter)) {
                    result.add(filter);
                }
                ++i;
            }
        }
        return result;
    }

    protected static void initFilters(boolean loader, Vector<String> classnames) {
        if (loader) {
            m_LoaderFileFilters = new Vector();
        } else {
            m_SaverFileFilters = new Vector();
        }
        int i = 0;
        while (i < classnames.size()) {
            String desc;
            String[] ext;
            FileSourcedConverter converter;
            Class<?> cls;
            String classname = classnames.get(i);
            try {
                cls = Class.forName(classname);
                converter = (FileSourcedConverter)cls.newInstance();
                ext = converter.getFileExtensions();
                desc = converter.getFileDescription();
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter != null) {
                ExtensionFileFilter filter;
                int n;
                if (loader) {
                    n = 0;
                    while (n < ext.length) {
                        filter = new ExtensionFileFilter(ext[n], String.valueOf(desc) + " (*" + ext[n] + ")");
                        m_LoaderFileFilters.add(filter);
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < ext.length) {
                        filter = new ExtensionFileFilter(ext[n], String.valueOf(desc) + " (*" + ext[n] + ")");
                        m_SaverFileFilters.add(filter);
                        ++n;
                    }
                }
            }
            ++i;
        }
    }

    protected void initGUI(int dialogType) {
        boolean acceptAll = this.isAcceptAllFileFilterUsed();
        this.resetChoosableFileFilters();
        this.setAcceptAllFileFilterUsed(acceptAll);
        Vector<ExtensionFileFilter> list = dialogType == 1 ? this.filterNonCoreLoaderFileFilters(m_LoaderFileFilters) : this.filterSaverFileFilters(this.filterNonCoreSaverFileFilters(m_SaverFileFilters));
        int i = 0;
        while (i < list.size()) {
            this.addChoosableFileFilter(list.get(i));
            ++i;
        }
        if (list.size() > 0) {
            if (this.m_LastFilter == null || !list.contains(this.m_LastFilter)) {
                this.setFileFilter(list.get(0));
            } else {
                this.setFileFilter(this.m_LastFilter);
            }
        }
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    ConverterFileChooser.this.updateCurrentConverter();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        if (dialogType == 1) {
            this.m_Editor.setClassType(AbstractFileLoader.class);
            this.m_Editor.setValue(new ArffLoader());
        } else {
            this.m_Editor.setClassType(AbstractFileSaver.class);
            this.m_Editor.setValue(new ArffSaver());
        }
        this.updateCurrentConverter();
    }

    public void setCapabilitiesFilter(Capabilities value) {
        this.m_CapabilitiesFilter = (Capabilities)value.clone();
    }

    public Capabilities getCapabilitiesFilter() {
        if (this.m_CapabilitiesFilter != null) {
            return (Capabilities)this.m_CapabilitiesFilter.clone();
        }
        return null;
    }

    public void setOverwriteWarning(boolean value) {
        this.m_OverwriteWarning = value;
    }

    public boolean getOverwriteWarning() {
        return this.m_OverwriteWarning;
    }

    public void setFileMustExist(boolean value) {
        this.m_FileMustExist = value;
    }

    public boolean getFileMustExist() {
        return this.m_FileMustExist;
    }

    public void setCoreConvertersOnly(boolean value) {
        this.m_CoreConvertersOnly = value;
    }

    public boolean getCoreConvertersOnly() {
        return this.m_CoreConvertersOnly;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        if (this.m_DialogType == 0) {
            throw new IllegalStateException("Either use showOpenDialog or showSaveDialog!");
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    public int showOpenDialog(Component parent) {
        String[] extensions;
        String filename;
        this.m_DialogType = 1;
        this.m_CurrentConverter = null;
        this.initGUI(1);
        int result = super.showOpenDialog(parent);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0 && this.getSelectedFile().isFile() && this.getFileFilter() instanceof ExtensionFileFilter && !(filename = this.getSelectedFile().getAbsolutePath()).endsWith((extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            filename = String.valueOf(filename) + extensions[0];
            this.setSelectedFile(new File(filename));
        }
        if (result == 0 && this.getFileMustExist() && this.getSelectedFile().isFile() && !this.getSelectedFile().exists()) {
            int retVal = JOptionPane.showConfirmDialog(parent, "The file '" + this.getSelectedFile() + "' does not exist - please select again!");
            result = retVal == 0 ? this.showOpenDialog(parent) : 1;
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(1);
            if (this.m_CheckBoxOptions.isSelected()) {
                this.m_EditorResult = 1;
                this.m_Editor.setValue(this.m_CurrentConverter);
                PropertyDialog pd = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_Editor) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_Editor);
                pd.setVisible(true);
                result = this.m_EditorResult;
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        String[] extensions;
        String filename;
        this.m_DialogType = 2;
        this.m_CurrentConverter = null;
        this.initGUI(2);
        boolean acceptAll = this.isAcceptAllFileFilterUsed();
        FileFilter currentFilter = this.getFileFilter();
        File currentFile = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.getFileFilter() instanceof ExtensionFileFilter && !(filename = this.getSelectedFile().getAbsolutePath()).endsWith((extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions())[0])) {
            filename = String.valueOf(filename) + extensions[0];
            this.setSelectedFile(new File(filename));
        }
        currentFilter = this.getFileFilter();
        currentFile = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(acceptAll);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0 && this.getOverwriteWarning() && this.getSelectedFile().exists()) {
            int retVal = JOptionPane.showConfirmDialog(parent, "The file '" + this.getSelectedFile() + "' already exists - overwrite it?");
            result = retVal == 0 ? 0 : (retVal == 1 ? this.showSaveDialog(parent) : 1);
        }
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(2);
            if (this.m_CheckBoxOptions.isSelected()) {
                this.m_EditorResult = 1;
                this.m_Editor.setValue(this.m_CurrentConverter);
                PropertyDialog pd = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_Editor) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_Editor);
                pd.setVisible(true);
                result = this.m_EditorResult;
            }
        }
        return result;
    }

    public AbstractFileLoader getLoader() {
        this.configureCurrentConverter(1);
        if (this.m_CurrentConverter instanceof AbstractFileSaver) {
            return null;
        }
        return (AbstractFileLoader)this.m_CurrentConverter;
    }

    public AbstractFileSaver getSaver() {
        this.configureCurrentConverter(2);
        if (this.m_CurrentConverter instanceof AbstractFileLoader) {
            return null;
        }
        return (AbstractFileSaver)this.m_CurrentConverter;
    }

    protected void updateCurrentConverter() {
        if (this.getFileFilter() == null) {
            return;
        }
        if (!this.isAcceptAllFileFilterUsed()) {
            String[] extensions = ((ExtensionFileFilter)this.getFileFilter()).getExtensions();
            EnvironmentHandler newConverter = this.m_DialogType == 1 ? ConverterUtils.getLoaderForExtension(extensions[0]) : ConverterUtils.getSaverForExtension(extensions[0]);
            try {
                if (this.m_CurrentConverter == null) {
                    this.m_CurrentConverter = newConverter;
                } else if (!this.m_CurrentConverter.getClass().equals(newConverter.getClass())) {
                    this.m_CurrentConverter = newConverter;
                }
            }
            catch (Exception e) {
                this.m_CurrentConverter = null;
                e.printStackTrace();
            }
        } else {
            this.m_CurrentConverter = null;
        }
    }

    protected void configureCurrentConverter(int dialogType) {
        if (this.getSelectedFile() == null || this.getSelectedFile().isDirectory()) {
            return;
        }
        String filename = this.getSelectedFile().getAbsolutePath();
        if (this.m_CurrentConverter == null) {
            if (dialogType == 1) {
                this.m_CurrentConverter = ConverterUtils.getLoaderForFile(filename);
            } else if (dialogType == 2) {
                this.m_CurrentConverter = ConverterUtils.getSaverForFile(filename);
            } else {
                throw new IllegalStateException("Cannot determine loader/saver!");
            }
            if (this.m_CurrentConverter == null) {
                return;
            }
        }
        try {
            File currFile = ((FileSourcedConverter)this.m_CurrentConverter).retrieveFile();
            if (currFile == null || !currFile.getAbsolutePath().equals(filename)) {
                ((FileSourcedConverter)this.m_CurrentConverter).setFile(new File(filename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ConverterFileChooser fc = new ConverterFileChooser();
        int retVal = fc.showOpenDialog(null);
        if (retVal == 0) {
            AbstractFileLoader loader = fc.getLoader();
            Instances data = loader.getDataSet();
            retVal = fc.showSaveDialog(null);
            if (retVal == 0) {
                AbstractFileSaver saver = fc.getSaver();
                saver.setInstances(data);
                saver.writeBatch();
            } else {
                System.out.println("Saving aborted!");
            }
        } else {
            System.out.println("Loading aborted!");
        }
    }
}

